/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.ws.common.DOMWriter;
import org.jboss.ws.common.concurrent.CopyJob;
import org.jboss.wsf.test.JBossWSTestHelper;
import org.jboss.wsf.test.WrapThreadContextClassLoader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@ExtendWith(value={TestResultExtension.class})
public abstract class JBossWSTest
extends Assertions {
    protected static Logger log = Logger.getLogger((String)JBossWSTest.class.getName());
    public static final String SYSPROP_PROCESS_TIMEOUT = "test.process.wait.timeout";
    public static final String CXF_TESTS_GROUP_QUALIFIER = "cxf-tests";
    public static final String SHARED_TESTS_GROUP_QUALIFIER = "shared-tests";
    private static final int PROCESS_TIMEOUT = Integer.getInteger("test.process.wait.timeout", File.pathSeparatorChar == ':' ? 10 : 30);

    public static void executeCommand(String command) throws IOException {
        JBossWSTest.executeCommand(command, null, null, null);
    }

    public static void executeCommand(String command, String message) throws IOException {
        JBossWSTest.executeCommand(command, null, message, null);
    }

    public static void executeCommand(String command, OutputStream os) throws IOException {
        JBossWSTest.executeCommand(command, os, null, null);
    }

    public static void executeCommand(String command, OutputStream os, String message) throws IOException {
        JBossWSTest.executeCommand(command, os, message, null);
    }

    public static void executeCommand(String command, OutputStream os, String message, Map<String, String> env) throws IOException {
        if (command == null) {
            throw new NullPointerException("Command cannot be null");
        }
        log.info((Object)("Executing command: " + command));
        StringTokenizer st = new StringTokenizer(command, " \t\r");
        LinkedList<String> tokenizedCommand = new LinkedList<String>();
        while (st.hasMoreTokens()) {
            tokenizedCommand.add(st.nextToken());
        }
        try {
            JBossWSTest.executeCommand(tokenizedCommand, os, message, env);
        }
        catch (IOException e) {
            log.warn((Object)"Make sure there are no whitespaces in command paths", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeCommand(List<String> command, OutputStream os, String message, Map<String, String> env) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(command);
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            pb.environment().put("NOPAUSE", "true");
        }
        if (env != null) {
            for (String variable : env.keySet()) {
                pb.environment().put(variable, env.get(variable));
            }
        }
        Process p = pb.start();
        CopyJob inputStreamJob = new CopyJob(p.getInputStream(), os == null ? System.out : os);
        CopyJob errorStreamJob = new CopyJob(p.getErrorStream(), (OutputStream)System.err);
        Thread inputJob = new Thread((Runnable)inputStreamJob);
        Thread outputJob = new Thread((Runnable)errorStreamJob);
        inputJob.start();
        outputJob.start();
        try {
            boolean exited = p.waitFor(PROCESS_TIMEOUT, TimeUnit.SECONDS);
            JBossWSTest.assertTrue((boolean)exited, (String)("Process isn't exited in " + PROCESS_TIMEOUT + " seconds"));
            String fallbackMessage = "Process did exit with status " + p.exitValue();
            JBossWSTest.assertTrue((p.exitValue() == 0 ? 1 : 0) != 0, (String)(message != null ? message : fallbackMessage));
        }
        catch (InterruptedException ie) {
            ie.printStackTrace(System.err);
        }
        finally {
            inputStreamJob.kill();
            errorStreamJob.kill();
            p.destroy();
        }
    }

    public static MBeanServerConnection getServer() throws NamingException {
        return JBossWSTestHelper.getServer();
    }

    public static boolean isIntegrationCXF() {
        return JBossWSTestHelper.isIntegrationCXF();
    }

    public static String getServerHost() {
        return JBossWSTestHelper.getServerHost();
    }

    public static String getInitialContextFactory() {
        return JBossWSTestHelper.getInitialContextFactory();
    }

    public static String getRemotingProtocol() {
        return JBossWSTestHelper.getRemotingProtocol();
    }

    public static int getServerPort() {
        return JBossWSTestHelper.getServerPort();
    }

    public static int getServerPort(String groupQualifier, String containerQualifier) {
        return JBossWSTestHelper.getServerPort(groupQualifier, containerQualifier);
    }

    public static int getSecureServerPort(String groupQualifier, String containerQualifier) {
        return JBossWSTestHelper.getSecureServerPort(groupQualifier, containerQualifier);
    }

    public static File getArchiveFile(String archive) {
        return JBossWSTestHelper.getArchiveFile(archive);
    }

    public static URL getArchiveURL(String archive) throws MalformedURLException {
        return JBossWSTestHelper.getArchiveURL(archive);
    }

    public static File getResourceFile(String resource) {
        return JBossWSTestHelper.getResourceFile(resource);
    }

    public static URL getResourceURL(String resource) throws MalformedURLException {
        return JBossWSTestHelper.getResourceURL(resource);
    }

    public static File createResourceFile(String filename) {
        File resDir = new File(JBossWSTestHelper.getTestResourcesDir());
        return new File(resDir.getAbsolutePath() + File.separator + filename);
    }

    public static File createResourceFile(File parent, String filename) {
        return new File(parent, filename);
    }

    public static InitialContext getServerInitialContext() throws NamingException, IOException {
        return JBossWSTest.getServerInitialContext(null, null);
    }

    public static InitialContext getServerInitialContext(String groupQualifier, String containerQualifier) throws NamingException, IOException {
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.factory.initial", JBossWSTest.getInitialContextFactory());
        env.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming:org.jboss.naming.remote.client");
        env.put("jboss.naming.client.connect.options.org.xnio.Options.SASL_POLICY_NOPLAINTEXT", "false");
        env.put("jboss.naming.client.security.callback.handler.class", "org.jboss.wsf.test.CallbackHandler");
        env.put("jboss.naming.client.ejb.context", "true");
        env.put("java.naming.provider.url", JBossWSTest.getRemotingProtocol() + "://" + JBossWSTest.getServerHost() + ":" + JBossWSTest.getServerPort(groupQualifier, containerQualifier));
        return new InitialContext(env);
    }

    public static void assertEquals(Element expElement, Element wasElement, boolean ignoreWhitespace) {
        JBossWSTest.normalizeWhitespace(expElement, ignoreWhitespace);
        JBossWSTest.normalizeWhitespace(wasElement, ignoreWhitespace);
        String expStr = DOMWriter.printNode((Node)expElement, (boolean)false);
        String wasStr = DOMWriter.printNode((Node)wasElement, (boolean)false);
        if (!expStr.equals(wasStr)) {
            System.out.println("\nExp: " + expStr + "\nWas: " + wasStr);
        }
        JBossWSTest.assertEquals(expStr, wasStr);
    }

    public static void assertEquals(Element expElement, Element wasElement) {
        JBossWSTest.assertEquals(expElement, wasElement, false);
    }

    public static void assertEquals(Object exp, Object was) {
        if (exp instanceof Object[] && was instanceof Object[]) {
            JBossWSTest.assertArrayEquals((Object[])((Object[])exp), (Object[])((Object[])was));
        } else if (exp instanceof byte[] && was instanceof byte[]) {
            JBossWSTest.assertArrayEquals((byte[])((byte[])exp), (byte[])((byte[])was));
        } else if (exp instanceof boolean[] && was instanceof boolean[]) {
            JBossWSTest.assertArrayEquals((boolean[])((boolean[])exp), (boolean[])((boolean[])was));
        } else if (exp instanceof short[] && was instanceof short[]) {
            JBossWSTest.assertArrayEquals((short[])((short[])exp), (short[])((short[])was));
        } else if (exp instanceof int[] && was instanceof int[]) {
            JBossWSTest.assertArrayEquals((int[])((int[])exp), (int[])((int[])was));
        } else if (exp instanceof long[] && was instanceof long[]) {
            JBossWSTest.assertArrayEquals((long[])((long[])exp), (long[])((long[])was));
        } else if (exp instanceof float[] && was instanceof float[]) {
            JBossWSTest.assertArrayEquals((float[])((float[])exp), (float[])((float[])was));
        } else if (exp instanceof double[] && was instanceof double[]) {
            JBossWSTest.assertArrayEquals((double[])((double[])exp), (double[])((double[])was));
        } else {
            Assertions.assertEquals((Object)exp, (Object)was);
        }
    }

    private static void normalizeWhitespace(Element element, boolean ignoreWhitespace) {
        boolean hasChildElement = false;
        ArrayList<Node> toDetach = new ArrayList<Node>();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String nodeValue;
            Node node = childNodes.item(i);
            if (node.getNodeType() == 3 && (nodeValue = node.getNodeValue()).trim().length() == 0) {
                toDetach.add(node);
            }
            if (node.getNodeType() != 1) continue;
            JBossWSTest.normalizeWhitespace((Element)node, ignoreWhitespace);
            hasChildElement = true;
        }
        if (hasChildElement || ignoreWhitespace) {
            for (Node whiteSpaceNode : toDetach) {
                element.removeChild(whiteSpaceNode);
            }
        }
    }

    public String getClientJarPaths() {
        return null;
    }

    public static class TestResultExtension
    implements TestWatcher,
    BeforeEachCallback,
    AfterEachCallback {
        private ClassLoader classLoader = null;

        public void afterEach(ExtensionContext ctx) throws Exception {
            if (this.classLoader != null && ctx.getElement().isPresent() && ((AnnotatedElement)ctx.getElement().get()).isAnnotationPresent(WrapThreadContextClassLoader.class)) {
                Thread.currentThread().setContextClassLoader(this.classLoader);
            }
        }

        public void beforeEach(ExtensionContext ctx) throws Exception {
            Method cjpMethod = ctx.getRequiredTestClass().getMethod("getClientJarPaths", new Class[0]);
            String cjp = (String)cjpMethod.invoke(ctx.getRequiredTestInstance(), new Object[0]);
            if (cjp == null || cjp.trim().isEmpty()) {
                return;
            }
            if (ctx.getElement().isPresent() && ((AnnotatedElement)ctx.getElement().get()).isAnnotationPresent(WrapThreadContextClassLoader.class)) {
                this.classLoader = Thread.currentThread().getContextClassLoader();
                StringTokenizer st = new StringTokenizer(cjp, ", ");
                URL[] archives = new URL[st.countTokens()];
                try {
                    for (int i = 0; i < archives.length; ++i) {
                        archives[i] = new File(JBossWSTestHelper.getTestArchiveDir(), st.nextToken()).toURI().toURL();
                    }
                    URLClassLoader cl = new URLClassLoader(archives, this.classLoader);
                    Thread.currentThread().setContextClassLoader(cl);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

