/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.ListImagesCmd;
import java.util.HashMap;
import java.util.List;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.docker.DockerClientConnector;
import org.jbpm.process.workitem.docker.ListContainersWorkitemHandler;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="DockerListImagesDefinitions.wid", name="DockerListImages", displayName="DockerListImages", defaultHandler="mvel: new org.jbpm.process.workitem.docker.ListImagesWorkitemHandler()", documentation="docker-workitem/index.html", category="docker-workitem", icon="DockerListImages.png", parameters={@WidParameter(name="ShowAll")}, results={@WidResult(name="Images", runtimeType="java.util.List")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="docker-workitem", version="7.42.0.Final")}, serviceInfo=@WidService(category="Docker", description="Connect to and interact with a running Docker deamon", keywords="Docker,list,images", action=@WidAction(title="List Docker images")))
public class ListImagesWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(ListContainersWorkitemHandler.class);
    private static final String RESULTS_DOCUMENT = "Images";
    private DockerClient dockerClient;

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        HashMap<String, List> results = new HashMap<String, List>();
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String showAll = (String)workItem.getParameter("ShowAll");
            if (this.dockerClient == null) {
                DockerClientConnector connector = new DockerClientConnector();
                this.dockerClient = connector.getDockerClient();
            }
            ListImagesCmd listImagesCmd = this.dockerClient.listImagesCmd();
            if (showAll != null && Boolean.parseBoolean(showAll)) {
                listImagesCmd = listImagesCmd.withShowAll(Boolean.valueOf(true));
            }
            List images = (List)listImagesCmd.exec();
            results.put(RESULTS_DOCUMENT, images);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            logger.error("Unable to get list of containers: " + e.getMessage());
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setDockerClient(DockerClient dockerClient) {
        this.dockerClient = dockerClient;
    }
}

