/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.ethereum;

import java.util.ArrayList;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.core.util.service.WidTrigger;
import org.jbpm.process.workitem.ethereum.DeployContractWorkitemHandler;
import org.jbpm.process.workitem.ethereum.EthereumUtils;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.http.HttpService;

@Wid(widfile="EthereumObserveContractEvent.wid", name="EthereumObserveContractEvent", displayName="EthereumObserveContractEvent", defaultHandler="mvel: new org.jbpm.process.workitem.ethereum.ObserveContractEventWorkitemHandler()", documentation="ethereum-workitem/index.html", parameters={@WidParameter(name="ServiceURL", required=true), @WidParameter(name="ContractAddress", required=true), @WidParameter(name="EventName", required=true), @WidParameter(name="EventReturnType"), @WidParameter(name="EventIndexedParameter"), @WidParameter(name="EventNonIndexedParameter"), @WidParameter(name="SignalName", required=true), @WidParameter(name="AbortOnUpdate")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="ethereum-workitem", version="7.11.0.Final")}, serviceInfo=@WidService(category="Ethereum", description="Integrate with the Ethereum Blockchain app platform", keywords="Ethereum,blockchain,smart,contract,smartcontract,observe", trigger=@WidTrigger(title="Observe a smart contract deployed onto the blockchain")))
public class ObserveContractEventWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private Web3j web3j;
    private KieSession kieSession;
    private static final String RESULTS = "ContractAddress";
    private static final Logger logger = LoggerFactory.getLogger(DeployContractWorkitemHandler.class);

    public ObserveContractEventWorkitemHandler(KieSession kieSession) {
        this.kieSession = kieSession;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String serviceURL = (String)workItem.getParameter("ServiceURL");
            String contractAddress = (String)workItem.getParameter(RESULTS);
            String eventName = (String)workItem.getParameter("EventName");
            ArrayList eventIndexedParameter = (ArrayList)workItem.getParameter("EventIndexedParameter");
            ArrayList eventNonIndexedParameter = (ArrayList)workItem.getParameter("EventNonIndexedParameter");
            String eventReturnType = (String)workItem.getParameter("EventReturnType");
            String signalName = (String)workItem.getParameter("SignalName");
            String abortOnUpdate = (String)workItem.getParameter("AbortOnUpdate");
            boolean doAbortOnUpdate = Boolean.parseBoolean(abortOnUpdate);
            if (eventIndexedParameter == null) {
                eventIndexedParameter = new ArrayList();
            }
            if (eventNonIndexedParameter == null) {
                eventNonIndexedParameter = new ArrayList();
            }
            if (this.web3j == null) {
                this.web3j = Web3j.build((Web3jService)new HttpService(serviceURL));
            }
            EthereumUtils.observeContractEvent(this.web3j, eventName, contractAddress, eventIndexedParameter, eventNonIndexedParameter, eventReturnType, this.kieSession, signalName, doAbortOnUpdate, workItemManager, workItem);
        }
        catch (Exception e) {
            logger.error("Error executing workitem: " + e.getMessage());
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setWeb3j(Web3j web3j) {
        this.web3j = web3j;
    }
}

