/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.ethereum;

import java.util.HashMap;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.ethereum.EthereumAuth;
import org.jbpm.process.workitem.ethereum.EthereumUtils;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.http.HttpService;

@Wid(widfile="EthereumDeployContract.wid", name="EthereumDeployContract", displayName="EthereumDeployContract", defaultHandler="mvel: new org.jbpm.process.workitem.ethereum.DeployContractWorkitemHandler(\"walletPassword\", \"walletPath\")", documentation="ethereum-workitem/index.html", category="ethereum-workitem", icon="EthereumDeployContract.png", parameters={@WidParameter(name="ServiceURL", required=true), @WidParameter(name="ContractPath", required=true), @WidParameter(name="DepositAmount"), @WidParameter(name="WaitForReceipt")}, results={@WidResult(name="ContractAddress")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="ethereum-workitem", version="7.59.0.Final")}, serviceInfo=@WidService(category="Ethereum", description="Integrate with the Ethereum Blockchain app platform", keywords="Ethereum,blockchain,smart,contract,smartcontract,deploy", action=@WidAction(title="Deploy a new smart contract onto the blockchain"), authinfo=@WidAuth(required=true, params={"walletPassword", "walletPath"}, paramsdescription={"Wallet password", "Path to the wallet file"})))
public class DeployContractWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String walletPassword;
    private String walletPath;
    private EthereumAuth auth;
    private Web3j web3j;
    private ClassLoader classLoader;
    private static final String RESULTS = "ContractAddress";
    private static final Logger logger = LoggerFactory.getLogger(DeployContractWorkitemHandler.class);

    public DeployContractWorkitemHandler(String walletPassword, String walletPath) {
        this(walletPassword, walletPath, null);
    }

    public DeployContractWorkitemHandler(String walletPassword, String walletPath, ClassLoader classLoader) {
        this.walletPassword = walletPassword;
        this.walletPath = walletPath;
        this.classLoader = classLoader == null ? ((Object)((Object)this)).getClass().getClassLoader() : classLoader;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String serviceURL = (String)workItem.getParameter("ServiceURL");
            String contractPath = (String)workItem.getParameter("ContractPath");
            String depositAmount = (String)workItem.getParameter("DepositAmount");
            String waitForReceiptStr = (String)workItem.getParameter("WaitForReceipt");
            HashMap<String, String> results = new HashMap<String, String>();
            if (this.web3j == null) {
                this.web3j = Web3j.build((Web3jService)new HttpService(serviceURL));
            }
            this.auth = new EthereumAuth(this.walletPassword, this.walletPath, this.classLoader);
            Credentials credentials = this.auth.getCredentials();
            int depositEtherAmountToSend = 0;
            if (depositAmount != null) {
                depositEtherAmountToSend = Integer.parseInt(depositAmount);
            }
            boolean waitForReceipt = false;
            if (waitForReceiptStr != null) {
                waitForReceipt = Boolean.parseBoolean(waitForReceiptStr);
            }
            String createdContractAddress = EthereumUtils.deployContract(credentials, this.web3j, EthereumUtils.convertStreamToStr(this.classLoader.getResourceAsStream(contractPath)), depositEtherAmountToSend, waitForReceipt, 15000, 40);
            results.put(RESULTS, createdContractAddress);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            logger.error("Error executing workitem: " + e.getMessage());
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setWeb3j(Web3j web3j) {
        this.web3j = web3j;
    }
}

