/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.ethereum;

import java.util.HashMap;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.ethereum.EthereumAuth;
import org.jbpm.process.workitem.ethereum.EthereumUtils;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.http.HttpService;
import org.web3j.tx.RawTransactionManager;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.Transfer;

@Wid(widfile="EthereumSendEther.wid", name="EthereumSendEther", displayName="EthereumSendEther", defaultHandler="mvel: new org.jbpm.process.workitem.ethereum.SendEtherWorkitemHandler(\"walletPassword\", \"walletPath\")", documentation="ethereum-workitem/index.html", category="ethereum-workitem", icon="EthereumSendEther.png", parameters={@WidParameter(name="ServiceURL", required=true), @WidParameter(name="Amount", required=true), @WidParameter(name="ToAddress", required=true)}, results={@WidResult(name="Receipt")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="ethereum-workitem", version="7.66.0.Final")}, serviceInfo=@WidService(category="Ethereum", description="Integrate with the Ethereum Blockchain app platform", keywords="Ethereum,blockchain,smart,contract,smartcontract,send,ether", action=@WidAction(title="Send ether to an existing contract on the blockchain"), authinfo=@WidAuth(required=true, params={"walletPassword", "walletPath"}, paramsdescription={"Wallet password", "Path to the wallet file"})))
public class SendEtherWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String walletPassword;
    private String walletPath;
    private EthereumAuth auth;
    private Web3j web3j;
    private Transfer transfer;
    private ClassLoader classLoader;
    private static final String RESULTS = "Receipt";
    private static final Logger logger = LoggerFactory.getLogger(SendEtherWorkitemHandler.class);

    public SendEtherWorkitemHandler(String walletPassword, String walletPath) {
        this(walletPassword, walletPath, null);
    }

    public SendEtherWorkitemHandler(String walletPassword, String walletPath, ClassLoader classLoader) {
        this.walletPassword = walletPassword;
        this.walletPath = walletPath;
        this.classLoader = classLoader == null ? ((Object)((Object)this)).getClass().getClassLoader() : classLoader;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String serviceURL = (String)workItem.getParameter("ServiceURL");
            String amount = (String)workItem.getParameter("Amount");
            String toAddress = (String)workItem.getParameter("ToAddress");
            HashMap<String, TransactionReceipt> results = new HashMap<String, TransactionReceipt>();
            if (this.web3j == null) {
                this.web3j = Web3j.build((Web3jService)new HttpService(serviceURL));
            }
            this.auth = new EthereumAuth(this.walletPassword, this.walletPath, this.classLoader);
            Credentials credentials = this.auth.getCredentials();
            RawTransactionManager transactionManager = new RawTransactionManager(this.web3j, credentials);
            if (this.transfer == null) {
                this.transfer = new Transfer(this.web3j, (TransactionManager)transactionManager);
            }
            int amountToSend = 0;
            if (amount != null) {
                amountToSend = Integer.parseInt(amount);
            }
            TransactionReceipt transactionReceipt = EthereumUtils.sendFundsToContract(credentials, this.web3j, amountToSend, toAddress, this.transfer);
            results.put(RESULTS, transactionReceipt);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            logger.error("Error executing workitem: " + e.getMessage());
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setWeb3j(Web3j web3j) {
        this.web3j = web3j;
    }

    public void setTransfer(Transfer transfer) {
        this.transfer = transfer;
    }
}

