/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.github;

import java.util.HashMap;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.MergeStatus;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.service.PullRequestService;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.github.GithubAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="GithubMergePullRequest.wid", name="GithubMergePullRequest", displayName="GithubMergePullRequest", defaultHandler="mvel: new org.jbpm.process.workitem.github.MergePullRequestWorkitemHandler(\"userName\", \"password\")", documentation="github-workitem/index.html", category="github-workitem", icon="GithubMergePullRequest.png", parameters={@WidParameter(name="RepoOwner", required=true), @WidParameter(name="RepoName", required=true), @WidParameter(name="PullRequestNum", required=true), @WidParameter(name="CommitMessage")}, results={@WidResult(name="IsMerged", runtimeType="java.lang.Boolean")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="github-workitem", version="7.55.0.Final")}, serviceInfo=@WidService(category="Github", description="Create Gist or list your repositories in Github", keywords="github,repo,repository,merge,pull,request,pullrequest,pr", action=@WidAction(title="Merget a pull request on GitHub"), authinfo=@WidAuth(required=true, params={"userName", "password"}, paramsdescription={"Github username", "Github password"}, referencesite="https://github.com/")))
public class MergePullRequestWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String userName;
    private String password;
    private GithubAuth auth = new GithubAuth();
    private static final Logger logger = LoggerFactory.getLogger(MergePullRequestWorkitemHandler.class);
    private static final String RESULTS_VALUE = "IsMerged";

    public MergePullRequestWorkitemHandler(String userName, String password) {
        this.userName = userName;
        this.password = password;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            MergeStatus mergeStatus;
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            HashMap<String, Boolean> results = new HashMap<String, Boolean>();
            String repoOwner = (String)workItem.getParameter("RepoOwner");
            String repoName = (String)workItem.getParameter("RepoName");
            String pullRequestNum = (String)workItem.getParameter("PullRequestNum");
            String commitMessage = (String)workItem.getParameter("CommitMessage");
            PullRequestService pullRequestService = this.auth.getPullRequestService(this.userName, this.password);
            RepositoryId repositoryId = new RepositoryId(repoOwner, repoName);
            if (pullRequestService.getPullRequest((IRepositoryIdProvider)repositoryId, Integer.parseInt(pullRequestNum)).isMergeable()) {
                mergeStatus = pullRequestService.merge((IRepositoryIdProvider)repositoryId, Integer.parseInt(pullRequestNum), commitMessage);
                if (mergeStatus == null || !mergeStatus.isMerged()) {
                    throw new IllegalArgumentException("Unable to merget pull request: " + mergeStatus.getMessage());
                }
            } else {
                throw new IllegalArgumentException("Pull request " + pullRequestNum + " is not mergeable");
            }
            results.put(RESULTS_VALUE, mergeStatus.isMerged());
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(GithubAuth auth) {
        this.auth = auth;
    }
}

