/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workitem.google.mail;

import com.google.api.services.gmail.Gmail;
import com.google.api.services.gmail.model.Message;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.jbpm.document.service.impl.DocumentImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.test.AbstractBaseTest;
import org.jbpm.workitem.google.mail.GoogleMailAuth;
import org.jbpm.workitem.google.mail.SendMailWorkitemHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class GoogleMailWorkitemHandlerTest
extends AbstractBaseTest {
    @Mock
    GoogleMailAuth auth;
    @Mock
    Gmail gmailService;
    @Mock
    Gmail.Users gmailUsers;
    @Mock
    Gmail.Users.Messages gmailUserMessages;
    @Mock
    Gmail.Users.Messages.Send gmailUserMessagesSend;

    @Before
    public void setUp() {
        try {
            Mockito.when((Object)this.auth.getGmailService(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.gmailService);
            Mockito.when((Object)this.gmailService.users()).thenReturn((Object)this.gmailUsers);
            Mockito.when((Object)this.gmailUsers.messages()).thenReturn((Object)this.gmailUserMessages);
            Mockito.when((Object)this.gmailUserMessages.send(Matchers.anyString(), (Message)Mockito.anyObject())).thenReturn((Object)this.gmailUserMessagesSend);
            Mockito.when((Object)((Message)this.gmailUserMessagesSend.execute())).thenReturn((Object)new Message());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSendEmailWithAttachment() throws Exception {
        DocumentImpl attachmentDoc = new DocumentImpl();
        attachmentDoc.setContent(new String("Attachment sources").getBytes());
        attachmentDoc.setName("attachmentFileName.txt");
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("To", (Object)"someone@gmail.com");
        workItem.setParameter("From", (Object)"me@gmail.com");
        workItem.setParameter("Subject", (Object)"Hello!");
        workItem.setParameter("BodyText", (Object)"Hello from me!");
        workItem.setParameter("Attachment", (Object)attachmentDoc);
        SendMailWorkitemHandler handler = new SendMailWorkitemHandler("myAppName", "{}");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }

    @Test(expected=WorkItemHandlerRuntimeException.class)
    public void testSendEmailInvalidParams() throws Exception {
        DocumentImpl attachmentDoc = new DocumentImpl();
        attachmentDoc.setContent(new String("Attachment sources").getBytes());
        attachmentDoc.setName("attachmentFileName.txt");
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        SendMailWorkitemHandler handler = new SendMailWorkitemHandler("myAppName", "{}");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }
}

