/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.google.tasks;

import com.google.api.services.tasks.Tasks;
import com.google.api.services.tasks.model.TaskList;
import com.google.api.services.tasks.model.TaskLists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.google.tasks.AddTaskWorkitemHandler;
import org.jbpm.process.workitem.google.tasks.GetTasksWorkitemHandler;
import org.jbpm.process.workitem.google.tasks.GoogleTasksAuth;
import org.jbpm.process.workitem.google.tasks.TaskInfo;
import org.jbpm.test.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class GoogleTasksWorkitemHandlerTest
extends AbstractBaseTest {
    @Mock
    GoogleTasksAuth auth;
    @Mock
    Tasks tasksService;
    @Mock
    Tasks.Tasklists taskLists;
    @Mock
    Tasks.Tasklists.List taskListsList;
    @Mock
    Tasks.Tasklists.Insert taskListsInsert;

    @Before
    public void setUp() {
        try {
            ArrayList<TaskList> testTaskList = new ArrayList<TaskList>();
            TaskList listOne = new TaskList();
            listOne.setTitle("buy groceries");
            listOne.setKind("home task");
            TaskList listTwo = new TaskList();
            listTwo.setTitle("pickup kid from school");
            listTwo.setKind("home task");
            testTaskList.add(listOne);
            testTaskList.add(listTwo);
            TaskLists taskListsModel = new TaskLists();
            taskListsModel.setItems(testTaskList);
            Mockito.when((Object)this.auth.getTasksService(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.tasksService);
            Mockito.when((Object)this.tasksService.tasklists()).thenReturn((Object)this.taskLists);
            Mockito.when((Object)this.taskLists.list()).thenReturn((Object)this.taskListsList);
            Mockito.when((Object)this.taskLists.insert((TaskList)Mockito.any(TaskList.class))).thenReturn((Object)this.taskListsInsert);
            Mockito.when((Object)this.taskListsList.setMaxResults(Long.valueOf(Mockito.anyLong()))).thenReturn((Object)this.taskListsList);
            Mockito.when((Object)this.taskListsList.execute()).thenReturn((Object)taskListsModel);
            Mockito.when((Object)this.taskListsInsert.execute()).thenReturn((Object)listOne);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetTasks() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NumOfTasks", (Object)"10");
        GetTasksWorkitemHandler handler = new GetTasksWorkitemHandler("testAppName", "{}");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        List returnedTasks = (List)((Map)manager.getResults().get(workItem.getId())).get("FoundTasks");
        Assert.assertNotNull((Object)returnedTasks);
        Assert.assertEquals((long)2L, (long)returnedTasks.size());
        Assert.assertEquals((Object)"buy groceries", (Object)((TaskInfo)returnedTasks.get(0)).getTitle());
        Assert.assertEquals((Object)"pickup kid from school", (Object)((TaskInfo)returnedTasks.get(1)).getTitle());
    }

    @Test
    public void testAddTasks() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("TaskName", (Object)"buy groceries");
        workItem.setParameter("TaskKind", (Object)"home task");
        AddTaskWorkitemHandler handler = new AddTaskWorkitemHandler("testAppName", "{}");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }
}

