/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.ibm.watson;

import com.ibm.watson.developer_cloud.visual_recognition.v3.VisualRecognition;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ClassResult;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ClassifiedImage;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ClassifiedImages;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ClassifierResult;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ClassifyOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ErrorInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.jbpm.document.Document;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.ibm.watson.WatsonAuth;
import org.jbpm.process.workitem.ibm.watson.result.ImageClassificationResult;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="ClassifyImageDefinitions.wid", name="IBMWatsonClassifyImage", displayName="IBMWatsonClassifyImage", defaultHandler="mvel: new org.jbpm.process.workitem.ibm.watson.ClassifyImageWorkitemHandler()", parameters={@WidParameter(name="ImageToClassify")}, results={@WidResult(name="Classification")}, mavenDepends={@WidMavenDepends(group="com.ibm.watson.developer_cloud", artifact="java-sdk", version="4.0.0")})
public class ClassifyImageWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(ClassifyImageWorkitemHandler.class);
    private static final String RESULT_VALUE = "Classification";
    private WatsonAuth auth = new WatsonAuth();
    private String apiKey;

    public ClassifyImageWorkitemHandler(String apiKey) {
        this.apiKey = apiKey;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        block7: {
            Document classificationImage = (Document)workItem.getParameter("ImageToClassify");
            HashMap widResults = new HashMap();
            if (classificationImage != null) {
                try {
                    VisualRecognition service = this.auth.getService(this.apiKey);
                    ByteArrayInputStream imageStream = new ByteArrayInputStream(classificationImage.getContent());
                    ClassifyOptions classifyOptions = new ClassifyOptions.Builder().imagesFile((InputStream)imageStream).imagesFilename(classificationImage.getName()).parameters("{\"owners\": [\"me\"]}").build();
                    ClassifiedImage result = (ClassifiedImage)((ClassifiedImages)service.classify(classifyOptions).execute()).getImages().get(0);
                    if (result.getError() != null) {
                        ErrorInfo errorInfo = result.getError();
                        logger.error("Error classifying image: " + errorInfo.getDescription());
                        workItemManager.abortWorkItem(workItem.getId());
                        break block7;
                    }
                    ArrayList<ImageClassificationResult> resultList = new ArrayList<ImageClassificationResult>();
                    for (ClassifierResult classification : result.getClassifiers()) {
                        for (ClassResult classResult : classification.getClasses()) {
                            resultList.add(new ImageClassificationResult(classification, classResult));
                        }
                        widResults.put(RESULT_VALUE, resultList);
                    }
                    workItemManager.completeWorkItem(workItem.getId(), widResults);
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            } else {
                logger.error("Missing image for classification.");
                throw new IllegalArgumentException("Missing image for classification.");
            }
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(WatsonAuth auth) {
        this.auth = auth;
    }
}

