/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.ibm.watson;

import com.ibm.watson.developer_cloud.visual_recognition.v3.VisualRecognition;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.DetectFacesOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.DetectedFaces;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.Face;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ImageWithFaces;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.jbpm.document.Document;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.ibm.watson.WatsonAuth;
import org.jbpm.process.workitem.ibm.watson.result.FaceDetectionResult;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="DetectFacesDefinitions.wid", name="IBMWatsonDetectFaces", displayName="IBMWatsonDetectFaces", defaultHandler="mvel: new org.jbpm.process.workitem.ibm.watson.DetectFacesWorkitemHandler()", parameters={@WidParameter(name="ImageToDetect")}, results={@WidResult(name="Detection")}, mavenDepends={@WidMavenDepends(group="com.ibm.watson.developer_cloud", artifact="java-sdk", version="4.0.0")})
public class DetectFacesWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(DetectFacesWorkitemHandler.class);
    private static final String RESULT_VALUE = "Detection";
    private WatsonAuth auth = new WatsonAuth();
    private String apiKey;

    public DetectFacesWorkitemHandler(String apiKey) {
        this.apiKey = apiKey;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        block7: {
            Document detectionImage = (Document)workItem.getParameter("ImageToDetect");
            HashMap widResults = new HashMap();
            if (detectionImage != null) {
                try {
                    VisualRecognition service = this.auth.getService(this.apiKey);
                    ByteArrayInputStream imageStream = new ByteArrayInputStream(detectionImage.getContent());
                    DetectFacesOptions detectFacesOptions = new DetectFacesOptions.Builder().imagesFile((InputStream)imageStream).build();
                    DetectedFaces result = (DetectedFaces)service.detectFaces(detectFacesOptions).execute();
                    if (result == null || result.getImages() == null || result.getImages().size() < 1) {
                        logger.error("Unable to detect faces on provided image.");
                        workItemManager.abortWorkItem(workItem.getId());
                        break block7;
                    }
                    ArrayList<FaceDetectionResult> resultList = new ArrayList<FaceDetectionResult>();
                    for (ImageWithFaces imageWithFaces : result.getImages()) {
                        for (Face face : imageWithFaces.getFaces()) {
                            resultList.add(new FaceDetectionResult(imageWithFaces, face));
                        }
                    }
                    widResults.put(RESULT_VALUE, resultList);
                    workItemManager.completeWorkItem(workItem.getId(), widResults);
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            } else {
                logger.error("Missing image for face detection.");
                throw new IllegalArgumentException("Missing image for face detection.");
            }
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(WatsonAuth auth) {
        this.auth = auth;
    }
}

