/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.kafka;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Properties;
import org.jbpm.process.workitem.kafka.KafkaWorkItemHandler;
import org.junit.Assert;
import org.junit.Test;
import org.kie.internal.runtime.manager.InternalRuntimeManager;

public class KafkaWorkItemHandlerConstructorTest {
    @Test
    public void testNoParamsKafkaWIHConstructor() throws Exception {
        Constructor emptyConstructor = KafkaWorkItemHandler.class.getDeclaredConstructor(new Class[0]);
        emptyConstructor.setAccessible(true);
        KafkaWorkItemHandler kafkaWIH = (KafkaWorkItemHandler)emptyConstructor.newInstance(new Object[0]);
        this.assertKafkaConstructorParams(kafkaWIH);
    }

    @Test
    public void testClassLoaderKafkaWIHConstructor() throws Exception {
        Constructor emptyConstructor = KafkaWorkItemHandler.class.getDeclaredConstructor(ClassLoader.class);
        emptyConstructor.setAccessible(true);
        KafkaWorkItemHandler kafkaWIH = (KafkaWorkItemHandler)emptyConstructor.newInstance(this.getClass().getClassLoader());
        this.assertKafkaConstructorParams(kafkaWIH);
    }

    @Test
    public void testClassLoaderRuntimeKafkaWIHConstructor() throws Exception {
        Constructor emptyConstructor = KafkaWorkItemHandler.class.getDeclaredConstructor(ClassLoader.class, InternalRuntimeManager.class);
        emptyConstructor.setAccessible(true);
        KafkaWorkItemHandler kafkaWIH = (KafkaWorkItemHandler)emptyConstructor.newInstance(this.getClass().getClassLoader(), null);
        this.assertKafkaConstructorParams(kafkaWIH);
    }

    @Test
    public void testEmptyParamsKafkaWIHConstructor() throws Exception {
        Constructor emptyConstructor = KafkaWorkItemHandler.class.getDeclaredConstructor(String.class, String.class, String.class, String.class);
        emptyConstructor.setAccessible(true);
        KafkaWorkItemHandler kafkaWIH = (KafkaWorkItemHandler)emptyConstructor.newInstance("", "", "", "");
        this.assertKafkaConstructorParams(kafkaWIH);
    }

    @Test
    public void testNullParamsKafkaWIHConstructor() throws Exception {
        Constructor emptyConstructor = KafkaWorkItemHandler.class.getDeclaredConstructor(String.class, String.class, String.class, String.class);
        emptyConstructor.setAccessible(true);
        KafkaWorkItemHandler kafkaWIH = (KafkaWorkItemHandler)emptyConstructor.newInstance(null, null, null, null);
        this.assertKafkaConstructorParams(kafkaWIH);
    }

    private void assertKafkaConstructorParams(KafkaWorkItemHandler kafkaWIH) throws NoSuchFieldException, IllegalAccessException {
        Field properties = kafkaWIH.getClass().getDeclaredField("properties");
        properties.setAccessible(true);
        String defaultHost = this.getStaticField(kafkaWIH, "DEFAULT_HOST").toString();
        String defaultKafkaClientId = this.getStaticField(kafkaWIH, "DEFAULT_KAFKA_CLIENT_ID").toString();
        String defaultSerializer = this.getStaticField(kafkaWIH, "DEFAULT_SERIALIZER").toString();
        Assert.assertEquals((Object)defaultHost, (Object)((Properties)properties.get(kafkaWIH)).get("bootstrap.servers"));
        Assert.assertEquals((Object)defaultKafkaClientId, (Object)((Properties)properties.get(kafkaWIH)).get("client.id"));
        Assert.assertEquals((Object)defaultSerializer, (Object)((Properties)properties.get(kafkaWIH)).get("key.serializer"));
        Assert.assertEquals((Object)defaultSerializer, (Object)((Properties)properties.get(kafkaWIH)).get("value.serializer"));
    }

    private Object getStaticField(KafkaWorkItemHandler kafkaWIH, String field) throws NoSuchFieldException, IllegalAccessException {
        Field staticVar = kafkaWIH.getClass().getDeclaredField(field);
        staticVar.setAccessible(true);
        Object staticValue = staticVar.get(null);
        Assert.assertNotNull((Object)staticValue);
        return staticValue;
    }
}

