/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.repositoryspringboot;

import java.util.List;
import org.jbpm.process.workitem.repository.service.RepoData;
import org.jbpm.process.workitem.repository.service.RepoMavenDepend;
import org.jbpm.process.workitem.repository.service.RepoParameter;
import org.jbpm.process.workitem.repository.service.RepoResult;
import org.jbpm.process.workitem.repository.service.RepoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RepositoryController {
    @Autowired
    private RepoService repoService;

    @RequestMapping(value={"/rest/services"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<RepoData> getAllServices() {
        try {
            return this.repoService.getServices();
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @RequestMapping(value={"/rest/services/count"}, method={RequestMethod.GET}, produces={"application/json"})
    public int getAllServicesCount() {
        try {
            return this.repoService.getServices().size();
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @RequestMapping(value={"/rest/services/{name}"}, method={RequestMethod.GET}, produces={"application/json"})
    public RepoData getServiceByName(@PathVariable(value="name") String name) {
        try {
            return this.repoService.getServiceByName(name);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @RequestMapping(value={"/rest/services/{name}/parameters"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<RepoParameter> getParametersByServiceName(@PathVariable(value="name") String name) {
        try {
            return this.repoService.getServiceByName(name).getParameters();
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @RequestMapping(value={"/rest/services/{name}/results"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<RepoResult> getResultsByServiceName(@PathVariable(value="name") String name) {
        try {
            return this.repoService.getServiceByName(name).getResults();
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @RequestMapping(value={"/rest/services/{name}/mavendepends"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<RepoMavenDepend> getMavenDependsByServiceName(@PathVariable(value="name") String name) {
        try {
            return this.repoService.getServiceByName(name).getMavenDependencies();
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @RequestMapping(value={"/rest/services/category/{category}"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<RepoData> getResultsByServiceCategory(@PathVariable(value="category") String category) {
        try {
            return this.repoService.getServicesByCategory(category);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @RequestMapping(value={"/rest/servicetriggers"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<RepoData> getTriggerServices() {
        try {
            return this.repoService.getTriggerServices();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IllegalArgumentException(t);
        }
    }

    @RequestMapping(value={"/rest/serviceactions"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<RepoData> getActionServices() {
        try {
            return this.repoService.getActionServices();
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @RequestMapping(value={"/rest/servicetriggers/count"}, method={RequestMethod.GET}, produces={"application/json"})
    public int getTriggerServicesCount() {
        try {
            return this.repoService.getTriggerServices().size();
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @RequestMapping(value={"/rest/serviceactions/count"}, method={RequestMethod.GET}, produces={"application/json"})
    public int getActionServicesCount() {
        try {
            return this.repoService.getActionServices().size();
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }
}

