/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.resources.jts.orbspecific;

import com.arjuna.ArjunaOTS.OTSAbstractRecord;
import com.arjuna.ArjunaOTS.OTSAbstractRecordPOA;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TwoPhaseOutcome;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ParticipantStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.jta.recovery.jts.XARecoveryModule;
import com.arjuna.ats.internal.jta.resources.XAResourceErrorHandler;
import com.arjuna.ats.internal.jta.transaction.jts.TransactionImple;
import com.arjuna.ats.internal.jta.utils.jtaxLogger;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.recovery.SerializableXAResourceDeserializer;
import com.arjuna.ats.jta.utils.XAHelper;
import com.arjuna.ats.jta.xa.RecoverableXAConnection;
import com.arjuna.ats.jta.xa.XidImple;
import com.arjuna.ats.jts.utils.Utility;
import com.arjuna.common.internal.util.ClassloadingUtility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.tm.FirstResource;
import org.jboss.tm.LastResource;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.RecoveryCoordinatorHelper;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.ResourceHelper;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Vote;

public class XAResourceRecord
extends OTSAbstractRecordPOA {
    public static final int XACONNECTION = 0;
    private static final Uid START_XARESOURCE = Uid.minUid();
    private static final Uid END_XARESOURCE = Uid.maxUid();
    protected XAResource _theXAResource;
    private RecoverableXAConnection _recoveryObject;
    private Xid _tranID;
    private boolean _prepared;
    private boolean _committed;
    private boolean _valid;
    private int _heuristic;
    private ParticipantStore _participantStore;
    private Uid _theUid;
    private Resource _theReference;
    private RecoveryCoordinator _recoveryCoordinator;
    private TransactionImple _theTransaction;
    private boolean _forgotten;
    private String _cachedUidStringForm;
    private static boolean _rollbackOptimization = jtaPropertyManager.getJTAEnvironmentBean().isXaRollbackOptimization();
    private List<SerializableXAResourceDeserializer> serializableXAResourceDeserializers;

    public XAResourceRecord(TransactionImple tx2, XAResource res, Xid xid, java.lang.Object[] params) {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((java.lang.Object)("XAResourceRecord.XAResourceRecord ( " + xid + " )"));
        }
        this._theXAResource = res;
        this._recoveryObject = null;
        this._tranID = xid;
        this._valid = true;
        if (params != null && params.length >= 0 && params[0] instanceof RecoverableXAConnection) {
            this._recoveryObject = (RecoverableXAConnection)params[0];
        }
        this._prepared = false;
        this._committed = false;
        this._heuristic = 7;
        this._participantStore = null;
        this._theUid = new Uid();
        this._theReference = null;
        this._recoveryCoordinator = null;
        this._theTransaction = tx2;
        if (this._theXAResource instanceof FirstResource) {
            this._cachedUidStringForm = START_XARESOURCE.stringForm();
        } else if (this._theXAResource instanceof LastResource) {
            this._cachedUidStringForm = END_XARESOURCE.stringForm();
        }
    }

    public XAResourceRecord() {
        this._theXAResource = null;
        this._recoveryObject = null;
        this._tranID = null;
        this._valid = true;
        this._prepared = true;
        this._committed = false;
        this._heuristic = 7;
        this._participantStore = null;
        this._theUid = new Uid();
        this._theReference = null;
        this._recoveryCoordinator = null;
    }

    public final Uid get_uid() {
        return this._theUid;
    }

    public final synchronized Resource getResource() {
        if (this._theReference == null) {
            ORBManager.getPOA().objectIsReady(this);
            this._theReference = ResourceHelper.narrow(ORBManager.getPOA().corbaReference(this));
        }
        return this._theReference;
    }

    public final Xid getXid() {
        return this._tranID;
    }

    @Override
    public Vote prepare() throws HeuristicMixed, HeuristicHazard, SystemException {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((java.lang.Object)("XAResourceRecord.prepare for " + this._tranID));
        }
        if (!this._valid || this._theXAResource == null || this._tranID == null) {
            jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_nulltransaction("XAResourceRecord.prepare");
            this.removeConnection();
            return Vote.VoteRollback;
        }
        try {
            this.endAssociation(0x4000000, 1);
            if (this._theXAResource.prepare(this._tranID) == 3) {
                this.removeConnection();
                return Vote.VoteReadOnly;
            }
            if (this.createState()) {
                return Vote.VoteCommit;
            }
            return Vote.VoteRollback;
        }
        catch (XAException e1) {
            jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_preparefailed(this._theXAResource.toString(), XAHelper.xidToString(this._tranID), XAHelper.printXAErrorCode(e1), e1);
            if (jtaxLogger.logger.isTraceEnabled()) {
                jtaxLogger.logger.tracef("XAResourceRecord.prepare exception %s resource_trace: txn uid=%s resource uid=%s\n", (java.lang.Object)XAHelper.printXAErrorCode(e1), (java.lang.Object)this._tranID, (java.lang.Object)this.get_uid());
            }
            if (_rollbackOptimization) {
                this.removeConnection();
            }
            switch (e1.errorCode) {
                case -7: 
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    return Vote.VoteRollback;
                }
            }
            throw new HeuristicHazard();
        }
        catch (Exception e2) {
            jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_preparefailed(this._theXAResource.toString(), XAHelper.xidToString(this._tranID), "-", e2);
            if (_rollbackOptimization) {
                this.removeConnection();
            }
            return Vote.VoteRollback;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void rollback() throws SystemException, HeuristicCommit, HeuristicMixed, HeuristicHazard {
        block32: {
            if (jtaxLogger.logger.isTraceEnabled()) {
                jtaxLogger.logger.trace((java.lang.Object)("XAResourceRecord.rollback for " + this._tranID));
            }
            if (this._theTransaction != null && this._theTransaction.getXAResourceState(this._theXAResource) == 4) {
                return;
            }
            if (!this._valid || this._tranID == null) {
                jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_nulltransaction("XAResourceRecord.rollback");
                return;
            }
            if (this._theXAResource == null) return;
            switch (this._heuristic) {
                case 6: {
                    throw new HeuristicHazard();
                }
                case 5: {
                    throw new HeuristicMixed();
                }
            }
            try {
                if (!this._prepared) {
                    this.endAssociation(0x20000000, 3);
                }
            }
            catch (XAException e1) {
                if (e1.errorCode >= 100 && e1.errorCode < 107) break block32;
                if (e1.errorCode == -3 || e1.errorCode == -7) {
                    try {
                        this._theXAResource.rollback(this._tranID);
                    }
                    catch (XAException e2) {
                        jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_xaerror("XAResourceRecord.rollback", XAHelper.printXAErrorCode(e2), this._theXAResource.toString(), XAHelper.xidToString(this._tranID), e2);
                        this.removeConnection();
                        throw new UNKNOWN();
                    }
                }
                this.removeConnection();
                throw new UNKNOWN();
            }
        }
        try {
            this._theXAResource.rollback(this._tranID);
            return;
        }
        catch (XAException e1) {
            if (this.notAProblem(e1, false)) {
                return;
            }
            jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_xaerror("XAResourceRecord.rollback", XAHelper.printXAErrorCode(e1), this._theXAResource.toString(), XAHelper.xidToString(this._tranID), e1);
            if (jtaxLogger.logger.isTraceEnabled()) {
                jtaxLogger.logger.tracef("XAResourceRecord.rollback exception %s resource_trace: txn uid=%s resource uid=%s\n", (java.lang.Object)XAHelper.printXAErrorCode(e1), (java.lang.Object)this._tranID, (java.lang.Object)this.get_uid());
            }
            switch (e1.errorCode) {
                case -3: {
                    if (!this._prepared) {
                        return;
                    }
                }
                case 8: {
                    this.updateState(6);
                    throw new HeuristicHazard();
                }
                case 7: {
                    this.updateState(4);
                    throw new HeuristicCommit();
                }
                case 5: {
                    this.updateState(5);
                    throw new HeuristicMixed();
                }
                case 6: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    this.destroyState();
                    return;
                }
                default: {
                    this.destroyState();
                    if (!this._prepared) throw new UNKNOWN();
                    throw new HeuristicHazard();
                }
            }
        }
        catch (Exception e2) {
            jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_generror("XAResourceRecord.rollback", this._theXAResource.toString(), XAHelper.xidToString(this._tranID), e2);
            throw new UNKNOWN();
        }
        finally {
            if (this._prepared) {
                this.destroyState();
            } else {
                this.removeConnection();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void commit() throws SystemException, NotPrepared, HeuristicRollback, HeuristicMixed, HeuristicHazard {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((java.lang.Object)("XAResourceRecord.commit for " + this._tranID));
        }
        if (this._tranID == null) {
            jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_nulltransaction("XAResourceRecord.commit");
            return;
        }
        if (this._theXAResource == null || this._committed) return;
        switch (this._heuristic) {
            case 6: {
                throw new HeuristicHazard();
            }
            case 5: {
                throw new HeuristicMixed();
            }
            case 3: {
                throw new HeuristicRollback();
            }
        }
        if (!this._prepared) {
            throw new NotPrepared();
        }
        boolean removeConnection = true;
        try {
            if (this._committed) return;
            this._committed = true;
            this._theXAResource.commit(this._tranID, false);
            this.destroyState();
            return;
        }
        catch (XAException e1) {
            e1.printStackTrace();
            if (this.notAProblem(e1, true)) {
                this.destroyState();
                return;
            }
            this._committed = false;
            jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_xaerror("XAResourceRecord.commit", XAHelper.printXAErrorCode(e1), this._theXAResource.toString(), XAHelper.xidToString(this._tranID), e1);
            if (jtaxLogger.logger.isTraceEnabled()) {
                jtaxLogger.logger.tracef("XAResourceRecord.commit exception %s resource_trace: txn uid=%s resource uid=%s\n", (java.lang.Object)XAHelper.printXAErrorCode(e1), (java.lang.Object)this._tranID, (java.lang.Object)this.get_uid());
            }
            switch (e1.errorCode) {
                case 8: {
                    this.updateState(6);
                    throw new HeuristicHazard();
                }
                case 7: {
                    this.destroyState();
                    return;
                }
                case -3: 
                case 6: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    this.updateState(3);
                    throw new HeuristicRollback();
                }
                case 5: {
                    this.updateState(5);
                    throw new HeuristicMixed();
                }
                case -4: {
                    this.updateState(6);
                    throw new HeuristicHazard();
                }
                case -6: {
                    throw new TRANSACTION_ROLLEDBACK();
                }
                case -7: 
                case 4: {
                    removeConnection = false;
                    throw new UNKNOWN();
                }
                default: {
                    throw new HeuristicHazard();
                }
            }
        }
        catch (Exception e2) {
            this._committed = false;
            jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_generror("XAResourceRecord.commit", this._theXAResource.toString(), XAHelper.xidToString(this._tranID), e2);
            throw new UNKNOWN();
        }
        finally {
            if (removeConnection) {
                this.removeConnection();
            }
        }
    }

    @Override
    public Vote prepare_subtransaction() throws SystemException {
        return Vote.VoteRollback;
    }

    @Override
    public void commit_subtransaction(Coordinator parent) throws SystemException {
        throw new UNKNOWN();
    }

    @Override
    public void rollback_subtransaction() throws SystemException {
        throw new UNKNOWN();
    }

    @Override
    public int type_id() throws SystemException {
        return 172;
    }

    @Override
    public String uid() throws SystemException {
        if (this._cachedUidStringForm == null) {
            this._cachedUidStringForm = this._theUid.stringForm();
        }
        return this._cachedUidStringForm;
    }

    @Override
    public boolean propagateOnAbort() throws SystemException {
        return false;
    }

    @Override
    public boolean propagateOnCommit() throws SystemException {
        return false;
    }

    @Override
    public boolean saveRecord() throws SystemException {
        return true;
    }

    @Override
    public void merge(OTSAbstractRecord record) throws SystemException {
    }

    @Override
    public void alter(OTSAbstractRecord record) throws SystemException {
    }

    @Override
    public boolean shouldAdd(OTSAbstractRecord record) throws SystemException {
        return false;
    }

    @Override
    public boolean shouldAlter(OTSAbstractRecord record) throws SystemException {
        return false;
    }

    @Override
    public boolean shouldMerge(OTSAbstractRecord record) throws SystemException {
        return false;
    }

    @Override
    public boolean shouldReplace(OTSAbstractRecord record) throws SystemException {
        return false;
    }

    protected boolean notAProblem(XAException ex, boolean commit) {
        return XAResourceErrorHandler.notAProblem(this._theXAResource, ex, commit);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void commit_one_phase() throws HeuristicHazard, SystemException {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((java.lang.Object)("XAResourceRecord.commit_one_phase for " + this._tranID));
        }
        if (this._tranID == null) {
            jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_nulltransaction("XAResourceRecord.commit_one_phase");
            throw new TRANSACTION_ROLLEDBACK();
        }
        if (this._theXAResource == null) throw new TRANSACTION_ROLLEDBACK();
        try {
            switch (this._heuristic) {
                case 6: {
                    throw new HeuristicHazard();
                }
            }
            boolean commit = true;
            XAException endRBOnly = null;
            try {
                this.endAssociation(0x4000000, 1);
            }
            catch (XAException e1) {
                switch (e1.errorCode) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        throw e1;
                    }
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: {
                        endRBOnly = e1;
                        commit = false;
                        break;
                    }
                    default: {
                        throw new UNKNOWN();
                    }
                }
            }
            if (commit) {
                this._theXAResource.commit(this._tranID, true);
                return;
            }
            this._theXAResource.rollback(this._tranID);
            throw endRBOnly;
        }
        catch (XAException e1) {
            if (e1.errorCode >= 100 && e1.errorCode <= 107) {
                throw new TRANSACTION_ROLLEDBACK();
            }
            switch (e1.errorCode) {
                case 5: 
                case 8: {
                    this.updateState(6);
                    throw new HeuristicHazard();
                }
                case 7: {
                    try {
                        this.handleForget();
                        return;
                    }
                    catch (SystemException systemException) {
                        return;
                    }
                }
                case 6: {
                    try {
                        this.handleForget();
                        throw new TRANSACTION_ROLLEDBACK();
                    }
                    catch (SystemException systemException) {
                        // empty catch block
                    }
                    throw new TRANSACTION_ROLLEDBACK();
                }
                case -3: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    throw new TRANSACTION_ROLLEDBACK();
                }
                case -4: {
                    this.updateState(6);
                    throw new HeuristicHazard();
                }
                case -6: 
                case 4: {
                    throw new TRANSACTION_ROLLEDBACK();
                }
                case -5: {
                    throw new HeuristicHazard();
                }
                case -7: {
                    throw new HeuristicHazard();
                }
                default: {
                    this._committed = true;
                    throw new UNKNOWN();
                }
            }
        }
        catch (SystemException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (HeuristicHazard ex) {
            throw ex;
        }
        catch (Exception e2) {
            jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_coperror(e2);
            throw new UNKNOWN();
        }
        finally {
            this.removeConnection();
        }
    }

    @Override
    public void forget() throws SystemException {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((java.lang.Object)("XAResourceRecord.forget for " + this._tranID + " _forgotten=" + this._forgotten));
        }
        if (!this._forgotten) {
            this.handleForget();
        }
        if (this._forgotten) {
            this.destroyState();
            this.removeConnection();
        }
    }

    public boolean isForgotten() {
        return this._forgotten;
    }

    private void handleForget() throws SystemException {
        if (this._theXAResource != null && this._tranID != null) {
            try {
                this._theXAResource.forget(this._tranID);
                this._heuristic = 7;
                this._forgotten = true;
            }
            catch (Exception e) {
                jtaLogger.i18NLogger.warn_recovery_forgetfailed("XAResourceRecord forget failed:", e);
                throw new UNKNOWN(e.getMessage());
            }
        }
    }

    public boolean saveState(OutputObjectState os) {
        boolean res = false;
        try {
            os.packInt(this._heuristic);
            os.packBoolean(this._committed);
            XidImple.pack(os, this._tranID);
            if (this._recoveryObject == null) {
                os.packInt(1);
                if (this._theXAResource instanceof Serializable) {
                    try {
                        ByteArrayOutputStream s = new ByteArrayOutputStream();
                        ObjectOutputStream o = new ObjectOutputStream(s);
                        o.writeObject(this._theXAResource);
                        o.close();
                        os.packBoolean(true);
                        String name = this._theXAResource.getClass().getName();
                        os.packString(name);
                        os.packBytes(s.toByteArray());
                    }
                    catch (NotSerializableException ex) {
                        jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_saveState();
                        return false;
                    }
                } else {
                    os.packBoolean(false);
                }
            } else {
                os.packInt(0);
                os.packString(this._recoveryObject.getClass().getName());
                this._recoveryObject.packInto(os);
            }
            if (this._recoveryCoordinator == null) {
                os.packBoolean(false);
            } else {
                os.packBoolean(true);
                String ior = ORBManager.getORB().orb().object_to_string((Object)this._recoveryCoordinator);
                os.packString(ior);
                ior = null;
            }
            res = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            res = false;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean restoreState(InputObjectState os) {
        boolean res = false;
        try {
            boolean haveRecCoord;
            this._heuristic = os.unpackInt();
            this._committed = os.unpackBoolean();
            this._tranID = XidImple.unpack(os);
            this._theXAResource = null;
            this._recoveryObject = null;
            if (os.unpackInt() == 1) {
                boolean haveXAResource = os.unpackBoolean();
                if (haveXAResource) {
                    try {
                        String className = os.unpackString();
                        byte[] b = os.unpackBytes();
                        ByteArrayInputStream s = new ByteArrayInputStream(b);
                        ObjectInputStream o = new ObjectInputStream(s);
                        boolean deserialized = false;
                        for (SerializableXAResourceDeserializer proxyXAResourceDeserializer : this.getXAResourceDeserializers()) {
                            if (!proxyXAResourceDeserializer.canDeserialze(className)) continue;
                            this._theXAResource = proxyXAResourceDeserializer.deserialze(o);
                            deserialized = true;
                            break;
                        }
                        try {
                            if (!deserialized) {
                                this._theXAResource = (XAResource)o.readObject();
                            }
                            if (jtaxLogger.logger.isTraceEnabled()) {
                                jtaxLogger.logger.trace((java.lang.Object)"XAResourceRecord.restore_state - XAResource de-serialized");
                            }
                        }
                        catch (ClassNotFoundException cnfe) {
                            jtaxLogger.i18NLogger.warn_could_not_load_class_will_wait_for_bottom_up(cnfe);
                        }
                        finally {
                            o.close();
                        }
                    }
                    catch (Exception ex) {
                        jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_restoreerror1(ex);
                        boolean b = false;
                        if (this._heuristic == 7) return b;
                        jtaxLogger.logger.warn((java.lang.Object)("XAResourceRecord restored heuristic instance: " + this));
                        return b;
                    }
                }
            } else {
                String creatorName = os.unpackString();
                this._recoveryObject = ClassloadingUtility.loadAndInstantiateClass(RecoverableXAConnection.class, creatorName, null);
                if (this._recoveryObject == null) {
                    throw new ClassNotFoundException();
                }
                this._recoveryObject.unpackFrom(os);
                this._theXAResource = this._recoveryObject.getResource();
                if (this._theXAResource == null) {
                    jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_norecoveryxa(XAHelper.xidToString(this._tranID));
                }
                if (jtaxLogger.logger.isTraceEnabled()) {
                    jtaxLogger.logger.trace((java.lang.Object)("XAResourceRecord.restore_state - XAResource got from " + creatorName));
                }
            }
            if (haveRecCoord = os.unpackBoolean()) {
                String ior = os.unpackString();
                if (ior == null) {
                    boolean b = false;
                    return b;
                }
                Object objRef = ORBManager.getORB().orb().string_to_object(ior);
                this._recoveryCoordinator = RecoveryCoordinatorHelper.narrow(objRef);
            } else {
                this._recoveryCoordinator = null;
            }
            res = true;
            return res;
        }
        catch (Exception e) {
            jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_restoreerror2(e);
            res = false;
            return res;
        }
        finally {
            if (this._heuristic != 7) {
                jtaxLogger.logger.warn((java.lang.Object)("XAResourceRecord restored heuristic instance: " + this));
            }
        }
    }

    public String type() {
        return XAResourceRecord.typeName();
    }

    public static String typeName() {
        return "/CosTransactions/XAResourceRecord";
    }

    public final void setRecoveryCoordinator(RecoveryCoordinator recCoord) {
        this._recoveryCoordinator = recCoord;
    }

    public final RecoveryCoordinator getRecoveryCoordinator() {
        return this._recoveryCoordinator;
    }

    public String toString() {
        return "XAResourceRecord < resource:" + this._theXAResource + ", txid:" + this._tranID + ", heuristic" + TwoPhaseOutcome.stringForm(this._heuristic) + " " + super.toString() + " >";
    }

    protected XAResourceRecord(Uid u) {
        this._theXAResource = null;
        this._recoveryObject = null;
        this._tranID = null;
        this._prepared = true;
        this._committed = false;
        this._heuristic = 7;
        this._theUid = new Uid(u);
        this._participantStore = null;
        this._valid = false;
        this._theReference = null;
        this._recoveryCoordinator = null;
        this._theTransaction = null;
        this._valid = this.loadState();
    }

    protected synchronized void setXAResource(XAResource res) {
        this._theXAResource = res;
    }

    protected int recover() {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((java.lang.Object)"XAResourceRecord.recover");
        }
        if (this._valid) {
            Status s = Status.StatusUnknown;
            try {
                s = this._recoveryCoordinator.replay_completion(this.getResource());
            }
            catch (OBJECT_NOT_EXIST ex) {
                s = this._committed ? Status.StatusCommitted : Status.StatusRolledBack;
            }
            catch (NotPrepared ex1) {
                jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_notprepared("XAResourceRecord");
                return 4;
            }
            catch (NullPointerException ex1) {
            }
            catch (Exception e) {
                jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_unexpected("XAResourceRecord", e);
                return 2;
            }
            if (jtaxLogger.logger.isTraceEnabled()) {
                jtaxLogger.logger.trace((java.lang.Object)("XAResourceRecord.recover got status: " + Utility.stringStatus(s)));
            }
            boolean doCommit = false;
            switch (s.value()) {
                case 5: {
                    return 2;
                }
                case 1: 
                case 8: {
                    return 3;
                }
                case 3: {
                    doCommit = true;
                    break;
                }
                case 4: 
                case 9: {
                    doCommit = false;
                    break;
                }
                case 7: {
                    return 3;
                }
                default: {
                    return 2;
                }
            }
            return this.doRecovery(doCommit);
        }
        return 2;
    }

    private final void setObjectStore() {
        if (this._participantStore == null) {
            this._participantStore = StoreManager.getParticipantStore();
        }
    }

    private final boolean createState() {
        this.setObjectStore();
        if (this._theXAResource != null && this._tranID != null && this._participantStore != null) {
            OutputObjectState os = new OutputObjectState();
            if (this.saveState(os)) {
                try {
                    this._valid = this._participantStore.write_committed(this._theUid, this.type(), os);
                    this._prepared = true;
                }
                catch (Exception e) {
                    jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_createstate();
                    this._valid = false;
                }
            } else {
                this._valid = false;
            }
        } else {
            this._valid = false;
        }
        return this._valid;
    }

    protected final boolean updateState(int h) {
        this.setObjectStore();
        if (this._prepared) {
            OutputObjectState os = new OutputObjectState();
            this._heuristic = h;
            if (this.saveState(os)) {
                try {
                    this._valid = this._participantStore.write_committed(this._theUid, this.type(), os);
                }
                catch (Exception e) {
                    this._valid = false;
                }
            } else {
                jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_updatestate();
                this._valid = false;
            }
        }
        return this._valid;
    }

    private final boolean loadState() {
        this.setObjectStore();
        InputObjectState os = null;
        try {
            os = this._participantStore.read_committed(this._theUid, this.type());
        }
        catch (Exception e) {
            jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_loadstateread(e);
            os = null;
        }
        if (os != null) {
            this._valid = this.restoreState(os);
            os = null;
        } else {
            this._valid = false;
        }
        return this._valid;
    }

    private final boolean destroyState() {
        this.setObjectStore();
        if (this._prepared && this._valid) {
            try {
                this._valid = this._participantStore.remove_committed(this._theUid, this.type());
            }
            catch (Exception e) {
                tsLogger.i18NLogger.warn_objectstore_remove_state_exception(e);
                this._valid = false;
            }
        }
        this.removeConnection();
        return this._valid;
    }

    private final void removeConnection() {
        if (this._recoveryObject != null) {
            this._recoveryObject.close();
            this._recoveryObject = null;
        }
        if (this._theTransaction != null) {
            this._theTransaction = null;
        }
        try {
            if (this._theReference != null) {
                ORBManager.getPOA().shutdownObject(this);
                this._theReference = null;
            }
        }
        catch (Exception e) {
            jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_remconn(e);
        }
    }

    private final int doRecovery(boolean commit) {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((java.lang.Object)("XAResourceRecord.doRecovery ( " + commit + " )"));
        }
        int result = 2;
        if (this._theXAResource != null && this._tranID != null) {
            try {
                if (commit) {
                    jtaxLogger.i18NLogger.info_jtax_recovery_jts_orbspecific_commit(XAHelper.xidToString(this._tranID));
                    this.commit();
                } else {
                    jtaxLogger.i18NLogger.info_jtax_recovery_jts_orbspecific_rollback(XAHelper.xidToString(this._tranID));
                    this.rollback();
                }
                result = 1;
            }
            catch (Exception e2) {
                jtaxLogger.i18NLogger.warn_jtax_resources_jts_orbspecific_recfailed(commit ? "commit" : "rollback", e2);
            }
        }
        return result;
    }

    private final void endAssociation(int xaState, int txInfoState) throws XAException {
        if (this._theTransaction != null) {
            this._theTransaction.endAssociation(this._tranID, this._theXAResource, xaState, txInfoState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SerializableXAResourceDeserializer> getXAResourceDeserializers() {
        if (this.serializableXAResourceDeserializers != null) {
            return this.serializableXAResourceDeserializers;
        }
        XAResourceRecord xAResourceRecord = this;
        synchronized (xAResourceRecord) {
            if (this.serializableXAResourceDeserializers != null) {
                return this.serializableXAResourceDeserializers;
            }
            this.serializableXAResourceDeserializers = new ArrayList<SerializableXAResourceDeserializer>();
            for (RecoveryModule recoveryModule : RecoveryManager.manager().getModules()) {
                if (!(recoveryModule instanceof XARecoveryModule)) continue;
                XARecoveryModule xaRecoveryModule = (XARecoveryModule)recoveryModule;
                this.serializableXAResourceDeserializers.addAll(xaRecoveryModule.getSeriablizableXAResourceDeserializers());
                return this.serializableXAResourceDeserializers;
            }
        }
        return this.serializableXAResourceDeserializers;
    }
}

