/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jdk8;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.Optional;

public class OptionalSerializer
extends StdSerializer<Optional<?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _referredType;
    protected final BeanProperty _property;
    protected final TypeSerializer _valueTypeSerializer;
    protected final JsonSerializer<Object> _valueSerializer;
    protected final NameTransformer _unwrapper;
    protected final JsonInclude.Include _contentInclusion;
    protected transient PropertySerializerMap _dynamicSerializers;

    @Deprecated
    public OptionalSerializer(JavaType type) {
        this((ReferenceType)type, null, null);
    }

    protected OptionalSerializer(ReferenceType optionalType, TypeSerializer vts, JsonSerializer<?> valueSer) {
        super((JavaType)optionalType);
        this._referredType = optionalType.getReferencedType();
        this._property = null;
        this._valueTypeSerializer = vts;
        this._valueSerializer = valueSer;
        this._unwrapper = null;
        this._contentInclusion = null;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
    }

    protected OptionalSerializer(OptionalSerializer base, BeanProperty property, TypeSerializer vts, JsonSerializer<?> valueSer, NameTransformer unwrapper, JsonInclude.Include contentIncl) {
        super((StdSerializer)base);
        this._referredType = base._referredType;
        this._dynamicSerializers = base._dynamicSerializers;
        this._property = property;
        this._valueTypeSerializer = vts;
        this._valueSerializer = valueSer;
        this._unwrapper = unwrapper;
        this._contentInclusion = contentIncl == JsonInclude.Include.USE_DEFAULTS || contentIncl == JsonInclude.Include.ALWAYS ? null : contentIncl;
    }

    public JsonSerializer<Optional<?>> unwrappingSerializer(NameTransformer transformer) {
        JsonSerializer ser = this._valueSerializer;
        if (ser != null) {
            ser = ser.unwrappingSerializer(transformer);
        }
        NameTransformer unwrapper = this._unwrapper == null ? transformer : NameTransformer.chainedTransformer((NameTransformer)transformer, (NameTransformer)this._unwrapper);
        return this.withResolved(this._property, this._valueTypeSerializer, ser, unwrapper, this._contentInclusion);
    }

    protected OptionalSerializer withResolved(BeanProperty prop, TypeSerializer vts, JsonSerializer<?> valueSer, NameTransformer unwrapper, JsonInclude.Include contentIncl) {
        if (this._property == prop && contentIncl == this._contentInclusion && this._valueTypeSerializer == vts && this._valueSerializer == valueSer && this._unwrapper == unwrapper) {
            return this;
        }
        return new OptionalSerializer(this, prop, vts, valueSer, unwrapper, contentIncl);
    }

    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonInclude.Value incl;
        JsonInclude.Include newIncl;
        JsonSerializer<Object> ser;
        TypeSerializer vts = this._valueTypeSerializer;
        if (vts != null) {
            vts = vts.forProperty(property);
        }
        if ((ser = this.findContentSerializer(provider, property)) == null) {
            ser = this._valueSerializer;
            if (ser == null) {
                if (this._useStatic(provider, property, this._referredType)) {
                    ser = this._findSerializer(provider, this._referredType, property);
                }
            } else {
                ser = provider.handlePrimaryContextualization(ser, property);
            }
        }
        JsonInclude.Include contentIncl = this._contentInclusion;
        if (property != null && (newIncl = (incl = property.findPropertyInclusion((MapperConfig)provider.getConfig(), Optional.class)).getContentInclusion()) != contentIncl && newIncl != JsonInclude.Include.USE_DEFAULTS) {
            contentIncl = newIncl;
        }
        return this.withResolved(property, vts, ser, this._unwrapper, contentIncl);
    }

    protected boolean _useStatic(SerializerProvider provider, BeanProperty property, JavaType referredType) {
        AnnotatedMember ann;
        if (referredType.isJavaLangObject()) {
            return false;
        }
        if (referredType.isFinal()) {
            return true;
        }
        if (referredType.useStaticType()) {
            return true;
        }
        AnnotationIntrospector intr = provider.getAnnotationIntrospector();
        if (intr != null && property != null && (ann = property.getMember()) != null) {
            JsonSerialize.Typing t = intr.findSerializationTyping((Annotated)property.getMember());
            if (t == JsonSerialize.Typing.STATIC) {
                return true;
            }
            if (t == JsonSerialize.Typing.DYNAMIC) {
                return false;
            }
        }
        return provider.isEnabled(MapperFeature.USE_STATIC_TYPING);
    }

    public boolean isEmpty(SerializerProvider provider, Optional<?> value) {
        if (value == null || !value.isPresent()) {
            return true;
        }
        if (this._contentInclusion == null) {
            return false;
        }
        Object contents = value.get();
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            try {
                ser = this._findCachedSerializer(provider, contents.getClass());
            }
            catch (JsonMappingException e) {
                throw new RuntimeJsonMappingException(e);
            }
        }
        return ser.isEmpty(provider, contents);
    }

    public boolean isUnwrappingSerializer() {
        return this._unwrapper != null;
    }

    public void serialize(Optional<?> opt, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (!opt.isPresent()) {
            if (this._unwrapper == null) {
                provider.defaultSerializeNull(gen);
            }
            return;
        }
        Object value = opt.get();
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            ser = this._findCachedSerializer(provider, value.getClass());
        }
        if (this._valueTypeSerializer != null) {
            ser.serializeWithType(value, gen, provider, this._valueTypeSerializer);
        } else {
            ser.serialize(value, gen, provider);
        }
    }

    public void serializeWithType(Optional<?> opt, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        if (!opt.isPresent()) {
            if (this._unwrapper == null) {
                provider.defaultSerializeNull(gen);
            }
            return;
        }
        typeSer.writeTypePrefixForScalar(opt, gen, Optional.class);
        this.serialize(opt, gen, provider);
        typeSer.writeTypeSuffixForScalar(opt, gen);
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonSerializer ser = this._valueSerializer;
        if (ser == null) {
            ser = this._findSerializer(visitor.getProvider(), this._referredType, this._property);
            if (this._unwrapper != null) {
                ser = ser.unwrappingSerializer(this._unwrapper);
            }
        }
        ser.acceptJsonFormatVisitor(visitor, this._referredType);
    }

    private final JsonSerializer<Object> _findCachedSerializer(SerializerProvider provider, Class<?> type) throws JsonMappingException {
        JsonSerializer ser = this._dynamicSerializers.serializerFor(type);
        if (ser == null) {
            ser = this._findSerializer(provider, type, this._property);
            if (this._unwrapper != null) {
                ser = ser.unwrappingSerializer(this._unwrapper);
            }
            this._dynamicSerializers = this._dynamicSerializers.newWith(type, ser);
        }
        return ser;
    }

    private final JsonSerializer<Object> _findSerializer(SerializerProvider provider, Class<?> type, BeanProperty prop) throws JsonMappingException {
        return provider.findValueSerializer(type, prop);
    }

    private final JsonSerializer<Object> _findSerializer(SerializerProvider provider, JavaType type, BeanProperty prop) throws JsonMappingException {
        return provider.findValueSerializer(type, prop);
    }

    protected JsonSerializer<?> findContentSerializer(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        AnnotationIntrospector intr;
        Object serDef;
        AnnotatedMember m;
        if (property != null && (m = property.getMember()) != null && (serDef = (intr = serializers.getAnnotationIntrospector()).findContentSerializer((Annotated)m)) != null) {
            return serializers.serializerInstance((Annotated)m, serDef);
        }
        return null;
    }
}

