/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.buffers.impl.ResetLimitWrappedActiveMQBuffer;
import org.apache.activemq.artemis.core.client.impl.ClientLargeMessageInternal;
import org.apache.activemq.artemis.core.client.impl.ClientMessageImpl;
import org.apache.activemq.artemis.core.client.impl.ClientMessageInternal;
import org.apache.activemq.artemis.core.client.impl.LargeMessageController;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;

public final class ClientLargeMessageImpl
extends ClientMessageImpl
implements ClientLargeMessageInternal {
    private LargeMessageController largeMessageController;
    private long largeMessageSize;

    @Override
    public void setLargeMessageSize(long largeMessageSize) {
        this.largeMessageSize = largeMessageSize;
    }

    public long getLargeMessageSize() {
        return this.largeMessageSize;
    }

    @Override
    public int getEncodeSize() {
        if (this.bodyBuffer != null) {
            return super.getEncodeSize();
        }
        return 8 + this.getHeadersAndPropertiesEncodeSize();
    }

    @Override
    public boolean isLargeMessage() {
        return true;
    }

    @Override
    public void setLargeMessageController(LargeMessageController controller) {
        this.largeMessageController = controller;
    }

    @Override
    public void checkCompletion() throws ActiveMQException {
        this.checkBuffer();
    }

    @Override
    public ActiveMQBuffer getBodyBuffer() {
        try {
            this.checkBuffer();
        }
        catch (ActiveMQException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.bodyBuffer;
    }

    @Override
    public int getBodySize() {
        return this.getLongProperty(Message.HDR_LARGE_BODY_SIZE).intValue();
    }

    @Override
    public LargeMessageController getLargeMessageController() {
        return this.largeMessageController;
    }

    @Override
    public void saveToOutputStream(OutputStream out) throws ActiveMQException {
        if (this.bodyBuffer != null) {
            super.saveToOutputStream(out);
        } else {
            this.largeMessageController.saveBuffer(out);
        }
    }

    @Override
    public ClientLargeMessageImpl setOutputStream(OutputStream out) throws ActiveMQException {
        if (this.bodyBuffer != null) {
            super.setOutputStream(out);
        } else {
            this.largeMessageController.setOutputStream(out);
        }
        return this;
    }

    @Override
    public boolean waitOutputStreamCompletion(long timeMilliseconds) throws ActiveMQException {
        if (this.bodyBuffer != null) {
            return super.waitOutputStreamCompletion(timeMilliseconds);
        }
        return this.largeMessageController.waitCompletion(timeMilliseconds);
    }

    @Override
    public void discardBody() {
        if (this.bodyBuffer != null) {
            super.discardBody();
        } else {
            this.largeMessageController.discardUnusedPackets();
        }
    }

    private void checkBuffer() throws ActiveMQException {
        if (this.bodyBuffer == null) {
            long bodySize = this.largeMessageSize + 17L;
            if (bodySize > Integer.MAX_VALUE) {
                bodySize = Integer.MAX_VALUE;
            }
            this.createBody((int)bodySize);
            this.bodyBuffer = new ResetLimitWrappedActiveMQBuffer(17, this.buffer, (MessageInternal)this);
            this.largeMessageController.saveBuffer(new ActiveMQOutputStream((ActiveMQBuffer)this.bodyBuffer));
        }
    }

    public void retrieveExistingData(ClientMessageInternal clMessage) {
        this.messageID = clMessage.getMessageID();
        this.address = clMessage.getAddress();
        this.setUserID(clMessage.getUserID());
        this.setFlowControlSize(clMessage.getFlowControlSize());
        this.setDeliveryCount(clMessage.getDeliveryCount());
        this.type = clMessage.getType();
        this.durable = clMessage.isDurable();
        this.setExpiration(clMessage.getExpiration());
        this.timestamp = clMessage.getTimestamp();
        this.priority = clMessage.getPriority();
        this.properties = clMessage.getProperties();
        this.largeMessageSize = clMessage.getLongProperty(HDR_LARGE_BODY_SIZE);
    }

    private static class ActiveMQOutputStream
    extends OutputStream {
        private final ActiveMQBuffer bufferOut;

        ActiveMQOutputStream(ActiveMQBuffer out) {
            this.bufferOut = out;
        }

        @Override
        public void write(int b) throws IOException {
            this.bufferOut.writeByte((byte)(b & 0xFF));
        }
    }
}

