/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.session.Session;
import io.undertow.server.session.SessionManager;
import io.undertow.server.session.SessionManagerStatistics;
import io.undertow.servlet.api.Deployment;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.UndertowDeploymentService;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class DeploymentDefinition
extends SimpleResourceDefinition {
    private static final ResourceDescriptionResolver DEFAULT_RESOLVER = UndertowExtension.getResolver("deployment");
    public static final DeploymentDefinition INSTANCE = new DeploymentDefinition();
    public static final AttributeDefinition SERVER = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("server", ModelType.STRING).setStorageRuntime()).build();
    public static final AttributeDefinition CONTEXT_ROOT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("context-root", ModelType.STRING).setStorageRuntime()).build();
    public static final AttributeDefinition VIRTUAL_HOST = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("virtual-host", ModelType.STRING).setStorageRuntime()).build();
    static final AttributeDefinition SESSIOND_ID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("session-id", ModelType.STRING).setRequired(true)).setAllowExpression(false)).build();
    static final OperationDefinition INVALIDATE_SESSION = new SimpleOperationDefinitionBuilder("invalidate-session", DEFAULT_RESOLVER).addParameter(SESSIOND_ID).setRuntimeOnly().setReplyType(ModelType.BOOLEAN).build();

    private DeploymentDefinition() {
        super(PathElement.pathElement((String)"subsystem", (String)"undertow"), DEFAULT_RESOLVER);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute(CONTEXT_ROOT, null);
        resourceRegistration.registerReadOnlyAttribute(VIRTUAL_HOST, null);
        resourceRegistration.registerReadOnlyAttribute(SERVER, null);
        for (SessionStat stat : SessionStat.values()) {
            resourceRegistration.registerMetric(stat.definition, (OperationStepHandler)SessionManagerStatsHandler.getInstance());
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler(INVALIDATE_SESSION, (OperationStepHandler)SessionInvalidateHandler.getInstance());
    }

    public static enum SessionStat {
        ACTIVE_SESSIONS((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("active-sessions", ModelType.INT).setUndefinedMetricValue(new ModelNode(0))).setStorageRuntime()).build()),
        EXPIRED_SESSIONS((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("expired-sessions", ModelType.INT).setUndefinedMetricValue(new ModelNode(0))).setStorageRuntime()).build()),
        SESSIONS_CREATED((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sessions-created", ModelType.INT).setUndefinedMetricValue(new ModelNode(0))).setStorageRuntime()).build()),
        SESSION_AVG_ALIVE_TIME((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("session-avg-alive-time", ModelType.INT).setUndefinedMetricValue(new ModelNode(0))).setStorageRuntime()).build()),
        SESSION_MAX_ALIVE_TIME((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("session-max-alive-time", ModelType.INT).setUndefinedMetricValue(new ModelNode(0))).setStorageRuntime()).build()),
        REJECTED_SESSIONS((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("rejected-sessions", ModelType.INT).setUndefinedMetricValue(new ModelNode(0))).setStorageRuntime()).build()),
        MAX_ACTIVE_SESSIONS((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-active-sessions", ModelType.INT).setUndefinedMetricValue(new ModelNode(0))).setStorageRuntime()).build());

        private static final Map<String, SessionStat> MAP;
        final AttributeDefinition definition;

        private SessionStat(AttributeDefinition definition) {
            this.definition = definition;
        }

        public final String toString() {
            return this.definition.getName();
        }

        public static synchronized SessionStat getStat(String stringForm) {
            return MAP.get(stringForm);
        }

        static {
            MAP = new HashMap<String, SessionStat>();
            for (SessionStat stat : EnumSet.allOf(SessionStat.class)) {
                MAP.put(stat.toString(), stat);
            }
        }
    }

    static class SessionInvalidateHandler
    extends AbstractRuntimeOnlyHandler {
        static SessionInvalidateHandler INSTANCE = new SessionInvalidateHandler();

        private SessionInvalidateHandler() {
        }

        public static SessionInvalidateHandler getInstance() {
            return INSTANCE;
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            Resource web = context.readResourceFromRoot(address.subAddress(0, address.size()), false);
            ModelNode subModel = web.getModel();
            String host = VIRTUAL_HOST.resolveModelAttribute(context, subModel).asString();
            String path = CONTEXT_ROOT.resolveModelAttribute(context, subModel).asString();
            String server = SERVER.resolveModelAttribute(context, subModel).asString();
            String sessionId = SESSIOND_ID.resolveModelAttribute(context, operation).asString();
            ModelNode result = new ModelNode();
            ServiceController controller = context.getServiceRegistry(false).getService(UndertowService.deploymentServiceName(server, host, path));
            if (controller != null && controller.getState() != ServiceController.State.UP) {
                result.set(false);
            } else {
                UndertowDeploymentService deploymentService = (UndertowDeploymentService)controller.getService();
                if (deploymentService == null || deploymentService.getDeployment() == null) {
                    result.set(false);
                } else {
                    Deployment deployment = deploymentService.getDeployment();
                    SessionManager sessionManager = deployment.getSessionManager();
                    Session session = sessionManager.getSession(sessionId);
                    if (session == null) {
                        result.set(false);
                    } else {
                        session.invalidate(null);
                        result.set(true);
                    }
                }
            }
            context.getResult().set(result);
        }
    }

    static class SessionManagerStatsHandler
    extends AbstractRuntimeOnlyHandler {
        static SessionManagerStatsHandler INSTANCE = new SessionManagerStatsHandler();

        private SessionManagerStatsHandler() {
        }

        public static SessionManagerStatsHandler getInstance() {
            return INSTANCE;
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            Resource web = context.readResourceFromRoot(address.subAddress(0, address.size()), false);
            ModelNode subModel = web.getModel();
            String host = VIRTUAL_HOST.resolveModelAttribute(context, subModel).asString();
            String path = CONTEXT_ROOT.resolveModelAttribute(context, subModel).asString();
            String server = SERVER.resolveModelAttribute(context, subModel).asString();
            SessionStat stat = SessionStat.getStat(operation.require("name").asString());
            if (stat == null) {
                context.getFailureDescription().set(UndertowLogger.ROOT_LOGGER.unknownMetric(operation.require("name").asString()));
            } else {
                ModelNode result = new ModelNode();
                ServiceController controller = context.getServiceRegistry(false).getService(UndertowService.deploymentServiceName(server, host, path));
                if (controller != null && controller.getState() != ServiceController.State.UP) {
                    return;
                }
                UndertowDeploymentService deploymentService = (UndertowDeploymentService)controller.getService();
                if (deploymentService == null || deploymentService.getDeployment() == null) {
                    return;
                }
                Deployment deployment = deploymentService.getDeployment();
                SessionManager sessionManager = deployment.getSessionManager();
                SessionManagerStatistics sms = sessionManager.getStatistics();
                switch (stat) {
                    case ACTIVE_SESSIONS: {
                        result.set(sessionManager.getActiveSessions().size());
                        break;
                    }
                    case EXPIRED_SESSIONS: {
                        if (sms == null) {
                            result.set(0);
                            break;
                        }
                        result.set((int)sms.getExpiredSessionCount());
                        break;
                    }
                    case MAX_ACTIVE_SESSIONS: {
                        if (sms == null) {
                            result.set(0);
                            break;
                        }
                        result.set((int)sms.getMaxActiveSessions());
                        break;
                    }
                    case SESSIONS_CREATED: {
                        if (sms == null) {
                            result.set(0);
                            break;
                        }
                        result.set((int)sms.getCreatedSessionCount());
                        break;
                    }
                    case SESSION_AVG_ALIVE_TIME: {
                        if (sms == null) {
                            result.set(0);
                            break;
                        }
                        result.set((int)sms.getAverageSessionAliveTime() / 1000);
                        break;
                    }
                    case SESSION_MAX_ALIVE_TIME: {
                        if (sms == null) {
                            result.set(0);
                            break;
                        }
                        result.set((int)sms.getMaxSessionAliveTime() / 1000);
                        break;
                    }
                    case REJECTED_SESSIONS: {
                        if (sms == null) {
                            result.set(0);
                            break;
                        }
                        result.set((int)sms.getRejectedSessions());
                        break;
                    }
                    default: {
                        throw new IllegalStateException(UndertowLogger.ROOT_LOGGER.unknownMetric((Object)stat));
                    }
                }
                context.getResult().set(result);
            }
        }
    }
}

