/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.table.management;

import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.jdbc.table.management.AbstractTableManager;
import org.infinispan.persistence.jdbc.table.management.DbMetaData;
import org.infinispan.util.logging.LogFactory;

class PostgresTableManager
extends AbstractTableManager {
    private static final Log LOG = (Log)LogFactory.getLog(PostgresTableManager.class, Log.class);

    PostgresTableManager(ConnectionFactory connectionFactory, TableManipulationConfiguration config, DbMetaData metaData) {
        super(connectionFactory, config, metaData, LOG);
    }

    @Override
    public String getUpdateRowSql() {
        if (this.updateRowSql == null) {
            this.updateRowSql = String.format("UPDATE %s SET %s = ? , %s = ? WHERE %s = cast(? as %s)", this.getTableName(), this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName(), this.config.idColumnType());
        }
        return this.updateRowSql;
    }

    @Override
    public String getSelectRowSql() {
        if (this.selectRowSql == null) {
            this.selectRowSql = String.format("SELECT %s, %s FROM %s WHERE %s = cast(? as %s)", this.config.idColumnName(), this.config.dataColumnName(), this.getTableName(), this.config.idColumnName(), this.config.idColumnType());
        }
        return this.selectRowSql;
    }

    @Override
    public String getSelectIdRowSql() {
        if (this.selectIdRowSql == null) {
            this.selectIdRowSql = String.format("SELECT %s FROM %s WHERE %s = cast(? as %s)", this.config.idColumnName(), this.getTableName(), this.config.idColumnName(), this.config.idColumnType());
        }
        return this.selectIdRowSql;
    }

    @Override
    public String getDeleteRowSql() {
        if (this.deleteRowSql == null) {
            this.deleteRowSql = String.format("DELETE FROM %s WHERE %s = cast(? as %s)", this.getTableName(), this.config.idColumnName(), this.config.idColumnType());
        }
        return this.deleteRowSql;
    }
}

