/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.search.BooleanWeight;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.FakeScorer;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.PriorityQueue;

final class BooleanScorer
extends BulkScorer {
    static final int SHIFT = 11;
    static final int SIZE = 2048;
    static final int MASK = 2047;
    static final int SET_SIZE = 32;
    static final int SET_MASK = 31;
    final Bucket[] buckets = new Bucket[2048];
    final long[] matching = new long[32];
    final float[] coordFactors;
    final BulkScorerAndDoc[] leads;
    final HeadPriorityQueue head;
    final TailPriorityQueue tail;
    final FakeScorer fakeScorer = new FakeScorer();
    final int minShouldMatch;
    final long cost;
    final OrCollector orCollector = new OrCollector();

    private static BulkScorer disableScoring(final BulkScorer scorer) {
        return new BulkScorer(){

            @Override
            public int score(final LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
                LeafCollector noScoreCollector = new LeafCollector(){
                    FakeScorer fake = new FakeScorer();

                    @Override
                    public void setScorer(Scorer scorer) throws IOException {
                        collector.setScorer(this.fake);
                    }

                    @Override
                    public void collect(int doc) throws IOException {
                        this.fake.doc = doc;
                        collector.collect(doc);
                    }
                };
                return scorer.score(noScoreCollector, acceptDocs, min, max);
            }

            @Override
            public long cost() {
                return scorer.cost();
            }
        };
    }

    private static long cost(Collection<BulkScorer> scorers, int minShouldMatch) {
        PriorityQueue<BulkScorer> pq = new PriorityQueue<BulkScorer>(scorers.size() - minShouldMatch + 1){

            @Override
            protected boolean lessThan(BulkScorer a, BulkScorer b) {
                return a.cost() > b.cost();
            }
        };
        for (BulkScorer scorer : scorers) {
            pq.insertWithOverflow(scorer);
        }
        long cost = 0L;
        BulkScorer scorer = (BulkScorer)pq.pop();
        while (scorer != null) {
            cost += scorer.cost();
            scorer = (BulkScorer)pq.pop();
        }
        return cost;
    }

    BooleanScorer(BooleanWeight weight, boolean disableCoord, int maxCoord, Collection<BulkScorer> scorers, int minShouldMatch, boolean needsScores) {
        if (minShouldMatch < 1 || minShouldMatch > scorers.size()) {
            throw new IllegalArgumentException("minShouldMatch should be within 1..num_scorers. Got " + minShouldMatch);
        }
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new Bucket();
        }
        this.leads = new BulkScorerAndDoc[scorers.size()];
        this.head = new HeadPriorityQueue(scorers.size() - minShouldMatch + 1);
        this.tail = new TailPriorityQueue(minShouldMatch - 1);
        this.minShouldMatch = minShouldMatch;
        for (BulkScorer scorer : scorers) {
            BulkScorerAndDoc evicted;
            if (!needsScores) {
                scorer = BooleanScorer.disableScoring(scorer);
            }
            if ((evicted = this.tail.insertWithOverflow(new BulkScorerAndDoc(scorer))) == null) continue;
            this.head.add(evicted);
        }
        this.cost = BooleanScorer.cost(scorers, minShouldMatch);
        this.coordFactors = new float[scorers.size() + 1];
        for (int i = 0; i < this.coordFactors.length; ++i) {
            this.coordFactors[i] = disableCoord ? 1.0f : weight.coord(i, maxCoord);
        }
    }

    @Override
    public long cost() {
        return this.cost;
    }

    private void scoreDocument(LeafCollector collector, int base, int i) throws IOException {
        FakeScorer fakeScorer = this.fakeScorer;
        Bucket bucket = this.buckets[i];
        if (bucket.freq >= this.minShouldMatch) {
            int doc;
            fakeScorer.freq = bucket.freq;
            fakeScorer.score = (float)bucket.score * this.coordFactors[bucket.freq];
            fakeScorer.doc = doc = base | i;
            collector.collect(doc);
        }
        bucket.freq = 0;
        bucket.score = 0.0;
    }

    private void scoreMatches(LeafCollector collector, int base) throws IOException {
        long[] matching = this.matching;
        for (int idx = 0; idx < matching.length; ++idx) {
            int ntz;
            for (long bits = matching[idx]; bits != 0L; bits ^= 1L << ntz) {
                ntz = Long.numberOfTrailingZeros(bits);
                int doc = idx << 6 | ntz;
                this.scoreDocument(collector, base, doc);
            }
        }
    }

    private void scoreWindow(LeafCollector collector, Bits acceptDocs, int base, int min, int max, BulkScorerAndDoc[] scorers, int numScorers) throws IOException {
        for (int i = 0; i < numScorers; ++i) {
            BulkScorerAndDoc scorer = scorers[i];
            assert (scorer.next < max);
            scorer.score(acceptDocs, min, max);
        }
        this.scoreMatches(collector, base);
        Arrays.fill(this.matching, 0L);
    }

    private BulkScorerAndDoc advance(int min) throws IOException {
        assert (this.tail.size() == this.minShouldMatch - 1);
        HeadPriorityQueue head = this.head;
        TailPriorityQueue tail = this.tail;
        BulkScorerAndDoc headTop = (BulkScorerAndDoc)head.top();
        BulkScorerAndDoc tailTop = (BulkScorerAndDoc)tail.top();
        while (headTop.next < min) {
            if (tailTop == null || headTop.cost <= tailTop.cost) {
                headTop.advance(min);
                headTop = (BulkScorerAndDoc)head.updateTop();
                continue;
            }
            BulkScorerAndDoc previousHeadTop = headTop;
            tailTop.advance(min);
            headTop = head.updateTop(tailTop);
            tailTop = tail.updateTop(previousHeadTop);
        }
        return headTop;
    }

    private void scoreWindow(LeafCollector collector, Bits acceptDocs, int windowBase, int windowMin, int windowMax) throws IOException {
        this.leads[0] = (BulkScorerAndDoc)this.head.pop();
        int maxFreq = 1;
        while (this.head.size() > 0 && ((BulkScorerAndDoc)this.head.top()).next < windowMax) {
            this.leads[maxFreq++] = (BulkScorerAndDoc)this.head.pop();
        }
        while (maxFreq < this.minShouldMatch && maxFreq + this.tail.size() >= this.minShouldMatch) {
            BulkScorerAndDoc candidate = (BulkScorerAndDoc)this.tail.pop();
            candidate.advance(windowMin);
            if (candidate.next < windowMax) {
                this.leads[maxFreq++] = candidate;
                continue;
            }
            this.head.add(candidate);
        }
        if (maxFreq >= this.minShouldMatch) {
            for (int i = 0; i < this.tail.size(); ++i) {
                this.leads[maxFreq++] = this.tail.get(i);
            }
            this.tail.clear();
            this.scoreWindow(collector, acceptDocs, windowBase, windowMin, windowMax, this.leads, maxFreq);
        }
        for (int i = 0; i < maxFreq; ++i) {
            BulkScorerAndDoc evicted = this.head.insertWithOverflow(this.leads[i]);
            if (evicted == null) continue;
            this.tail.add(evicted);
        }
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        this.fakeScorer.doc = -1;
        collector.setScorer(this.fakeScorer);
        BulkScorerAndDoc top = this.advance(min);
        while (top.next < max) {
            int windowBase = top.next & 0xFFFFF800;
            int windowMin = Math.max(min, windowBase);
            int windowMax = Math.min(max, windowBase + 2048);
            this.scoreWindow(collector, acceptDocs, windowBase, windowMin, windowMax);
            top = (BulkScorerAndDoc)this.head.top();
        }
        return top.next;
    }

    final class OrCollector
    implements LeafCollector {
        Scorer scorer;

        OrCollector() {
        }

        @Override
        public void setScorer(Scorer scorer) {
            this.scorer = scorer;
        }

        @Override
        public void collect(int doc) throws IOException {
            int idx;
            int i = doc & 0x7FF;
            int n = idx = i >>> 6;
            BooleanScorer.this.matching[n] = BooleanScorer.this.matching[n] | 1L << i;
            Bucket bucket = BooleanScorer.this.buckets[i];
            ++bucket.freq;
            bucket.score += (double)this.scorer.score();
        }
    }

    static final class TailPriorityQueue
    extends PriorityQueue<BulkScorerAndDoc> {
        public TailPriorityQueue(int maxSize) {
            super(maxSize);
        }

        @Override
        protected boolean lessThan(BulkScorerAndDoc a, BulkScorerAndDoc b) {
            return a.cost < b.cost;
        }

        public BulkScorerAndDoc get(int i) {
            if (i < 0 || i >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return (BulkScorerAndDoc)this.getHeapArray()[1 + i];
        }
    }

    static final class HeadPriorityQueue
    extends PriorityQueue<BulkScorerAndDoc> {
        public HeadPriorityQueue(int maxSize) {
            super(maxSize);
        }

        @Override
        protected boolean lessThan(BulkScorerAndDoc a, BulkScorerAndDoc b) {
            return a.next < b.next;
        }
    }

    private class BulkScorerAndDoc {
        final BulkScorer scorer;
        final long cost;
        int next;

        BulkScorerAndDoc(BulkScorer scorer) {
            this.scorer = scorer;
            this.cost = scorer.cost();
            this.next = -1;
        }

        void advance(int min) throws IOException {
            this.score(null, min, min);
        }

        void score(Bits acceptDocs, int min, int max) throws IOException {
            this.next = this.scorer.score(BooleanScorer.this.orCollector, acceptDocs, min, max);
        }
    }

    static class Bucket {
        double score;
        int freq;

        Bucket() {
        }
    }
}

