/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.controller;

import java.util.ArrayList;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class FindNonProgressingOperationHandler
implements OperationStepHandler {
    private static final AttributeDefinition STABILITY_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"timeout", (ModelType)ModelType.INT).setRequired(false)).setDefaultValue(new ModelNode(15))).setValidator((ParameterValidator)new IntRangeValidator(0, true))).setMeasurementUnit(MeasurementUnit.SECONDS)).build();
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("find-non-progressing-operation", DomainManagementResolver.getResolver("core", "management-operations")).setReplyType(ModelType.STRING).withFlag(OperationEntry.Flag.HOST_CONTROLLER_ONLY).build();
    static final OperationStepHandler INSTANCE = new FindNonProgressingOperationHandler();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        long timeout = TimeUnit.SECONDS.toNanos(STABILITY_TIMEOUT.resolveModelAttribute(context, operation).asLong());
        DomainManagementLogger.ROOT_LOGGER.debugf("Identification of operation not progressing after [%d] ns has been requested", timeout);
        String nonProgressing = FindNonProgressingOperationHandler.findNonProgressingOp(context, timeout);
        ModelNode result = context.getResult();
        if (nonProgressing != null) {
            result.set(nonProgressing);
        }
    }

    static String findNonProgressingOp(OperationContext context, long timeout) throws OperationFailedException {
        return FindNonProgressingOperationHandler.findNonProgressingOp(context.readResource(PathAddress.EMPTY_ADDRESS), context.getProcessType().isServer(), timeout);
    }

    static String findNonProgressingOp(Resource resource, boolean forServer, long timeout) throws OperationFailedException {
        ModelNode model;
        Resource.ResourceEntry nonProgressing = null;
        for (Resource.ResourceEntry child : resource.getChildren("active-operation")) {
            ModelNode model2 = child.getModel();
            if (model2.get("exclusive-running-time").asLong() <= timeout) continue;
            nonProgressing = child;
            ControllerLogger.MGMT_OP_LOGGER.tracef("non-progressing op: %s", (Object)nonProgressing.getModel());
            break;
        }
        if (nonProgressing != null && !forServer && (model = nonProgressing.getModel()).get("domain-rollout").asBoolean() && OperationContext.ExecutionStatus.COMPLETING.toString().equals(model.get("execution-status").asString()) && model.hasDefined("domain-uuid")) {
            ControllerLogger.MGMT_OP_LOGGER.trace((Object)"Potential domain rollout issue");
            String domainUUID = model.get("domain-uuid").asString();
            TreeSet<String> relatedIds = null;
            ArrayList<Resource.ResourceEntry> relatedExecutingOps = null;
            for (Resource.ResourceEntry activeOp : resource.getChildren("active-operation")) {
                if (nonProgressing.getName().equals(activeOp.getName())) continue;
                ModelNode opModel = activeOp.getModel();
                if (opModel.hasDefined("domain-uuid") && domainUUID.equals(opModel.get("domain-uuid").asString()) && opModel.get("running-time").asLong() > timeout) {
                    if (relatedIds == null) {
                        relatedIds = new TreeSet<String>();
                    }
                    relatedIds.add(activeOp.getName());
                    if (OperationContext.ExecutionStatus.EXECUTING.toString().equals(opModel.get("execution-status").asString())) {
                        if (relatedExecutingOps == null) {
                            relatedExecutingOps = new ArrayList<Resource.ResourceEntry>();
                        }
                        relatedExecutingOps.add(activeOp);
                        ControllerLogger.MGMT_OP_LOGGER.tracef("Related executing: %s", (Object)opModel);
                        continue;
                    }
                    ControllerLogger.MGMT_OP_LOGGER.tracef("Related non-executing: %s", (Object)opModel);
                    continue;
                }
                ControllerLogger.MGMT_OP_LOGGER.tracef("unrelated: %s", (Object)opModel);
            }
            if (relatedIds != null) {
                if (relatedExecutingOps != null && relatedExecutingOps.size() == 1) {
                    nonProgressing = (Resource.ResourceEntry)relatedExecutingOps.get(0);
                } else {
                    throw DomainManagementLogger.ROOT_LOGGER.domainRolloutNotProgressing(nonProgressing.getName(), timeout, domainUUID, relatedIds);
                }
            }
        }
        return nonProgressing == null ? null : nonProgressing.getName();
    }
}

