/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.boot.Metadata;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.search.cfg.spi.IdUniquenessResolver;

public class HibernateCoreIdUniquenessResolver
implements IdUniquenessResolver {
    private final Set<Class<?>> entities;

    public HibernateCoreIdUniquenessResolver(Metadata metadata) {
        HashSet<Class> entities = new HashSet<Class>();
        for (PersistentClass pc : metadata.getEntityBindings()) {
            Class mappedClass = pc.getMappedClass();
            if (mappedClass == null) continue;
            entities.add(mappedClass);
        }
        this.entities = Collections.unmodifiableSet(entities);
    }

    public boolean areIdsUniqueForClasses(Class<?> entityInIndex, Class<?> otherEntityInIndex) {
        Class<?> rootOfOtherEntityInIndex;
        Class<?> rootOfEntityInIndex = this.getRootEntity(entityInIndex);
        return rootOfEntityInIndex == (rootOfOtherEntityInIndex = this.getRootEntity(otherEntityInIndex));
    }

    private Class<?> getRootEntity(Class<?> entityInIndex) {
        if (!this.entities.contains(entityInIndex)) {
            return entityInIndex;
        }
        Class<?> potentialParent = entityInIndex;
        do {
            if ((potentialParent = potentialParent.getSuperclass()) == null || potentialParent == Object.class || !this.entities.contains(potentialParent)) continue;
            entityInIndex = potentialParent;
        } while (potentialParent != null && potentialParent != Object.class);
        return entityInIndex;
    }
}

