/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.lang;

import java.io.Externalizable;
import java.io.Serializable;

public class ClassHelper {
    private static Class<?> findDefaultInterface(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        Class<?>[] interfaces = cls.getInterfaces();
        Class<?> iFace = ClassHelper.extractInterface(interfaces);
        if (iFace != null) {
            return iFace;
        }
        return ClassHelper.findDefaultInterface(cls.getSuperclass());
    }

    public static Class<?> extractInterface(Class<?> ... interfaces) {
        Class<?> iFace = null;
        for (Class<?> candidate : interfaces) {
            if (Serializable.class.equals(candidate) || Externalizable.class.equals(candidate) || candidate.getName().startsWith("javax.ejb") || candidate.getName().startsWith("org.jboss.aop")) continue;
            if (iFace == null) {
                iFace = candidate;
                continue;
            }
            return null;
        }
        return iFace;
    }

    public static Class<?> getDefaultInterface(Class<?> cls) {
        Class<?> defaultInterface = ClassHelper.findDefaultInterface(cls);
        if (defaultInterface == null) {
            throw new IllegalArgumentException("Class " + cls + " does not have a default interface");
        }
        return defaultInterface;
    }
}

