/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.util;

import java.nio.CharBuffer;
import org.cryptacular.util.ByteUtil;
import org.cryptacular.util.CodecUtil;

public final class PemUtil {
    public static final int LINE_LENGTH = 64;
    public static final String HEADER_BEGIN = "-----BEGIN";
    public static final String FOOTER_END = "-----END";
    public static final String PROC_TYPE = "Proc-Type:";
    public static final String DEK_INFO = "DEK-Info:";

    private PemUtil() {
    }

    public static boolean isPem(byte[] data) {
        String start = new String(data, 0, 10, ByteUtil.ASCII_CHARSET).trim();
        if (!start.startsWith(HEADER_BEGIN) && !start.startsWith(PROC_TYPE)) {
            for (int i = 0; i < 64; ++i) {
                if (PemUtil.isBase64Char(data[i])) continue;
                if (i > 61) {
                    if (data[i] == 61) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public static boolean isBase64Char(byte b) {
        return b >= 47 && b <= 122 && (b <= 57 || b >= 65) && (b <= 90 || b >= 97) || b == 43;
    }

    public static byte[] decode(byte[] pem) {
        return PemUtil.decode(new String(pem, ByteUtil.ASCII_CHARSET));
    }

    public static byte[] decode(String pem) {
        CharBuffer line = CharBuffer.allocate(128);
        CharBuffer input = CharBuffer.wrap(pem);
        CharBuffer output = CharBuffer.allocate(pem.length());
        while (input.hasRemaining()) {
            char current = input.get();
            if (current == '\r') {
                input.get();
                PemUtil.writeLine(line, output);
                continue;
            }
            if (current == '\n') {
                PemUtil.writeLine(line, output);
                continue;
            }
            line.put(current);
        }
        if (line.hasRemaining()) {
            PemUtil.writeLine(line, output);
        }
        output.flip();
        return CodecUtil.b64(output);
    }

    private static void writeLine(CharBuffer line, CharBuffer output) {
        String s = line.flip().toString();
        if (!(s.startsWith(HEADER_BEGIN) || s.startsWith(FOOTER_END) || s.startsWith(PROC_TYPE) || s.startsWith(DEK_INFO) || s.trim().length() == 0)) {
            output.put(line);
        }
        line.clear();
    }
}

