/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.modcluster.container.Context;
import org.jboss.modcluster.container.Engine;
import org.jboss.modcluster.container.Host;
import org.jboss.modcluster.mcmp.MCMPRequestType;

@MessageLogger(projectCode="MODCLUSTER")
public interface ModClusterLogger {
    public static final ModClusterLogger LOGGER = (ModClusterLogger)Logger.getMessageLogger(ModClusterLogger.class, (String)ModClusterLogger.class.getPackage().getName());
    public static final String CATCHING_MARKER = "Catching";

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=0, value="Catching")
    public void catchingDebug(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Initializing mod_cluster version %s")
    public void init(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Initiating mod_cluster shutdown")
    public void shutdown();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3, value="Received server start event")
    public void startServer();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=4, value="Received server stop event")
    public void stopServer();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5, value="Received add context event for %s:%s")
    public void addContext(Host var1, Context var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=6, value="Received remove context event for %s:%s")
    public void removeContext(Host var1, Context var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=7, value="Received start context event for %s:%s")
    public void startContext(Host var1, Context var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8, value="Received stop context event for %s:%s")
    public void stopContext(Host var1, Context var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=9, value="Sending %s for %s")
    public void sendEngineCommand(MCMPRequestType var1, Engine var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=10, value="Sending %s for %s:%s")
    public void sendContextCommand(MCMPRequestType var1, Host var2, Context var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11, value="%s will use %s as jvm-route")
    public void detectJvmRoute(Engine var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=12, value="%s connector will use %s")
    public void detectConnectorAddress(Engine var1, InetAddress var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=20, value="Waiting to drain %d pending requests from %s:%s")
    public void drainRequests(int var1, Host var2, Context var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=21, value="All pending requests drained from %s:%s in %.1f seconds")
    public void requestsDrained(Host var1, Context var2, float var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=22, value="Failed to drain %d remaining pending requests from %s:%s within %.1f seconds")
    public void requestDrainTimeout(int var1, Host var2, Context var3, float var4);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=23, value="Waiting to drain %d active sessions from %s:%s")
    public void drainSessions(int var1, Host var2, Context var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=24, value="All active sessions drained from %s:%s in %.1f seconds")
    public void sessionsDrained(Host var1, Context var2, float var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=25, value="Failed to drain %d remaining active sessions from %s:%s within %.1f seconds")
    public void sessionDrainTimeout(int var1, Host var2, Context var3, float var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=30, value="Attempted to bind multicast socket to a unicast address: %s.  Multicast socket will not be bound to an address.")
    public void createMulticastSocketWithUnicastAddress(InetAddress var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=31, value="Could not bind multicast socket to %s (%s address): %s; make sure your multicast address is of the same type as the IP stack (IPv4 or IPv6). Multicast socket will not be bound to an address, but this may lead to cross talking (see http://www.jboss.org/community/docs/DOC-9469 for details).")
    public void potentialCrossTalking(InetAddress var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=32, value="Listening to proxy advertisements on %s")
    public void startAdvertise(InetSocketAddress var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=33, value="Failed to interrupt socket reception.")
    public void socketInterruptFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=34, value="Failed to start advertise listener")
    public void advertiseStartFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=40, value="Failed to parse response header from %2$s for %1$s command")
    public void parseHeaderFailed(@Cause Throwable var1, MCMPRequestType var2, InetSocketAddress var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=41, value="Unrecoverable syntax error %s sending %s command to %s: %s")
    public void unrecoverableErrorResponse(String var1, MCMPRequestType var2, InetSocketAddress var3, String var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=42, value="Error %s sending %s command to %s, configuration will be reset: %s")
    public void recoverableErrorResponse(String var1, MCMPRequestType var2, InetSocketAddress var3, String var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=43, value="Failed to send %s command to %s: %s")
    public void sendFailed(MCMPRequestType var1, InetSocketAddress var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=45, value="%s is not supported on this system and will be disabled.")
    public void notSupportedOnSystem(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=46, value="Starting to drain %d active sessions from %s:%s in %d seconds.")
    public void startSessionDraining(int var1, Host var2, Context var3, long var4);
}

