/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.claims;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.security.auth.x500.X500Principal;
import org.apache.cxf.helpers.CastUtils;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.AbstractContextMapper;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;

public final class LdapUtils {
    private LdapUtils() {
    }

    public static boolean isDN(String user) {
        try {
            new X500Principal(user);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static Map<String, Attribute> getAttributesOfEntry(LdapTemplate ldapTemplate, String baseDN, String objectClass, String filterAttributeName, String filterAttributeValue, String[] searchAttributes) {
        Map ldapAttributes = null;
        AttributesMapper<Map<String, Attribute>> mapper = new AttributesMapper<Map<String, Attribute>>(){

            public Map<String, Attribute> mapFromAttributes(Attributes attrs) throws NamingException {
                HashMap<String, Attribute> map = new HashMap<String, Attribute>();
                NamingEnumeration<? extends Attribute> attrEnum = attrs.getAll();
                while (attrEnum.hasMore()) {
                    Attribute att = attrEnum.next();
                    map.put(att.getID(), att);
                }
                return map;
            }
        };
        List result = null;
        AndFilter filter = new AndFilter();
        filter.and((Filter)new EqualsFilter("objectclass", objectClass)).and((Filter)new EqualsFilter(filterAttributeName, filterAttributeValue));
        result = ldapTemplate.search(baseDN == null ? "" : baseDN, filter.toString(), 2, searchAttributes, (AttributesMapper)mapper);
        if (result != null && result.size() > 0) {
            ldapAttributes = CastUtils.cast((Map)((Map)result.get(0)));
        }
        return ldapAttributes;
    }

    public static List<String> getAttributeOfEntries(LdapTemplate ldapTemplate, String baseDN, String objectClass, String filterAttributeName, String filterAttributeValue, String searchAttribute) {
        ArrayList<Filter> filters = new ArrayList<Filter>(1);
        filters.add((Filter)new EqualsFilter(filterAttributeName, filterAttributeValue));
        return LdapUtils.getAttributeOfEntries(ldapTemplate, baseDN, objectClass, filters, searchAttribute);
    }

    public static List<String> getAttributeOfEntries(LdapTemplate ldapTemplate, String baseDN, String objectClass, List<Filter> filters, String searchAttribute) {
        List ldapAttributes = null;
        AttributesMapper mapper = new AttributesMapper(){

            public Object mapFromAttributes(Attributes attrs) throws NamingException {
                NamingEnumeration<? extends Attribute> attrEnum = attrs.getAll();
                if (attrEnum.hasMore()) {
                    return (String)attrEnum.next().get();
                }
                return null;
            }
        };
        String[] searchAttributes = new String[]{searchAttribute};
        List result = null;
        AndFilter filter = new AndFilter();
        filter.and((Filter)new EqualsFilter("objectclass", objectClass));
        if (filters != null) {
            for (Filter f : filters) {
                filter.and(f);
            }
        }
        if ((result = ldapTemplate.search(baseDN == null ? "" : baseDN, filter.toString(), 2, searchAttributes, mapper)) != null && result.size() > 0) {
            ldapAttributes = CastUtils.cast((List)result);
        }
        return ldapAttributes;
    }

    public static Name getDnOfEntry(LdapTemplate ldapTemplate, String baseDN, String objectClass, String filterAttributeName, String filterAttributeValue) {
        AbstractContextMapper<Name> mapper = new AbstractContextMapper<Name>(){

            public Name doMapFromContext(DirContextOperations ctx) {
                return ctx.getDn();
            }
        };
        AndFilter filter = new AndFilter();
        filter.and((Filter)new EqualsFilter("objectclass", objectClass)).and((Filter)new EqualsFilter(filterAttributeName, filterAttributeValue));
        List result = ldapTemplate.search(baseDN == null ? "" : baseDN, filter.toString(), 2, (ContextMapper)mapper);
        if (result != null && result.size() > 0) {
            return (Name)result.get(0);
        }
        return null;
    }
}

