/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core;

import java.util.List;
import java.util.stream.Collectors;
import org.projectodd.vdx.core.I18N;
import org.projectodd.vdx.core.Stringifier;
import org.projectodd.vdx.core.Stringify;
import org.projectodd.vdx.core.Util;
import org.projectodd.vdx.core.schema.SchemaElement;

public class NonElementListStringifier
implements Stringifier {
    private final int listThreshold;
    private final int limit;
    private final boolean asBulletList;

    public NonElementListStringifier(int listThreshold, int limit) {
        this(listThreshold, limit, false);
    }

    NonElementListStringifier(int threshold, int limit, boolean asBulletList) {
        this.listThreshold = threshold;
        this.limit = limit;
        this.asBulletList = asBulletList;
    }

    @Override
    public boolean handles(Object value) {
        return Stringifier.super.handles(value) && !SchemaElement.class.isAssignableFrom(((List)value).get(0).getClass());
    }

    @Override
    public Class handledClass() {
        return List.class;
    }

    @Override
    public String asString(Object value) {
        List list = (List)value;
        List<String> values = list.stream().map(Stringify::asString).distinct().limit(this.limit > 0 ? (long)this.limit : (long)list.size()).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        if (this.listThreshold == -1 || values.size() <= this.listThreshold) {
            sb.append(Util.asCommaString(values)).append(' ');
        } else {
            sb.append('\n');
            if (this.asBulletList) {
                values.forEach(v -> sb.append("- ").append((String)v).append('\n'));
            } else {
                sb.append(Util.asColumns(values));
            }
        }
        if (this.limit < list.size()) {
            sb.append(I18N.format(I18N.Key.AND_N_MORE, list.size() - this.limit));
        }
        return sb.toString();
    }
}

