/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.interceptors;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.ejb3.component.interceptors.CancellationFlag;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.wildfly.common.Assert;

public abstract class AsyncInvocationTask
implements Runnable,
Future<Object> {
    private final CancellationFlag cancelledFlag;
    private static final int ST_RUNNING = 0;
    private static final int ST_DONE = 1;
    private static final int ST_CANCELLED = 2;
    private static final int ST_FAILED = 3;
    private volatile int status = 0;
    private Object result;
    private Exception failed;

    public AsyncInvocationTask(CancellationFlag cancelledFlag) {
        this.cancelledFlag = cancelledFlag;
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.status != 0) {
            return this.status == 2;
        }
        if (this.cancelledFlag.cancel(mayInterruptIfRunning)) {
            this.status = 2;
            this.done();
            return true;
        }
        return false;
    }

    protected abstract Object runInvocation() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object result;
        AsyncInvocationTask asyncInvocationTask = this;
        synchronized (asyncInvocationTask) {
            if (!this.cancelledFlag.runIfNotCancelled()) {
                this.status = 2;
                this.done();
                return;
            }
        }
        try {
            result = this.runInvocation();
        }
        catch (Exception e) {
            this.setFailed(e);
            return;
        }
        Future asyncResult = (Future)result;
        try {
            if (asyncResult != null) {
                result = asyncResult.get();
            }
        }
        catch (InterruptedException e) {
            this.setFailed(new IllegalStateException(e));
            return;
        }
        catch (ExecutionException e) {
            try {
                throw e.getCause();
            }
            catch (Exception ex) {
                this.setFailed(ex);
                return;
            }
            catch (Throwable throwable) {
                this.setFailed(new UndeclaredThrowableException(throwable));
                return;
            }
        }
        this.setResult(result);
    }

    private synchronized void setResult(Object result) {
        this.result = result;
        this.status = 1;
        this.done();
    }

    private synchronized void setFailed(Exception e) {
        this.failed = e;
        this.status = 3;
        this.done();
    }

    private void done() {
        this.notifyAll();
    }

    @Override
    public boolean isCancelled() {
        return this.status == 2;
    }

    @Override
    public boolean isDone() {
        return this.status == 1;
    }

    @Override
    public synchronized Object get() throws InterruptedException, ExecutionException {
        block6: while (true) {
            switch (this.status) {
                case 0: {
                    this.wait();
                    continue block6;
                }
                case 2: {
                    throw EjbLogger.ROOT_LOGGER.taskWasCancelled();
                }
                case 3: {
                    throw new ExecutionException(this.failed);
                }
                case 1: {
                    return this.result;
                }
            }
            break;
        }
        throw Assert.impossibleSwitchCase((int)this.status);
    }

    @Override
    public synchronized Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long remaining = unit.toNanos(timeout);
        long start = System.nanoTime();
        block6: while (true) {
            switch (this.status) {
                case 0: {
                    if (remaining <= 0L) {
                        throw EjbLogger.ROOT_LOGGER.failToCompleteTaskBeforeTimeOut(timeout, unit);
                    }
                    this.wait((remaining + 999999L) / 1000000L);
                    remaining -= Math.max(0L, System.nanoTime() - start);
                    continue block6;
                }
                case 2: {
                    throw EjbLogger.ROOT_LOGGER.taskWasCancelled();
                }
                case 3: {
                    throw new ExecutionException(this.failed);
                }
                case 1: {
                    return this.result;
                }
            }
            break;
        }
        throw Assert.impossibleSwitchCase((int)this.status);
    }
}

