/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.subsystem;

import java.util.HashMap;
import java.util.Map;

enum Element {
    UNKNOWN(null),
    RECOVERY_ENVIRONMENT("recovery-environment"),
    CORE_ENVIRONMENT("core-environment"),
    COORDINATOR_ENVIRONMENT("coordinator-environment"),
    OBJECT_STORE("object-store"),
    PROCESS_ID("process-id"),
    SOCKET("socket"),
    UUID("uuid"),
    JTS("jts"),
    USE_HORNETQ_STORE("use-hornetq-store"),
    USE_JOURNAL_STORE("use-journal-store"),
    JDBC_STORE("jdbc-store"),
    JDBC_STATE_STORE("state"),
    JDBC_COMMUNICATION_STORE("communication"),
    JDBC_ACTION_STORE("action"),
    CM_RESPOURCE("commit-markable-resource"),
    CM_RESOURCES("commit-markable-resources"),
    CM_TABLE("xid-location");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

