/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.criteria.path;

import java.io.Serializable;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.Type;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.jpa.criteria.CriteriaBuilderImpl;
import org.hibernate.jpa.criteria.PathSource;
import org.hibernate.jpa.criteria.path.AbstractPathImpl;
import org.hibernate.persister.collection.CollectionPersister;

public class PluralAttributePath<X>
extends AbstractPathImpl<X>
implements Serializable {
    private final PluralAttribute<?, X, ?> attribute;
    private final CollectionPersister persister;

    public PluralAttributePath(CriteriaBuilderImpl criteriaBuilder, PathSource source, PluralAttribute<?, X, ?> attribute) {
        super(criteriaBuilder, attribute.getJavaType(), source);
        this.attribute = attribute;
        this.persister = this.resolvePersister(criteriaBuilder, attribute);
    }

    private CollectionPersister resolvePersister(CriteriaBuilderImpl criteriaBuilder, PluralAttribute attribute) {
        SessionFactoryImplementor sfi = criteriaBuilder.getEntityManagerFactory().getSessionFactory();
        return sfi.getCollectionPersister(this.resolveRole(attribute));
    }

    private String resolveRole(PluralAttribute attribute) {
        Class roleOwnerType = attribute.getDeclaringType().getJavaType();
        if (attribute.getDeclaringType().getPersistenceType() == Type.PersistenceType.MAPPED_SUPERCLASS && this.getPathSource().getModel().getBindableType() == Bindable.BindableType.ENTITY_TYPE) {
            EntityType entityTypeNearestDeclaringType = (EntityType)this.getPathSource().getModel();
            EntityType previousType = entityTypeNearestDeclaringType;
            for (IdentifiableType superType = entityTypeNearestDeclaringType.getSupertype(); superType != attribute.getDeclaringType(); superType = superType.getSupertype()) {
                if (superType == null) {
                    throw new IllegalStateException(String.format("Cannot determine nearest EntityType extending mapped superclass [%s]; [%s] extends [%s], but supertype of [%s] is null", attribute.getDeclaringType().getJavaType().getName(), ((EntityType)this.getPathSource().getModel()).getJavaType().getName(), previousType.getJavaType().getName(), previousType.getJavaType().getName()));
                }
                if (superType.getPersistenceType() == Type.PersistenceType.ENTITY) {
                    entityTypeNearestDeclaringType = (EntityType)superType;
                }
                previousType = superType;
            }
            roleOwnerType = entityTypeNearestDeclaringType.getJavaType();
        }
        return roleOwnerType.getName() + '.' + attribute.getName();
    }

    public PluralAttribute<?, X, ?> getAttribute() {
        return this.attribute;
    }

    public CollectionPersister getPersister() {
        return this.persister;
    }

    @Override
    protected boolean canBeDereferenced() {
        return false;
    }

    @Override
    protected Attribute locateAttributeInternal(String attributeName) {
        throw new IllegalArgumentException("Plural attribute paths cannot be further dereferenced");
    }

    public Bindable<X> getModel() {
        return null;
    }

    @Override
    public <T extends X> PluralAttributePath<T> treatAs(Class<T> treatAsType) {
        throw new UnsupportedOperationException("Plural attribute path [" + this.getPathSource().getPathIdentifier() + '.' + this.attribute.getName() + "] cannot be dereferenced");
    }
}

