/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.FutureListener;
import org.jgroups.util.NotifyingFuture;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherException;
import org.wildfly.clustering.dispatcher.CommandResponse;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.server.Addressable;
import org.wildfly.clustering.server.dispatcher.CommandMarshaller;
import org.wildfly.clustering.server.dispatcher.NoSuchService;
import org.wildfly.clustering.server.dispatcher.SimpleCommandResponse;

public class ChannelCommandDispatcher<C>
implements CommandDispatcher<C> {
    private static final RspFilter FILTER = new RspFilter(){

        public boolean isAcceptable(Object response, Address sender) {
            return !(response instanceof NoSuchService);
        }

        public boolean needMoreResponses() {
            return true;
        }
    };
    private final MessageDispatcher dispatcher;
    private final CommandMarshaller<C> marshaller;
    private final NodeFactory<Address> factory;
    private final long timeout;
    private final CommandDispatcher<C> localDispatcher;
    private final Runnable closeTask;

    public ChannelCommandDispatcher(MessageDispatcher dispatcher, CommandMarshaller<C> marshaller, NodeFactory<Address> factory, long timeout, CommandDispatcher<C> localDispatcher, Runnable closeTask) {
        this.dispatcher = dispatcher;
        this.marshaller = marshaller;
        this.factory = factory;
        this.timeout = timeout;
        this.localDispatcher = localDispatcher;
        this.closeTask = closeTask;
    }

    public void close() {
        this.closeTask.run();
    }

    public <R> Map<Node, CommandResponse<R>> executeOnCluster(Command<R, ? super C> command, Node ... excludedNodes) throws CommandDispatcherException {
        Message message = this.createMessage(command);
        RequestOptions options = this.createRequestOptions(excludedNodes);
        try {
            RspList responses = this.dispatcher.castMessage(null, message, options);
            HashMap<Node, CommandResponse<R>> results = new HashMap<Node, CommandResponse<R>>();
            for (Map.Entry entry : responses.entrySet()) {
                Address address = (Address)entry.getKey();
                Rsp response = (Rsp)entry.getValue();
                if (!response.wasReceived() || response.wasSuspected()) continue;
                results.put(this.factory.createNode((Object)address), ChannelCommandDispatcher.createCommandResponse(response));
            }
            return results;
        }
        catch (Exception e) {
            throw new CommandDispatcherException((Throwable)e);
        }
    }

    public <R> Map<Node, Future<R>> submitOnCluster(Command<R, ? super C> command, Node ... excludedNodes) throws CommandDispatcherException {
        ConcurrentHashMap results = new ConcurrentHashMap();
        FutureListener listener = future -> {
            try {
                ((RspList)future.get()).keySet().stream().map(address -> this.factory.createNode(address)).forEach(node -> {
                    Future cfr_ignored_0 = (Future)results.remove(node);
                });
            }
            catch (CancellationException cancellationException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        };
        Message message = this.createMessage(command);
        RequestOptions options = this.createRequestOptions(excludedNodes);
        try {
            NotifyingFuture futureResponses = this.dispatcher.castMessageWithFuture(null, message, options, listener);
            HashSet<Node> excluded = excludedNodes != null ? new HashSet<Node>(Arrays.asList(excludedNodes)) : Collections.emptySet();
            for (Address address : this.dispatcher.getChannel().getView().getMembers()) {
                Node node = this.factory.createNode((Object)address);
                if (excluded.contains(node)) continue;
                Future future2 = new Future<R>((Future)futureResponses, address){
                    final /* synthetic */ Future val$futureResponses;
                    final /* synthetic */ Address val$address;
                    {
                        this.val$futureResponses = future;
                        this.val$address = address;
                    }

                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        return this.val$futureResponses.cancel(mayInterruptIfRunning);
                    }

                    @Override
                    public R get() throws InterruptedException, ExecutionException {
                        Map responses = (Map)this.val$futureResponses.get();
                        Rsp response = (Rsp)responses.get(this.val$address);
                        if (response == null) {
                            throw new CancellationException();
                        }
                        return ChannelCommandDispatcher.createCommandResponse(response).get();
                    }

                    @Override
                    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        Map responses = (Map)this.val$futureResponses.get(timeout, unit);
                        Rsp response = (Rsp)responses.get(this.val$address);
                        if (response == null) {
                            throw new CancellationException();
                        }
                        return ChannelCommandDispatcher.createCommandResponse(response).get();
                    }

                    @Override
                    public boolean isCancelled() {
                        return this.val$futureResponses.isCancelled();
                    }

                    @Override
                    public boolean isDone() {
                        return this.val$futureResponses.isDone();
                    }
                };
                results.put(node, future2);
            }
            return results;
        }
        catch (Exception e) {
            throw new CommandDispatcherException((Throwable)e);
        }
    }

    public <R> CommandResponse<R> executeOnNode(Command<R, ? super C> command, Node node) throws CommandDispatcherException {
        if (this.isLocal(node)) {
            return this.localDispatcher.executeOnNode(command, node);
        }
        Message message = this.createMessage(command, node);
        RequestOptions options = this.createRequestOptions();
        try {
            NotifyingFuture future = this.dispatcher.sendMessageWithFuture(message, options);
            return new SimpleCommandResponse(future.get());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new SimpleCommandResponse(e);
        }
        catch (ExecutionException e) {
            return new SimpleCommandResponse(e);
        }
        catch (Exception e) {
            throw new CommandDispatcherException((Throwable)e);
        }
    }

    public <R> Future<R> submitOnNode(Command<R, ? super C> command, Node node) throws CommandDispatcherException {
        if (this.isLocal(node)) {
            return this.localDispatcher.submitOnNode(command, node);
        }
        Message message = this.createMessage(command, node);
        RequestOptions options = this.createRequestOptions();
        try {
            return this.dispatcher.sendMessageWithFuture(message, options);
        }
        catch (Exception e) {
            throw new CommandDispatcherException((Throwable)e);
        }
    }

    private <R> Message createMessage(Command<R, ? super C> command) {
        return this.createMessage(command, null);
    }

    private <R> Message createMessage(Command<R, ? super C> command, Node node) {
        try {
            return new Message(ChannelCommandDispatcher.getAddress(node), this.getLocalAddress(), this.marshaller.marshal(command));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private boolean isLocal(Node node) {
        return this.getLocalAddress().equals(ChannelCommandDispatcher.getAddress(node));
    }

    private static Address getAddress(Node node) {
        return node instanceof Addressable ? ((Addressable)node).getAddress() : null;
    }

    private RequestOptions createRequestOptions(Node ... excludedNodes) {
        RequestOptions options = this.createRequestOptions();
        if (excludedNodes != null && excludedNodes.length > 0) {
            Address[] addresses = new Address[excludedNodes.length];
            for (int i = 0; i < excludedNodes.length; ++i) {
                addresses[i] = ChannelCommandDispatcher.getAddress(excludedNodes[i]);
            }
            options.setExclusionList(addresses);
        }
        return options;
    }

    private RequestOptions createRequestOptions() {
        return new RequestOptions(ResponseMode.GET_ALL, this.timeout, false, FILTER, new Message.Flag[]{Message.Flag.DONT_BUNDLE, Message.Flag.OOB});
    }

    static <R> CommandResponse<R> createCommandResponse(Rsp<R> response) {
        Throwable exception = response.getException();
        return exception != null ? new SimpleCommandResponse(exception) : new SimpleCommandResponse<Object>(response.getValue());
    }

    private Address getLocalAddress() {
        return this.dispatcher.getChannel().getAddress();
    }
}

