/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.registry.RegistryFactory;
import org.wildfly.clustering.server.registry.FunctionalRegistryFactory;
import org.wildfly.clustering.server.registry.LocalRegistry;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;

public class LocalRegistryFactoryBuilder<K, V>
implements CapabilityServiceBuilder<RegistryFactory<K, V>> {
    private final ServiceName name;
    private final String containerName;
    private final String cacheName;
    private volatile ValueDependency<Group> group;

    public LocalRegistryFactoryBuilder(ServiceName name, String containerName, String cacheName) {
        this.name = name;
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<RegistryFactory<K, V>> configure(CapabilityServiceSupport support) {
        this.group = new InjectedValueDependency(ClusteringCacheRequirement.GROUP.getServiceName(support, this.containerName, this.cacheName), Group.class);
        return this;
    }

    public ServiceBuilder<RegistryFactory<K, V>> build(ServiceTarget target) {
        Value value = () -> new FunctionalRegistryFactory((entry, closeTask) -> new LocalRegistry((Group)this.group.getValue(), entry, (Runnable)closeTask));
        return this.group.register(target.addService(this.name, (Service)new ValueService(value)).setInitialMode(ServiceController.Mode.ON_DEMAND));
    }
}

