/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.parsing;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.parsing.WriteUtils;
import org.jboss.as.domain.management.LegacyConfigurationChangeResourceDefinition;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.access.AccessIdentityResourceDefinition;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionPropertyResourceDefinition;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionResourceDefinition;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.parsing.AccessControlXml;
import org.jboss.as.domain.management.parsing.ManagementXml;
import org.jboss.as.domain.management.parsing.ManagementXmlDelegate;
import org.jboss.as.domain.management.security.AbstractPlugInAuthResourceDefinition;
import org.jboss.as.domain.management.security.AdvancedUserSearchResourceDefintion;
import org.jboss.as.domain.management.security.BaseLdapGroupSearchResource;
import org.jboss.as.domain.management.security.BaseLdapUserSearchResource;
import org.jboss.as.domain.management.security.GroupToPrincipalResourceDefinition;
import org.jboss.as.domain.management.security.JaasAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.KerberosAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.KeystoreAttributes;
import org.jboss.as.domain.management.security.KeytabResourceDefinition;
import org.jboss.as.domain.management.security.LdapAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.LdapAuthorizationResourceDefinition;
import org.jboss.as.domain.management.security.LdapCacheResourceDefinition;
import org.jboss.as.domain.management.security.LocalAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PlugInAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PrincipalToGroupResourceDefinition;
import org.jboss.as.domain.management.security.PropertiesAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PropertiesAuthorizationResourceDefinition;
import org.jboss.as.domain.management.security.PropertyResourceDefinition;
import org.jboss.as.domain.management.security.SSLServerIdentityResourceDefinition;
import org.jboss.as.domain.management.security.SecretServerIdentityResourceDefinition;
import org.jboss.as.domain.management.security.SecurityRealmResourceDefinition;
import org.jboss.as.domain.management.security.UserIsDnResourceDefintion;
import org.jboss.as.domain.management.security.UserResourceDefinition;
import org.jboss.as.domain.management.security.UserSearchResourceDefintion;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

final class ManagementXml_5
implements ManagementXml {
    private final Namespace namespace;
    private final ManagementXmlDelegate delegate;

    ManagementXml_5(Namespace namespace, ManagementXmlDelegate delegate) {
        this.namespace = namespace;
        this.delegate = delegate;
    }

    @Override
    public void parseManagement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, boolean requireNativeInterface) throws XMLStreamException {
        int securityRealmsCount = 0;
        int connectionsCount = 0;
        int managementInterfacesCount = 0;
        ModelNode managementAddress = address.clone().add("core-service", "management");
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SECURITY_REALMS: {
                    if (++securityRealmsCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    if (this.delegate.parseSecurityRealms(reader, managementAddress, list)) continue block9;
                    this.parseSecurityRealms(reader, managementAddress, list);
                    continue block9;
                }
                case OUTBOUND_CONNECTIONS: {
                    if (++connectionsCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    if (this.delegate.parseOutboundConnections(reader, managementAddress, list)) continue block9;
                    this.parseOutboundConnections(reader, managementAddress, list);
                    continue block9;
                }
                case MANAGEMENT_INTERFACES: {
                    if (++managementInterfacesCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    if (this.delegate.parseManagementInterfaces(reader, managementAddress, list)) continue block9;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case AUDIT_LOG: {
                    if (this.delegate.parseAuditLog(reader, managementAddress, list)) continue block9;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case ACCESS_CONTROL: {
                    if (this.delegate.parseAccessControl(reader, managementAddress, list)) continue block9;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case IDENTITY: {
                    this.parseIdentity(reader, managementAddress, list);
                    continue block9;
                }
                case CONFIGURATION_CHANGES: {
                    this.parseConfigurationChanges(reader, managementAddress, list);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (requireNativeInterface && managementInterfacesCount < 1) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, EnumSet.of(Element.MANAGEMENT_INTERFACES));
        }
    }

    private void parseConfigurationChanges(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        PathAddress operationAddress = PathAddress.pathAddress((ModelNode)address);
        operationAddress = operationAddress.append(new PathElement[]{LegacyConfigurationChangeResourceDefinition.PATH});
        ModelNode add = Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathAddress)operationAddress, (PathElement[])new PathElement[0]));
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_HISTORY: {
                    LegacyConfigurationChangeResourceDefinition.MAX_HISTORY.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        list.add(add);
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseIdentity(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        PathAddress operationAddress = PathAddress.pathAddress((ModelNode)address);
        operationAddress = operationAddress.append(new PathElement[]{AccessIdentityResourceDefinition.PATH_ELEMENT});
        ModelNode add = Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathAddress)operationAddress, (PathElement[])new PathElement[0]));
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SECURITY_DOMAIN: {
                    AccessIdentityResourceDefinition.SECURITY_DOMAIN.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        list.add(add);
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseOutboundConnections(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case LDAP: {
                    this.parseLdapConnection(reader, address, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseLdapConnection(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        list.add(add);
        ModelNode connectionAddress = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.URL);
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    connectionAddress = address.clone().add("ldap-connection", value);
                    add.get("address").set(connectionAddress);
                    continue block15;
                }
                case URL: {
                    LdapConnectionResourceDefinition.URL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block15;
                }
                case SEARCH_DN: {
                    LdapConnectionResourceDefinition.SEARCH_DN.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block15;
                }
                case SEARCH_CREDENTIAL: {
                    LdapConnectionResourceDefinition.SEARCH_CREDENTIAL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block15;
                }
                case SECURITY_REALM: {
                    LdapConnectionResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block15;
                }
                case INITIAL_CONTEXT_FACTORY: {
                    LdapConnectionResourceDefinition.INITIAL_CONTEXT_FACTORY.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block15;
                }
                case REFERRALS: {
                    LdapConnectionResourceDefinition.REFERRALS.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block15;
                }
                case HANDLES_REFERRALS_FOR: {
                    for (String url : reader.getListAttributeValue(i)) {
                        LdapConnectionResourceDefinition.HANDLES_REFERRALS_FOR.parseAndAddParameterElement(url, add, (XMLStreamReader)reader);
                    }
                    continue block15;
                }
                case ALWAYS_SEND_CLIENT_CERT: {
                    LdapConnectionResourceDefinition.ALWAYS_SEND_CLIENT_CERT.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block15;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        boolean propertiesFound = false;
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    if (propertiesFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    propertiesFound = true;
                    this.parseLdapConnectionProperties(reader, connectionAddress, list);
                    continue block17;
                }
                case SEARCH_CREDENTIAL_REFERENCE: {
                    LdapConnectionResourceDefinition.SEARCH_CREDENTIAL_REFERENCE.getParser().parseElement((AttributeDefinition)LdapConnectionResourceDefinition.SEARCH_CREDENTIAL_REFERENCE, reader, add);
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseLdapConnectionProperties(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.VALUE);
                    ModelNode add = new ModelNode();
                    add.get("operation").set("add");
                    int count = reader.getAttributeCount();
                    block8: for (int i = 0; i < count; ++i) {
                        String value = reader.getAttributeValue(i);
                        if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                        Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                        required.remove(attribute);
                        switch (attribute) {
                            case NAME: {
                                add.get("address").set(address.clone()).add("property", value);
                                continue block8;
                            }
                            case VALUE: {
                                LdapConnectionPropertyResourceDefinition.VALUE.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                                continue block8;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (required.size() > 0) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    list.add(add);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSecurityRealms(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SECURITY_REALM: {
                    this.parseSecurityRealm(reader, address, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSecurityRealm(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
        String realmName = reader.getAttributeValue(0);
        ModelNode realmAddress = address.clone();
        realmAddress.add("security-realm", realmName);
        ModelNode add = new ModelNode();
        add.get("address").set(realmAddress);
        add.get("operation").set("add");
        list.add(add);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PLUG_INS: {
                    this.parsePlugIns(reader, realmAddress, list);
                    continue block6;
                }
                case SERVER_IDENTITIES: {
                    this.parseServerIdentities(reader, realmAddress, list);
                    continue block6;
                }
                case AUTHENTICATION: {
                    this.parseAuthentication(reader, realmAddress, list);
                    continue block6;
                }
                case AUTHORIZATION: {
                    this.parseAuthorization(reader, add, list);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parsePlugIns(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PLUG_IN: {
                    ModelNode plugIn = new ModelNode();
                    plugIn.get("operation").set("add");
                    String moduleValue = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.MODULE.getLocalName());
                    ModelNode newAddress = realmAddress.clone();
                    newAddress.add("plug-in", moduleValue);
                    plugIn.get("address").set(newAddress);
                    list.add(plugIn);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseServerIdentities(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SECRET: {
                    this.parseSecret(reader, realmAddress, list);
                    continue block5;
                }
                case SSL: {
                    this.parseSSL(reader, realmAddress, list);
                    continue block5;
                }
                case KERBEROS: {
                    this.parseKerberosIdentity(reader, realmAddress, list);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSecret(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode secret = new ModelNode();
        secret.get("operation").set("add");
        secret.get("address").set(realmAddress).add("server-identity", "secret");
        int count = reader.getAttributeCount();
        boolean hasSecret = false;
        if (count > 0) {
            String secretValue = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.VALUE.getLocalName());
            SecretServerIdentityResourceDefinition.VALUE.parseAndSetParameter(secretValue, secret, (XMLStreamReader)reader);
            hasSecret = true;
        } else {
            block3: while (reader.hasNext() && reader.nextTag() != 2) {
                ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
                Element element = Element.forName((String)reader.getLocalName());
                switch (element) {
                    case CREDENTIAL_REFERENCE: {
                        SecretServerIdentityResourceDefinition.CREDENTIAL_REFERENCE.getParser().parseElement((AttributeDefinition)SecretServerIdentityResourceDefinition.CREDENTIAL_REFERENCE, reader, secret);
                        hasSecret = true;
                        continue block3;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
        if (!hasSecret) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.VALUE.getLocalName()));
        }
        list.add(secret);
    }

    private void parseSSL(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode ssl = new ModelNode();
        ssl.get("operation").set("add");
        ssl.get("address").set(realmAddress).add("server-identity", "ssl");
        list.add(ssl);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PROTOCOL: {
                    SSLServerIdentityResourceDefinition.PROTOCOL.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ENGINE: {
                    this.parseEngine(reader, ssl);
                    continue block8;
                }
                case KEYSTORE: {
                    this.parseKeystore(reader, ssl, true);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseEngine(XMLExtendedStreamReader reader, ModelNode addOperation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED_CIPHER_SUITES: {
                    for (String value : reader.getListAttributeValue(i)) {
                        SSLServerIdentityResourceDefinition.ENABLED_CIPHER_SUITES.parseAndAddParameterElement(value, addOperation, (XMLStreamReader)reader);
                    }
                    continue block4;
                }
                case ENABLED_PROTOCOLS: {
                    for (String value : reader.getListAttributeValue(i)) {
                        SSLServerIdentityResourceDefinition.ENABLED_PROTOCOLS.parseAndAddParameterElement(value, addOperation, (XMLStreamReader)reader);
                    }
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseKeystore(XMLExtendedStreamReader reader, ModelNode addOperation, boolean extended) throws XMLStreamException {
        boolean keystorePasswordSet = false;
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PROVIDER: {
                    KeystoreAttributes.KEYSTORE_PROVIDER.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block13;
                }
                case PATH: {
                    KeystoreAttributes.KEYSTORE_PATH.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block13;
                }
                case KEYSTORE_PASSWORD: {
                    KeystoreAttributes.KEYSTORE_PASSWORD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    keystorePasswordSet = true;
                    continue block13;
                }
                case RELATIVE_TO: {
                    KeystoreAttributes.KEYSTORE_RELATIVE_TO.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block13;
                }
                case ALIAS: {
                    if (extended) {
                        KeystoreAttributes.ALIAS.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                        continue block13;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                case KEY_PASSWORD: {
                    if (extended) {
                        KeystoreAttributes.KEY_PASSWORD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                        continue block13;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                case GENERATE_SELF_SIGNED_CERTIFICATE_HOST: {
                    if (extended) {
                        KeystoreAttributes.GENERATE_SELF_SIGNED_CERTIFICATE_HOST.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                        continue block13;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE: {
                    KeystoreAttributes.KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE.getParser().parseElement((AttributeDefinition)KeystoreAttributes.KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE, reader, addOperation);
                    keystorePasswordSet = true;
                    continue block14;
                }
                case KEY_PASSWORD_CREDENTIAL_REFERENCE: {
                    if (extended) {
                        KeystoreAttributes.KEY_PASSWORD_CREDENTIAL_REFERENCE.getParser().parseElement((AttributeDefinition)KeystoreAttributes.KEY_PASSWORD_CREDENTIAL_REFERENCE, reader, addOperation);
                        continue block14;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!keystorePasswordSet) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.KEYSTORE_PASSWORD));
        }
    }

    private void parseKerberosIdentity(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode kerberos = new ModelNode();
        kerberos.get("operation").set("add");
        ModelNode kerberosAddress = realmAddress.clone().add("server-identity", "kerberos");
        kerberos.get("address").set(kerberosAddress);
        list.add(kerberos);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case KEYTAB: {
                    this.parseKeyTab(reader, kerberosAddress, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseKeyTab(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode keytab = new ModelNode();
        keytab.get("operation").set("add");
        list.add(keytab);
        EnumSet<Attribute> requiredAttributes = EnumSet.of(Attribute.PRINCIPAL, Attribute.PATH);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case PRINCIPAL: {
                    keytab.get("address").set(parentAddress).add("keytab", value);
                    continue block7;
                }
                case PATH: {
                    KeytabResourceDefinition.PATH.parseAndSetParameter(value, keytab, (XMLStreamReader)reader);
                    continue block7;
                }
                case RELATIVE_TO: {
                    KeytabResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, keytab, (XMLStreamReader)reader);
                    continue block7;
                }
                case FOR_HOSTS: {
                    for (String host : reader.getListAttributeValue(i)) {
                        KeytabResourceDefinition.FOR_HOSTS.parseAndAddParameterElement(host, keytab, (XMLStreamReader)reader);
                    }
                    continue block7;
                }
                case DEBUG: {
                    KeytabResourceDefinition.DEBUG.parseAndSetParameter(value, keytab, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseAuthentication(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        boolean trustStoreFound = false;
        boolean localFound = false;
        boolean kerberosFound = false;
        boolean usernamePasswordFound = false;
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case JAAS: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseJaasAuthentication(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block10;
                }
                case KERBEROS: {
                    if (kerberosFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseKerberosAuthentication(reader, realmAddress, list);
                    kerberosFound = true;
                    continue block10;
                }
                case LDAP: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseLdapAuthentication(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block10;
                }
                case PROPERTIES: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parsePropertiesAuthentication(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block10;
                }
                case TRUSTSTORE: {
                    if (trustStoreFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseTruststore(reader, realmAddress, list);
                    trustStoreFound = true;
                    continue block10;
                }
                case USERS: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseUsersAuthentication(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block10;
                }
                case PLUG_IN: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ModelNode parentAddress = realmAddress.clone().add("authentication");
                    this.parsePlugIn_Authentication(reader, parentAddress, list);
                    usernamePasswordFound = true;
                    continue block10;
                }
                case LOCAL: {
                    if (localFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseLocalAuthentication(reader, realmAddress, list);
                    localFound = true;
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseKerberosAuthentication(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "kerberos");
        ModelNode kerberos = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(kerberos);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case REMOVE_REALM: {
                    KerberosAuthenticationResourceDefinition.REMOVE_REALM.parseAndSetParameter(value, kerberos, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseJaasAuthentication(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "jaas");
        ModelNode jaas = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(jaas);
        boolean nameFound = false;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    if (nameFound) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    nameFound = true;
                    JaasAuthenticationResourceDefinition.NAME.parseAndSetParameter(value, jaas, (XMLStreamReader)reader);
                    continue block4;
                }
                case ASSIGN_GROUPS: {
                    JaasAuthenticationResourceDefinition.ASSIGN_GROUPS.parseAndSetParameter(value, jaas, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!nameFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseLdapAuthenticationAttributes(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.CONNECTION, Attribute.BASE_DN);
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case CONNECTION: {
                    LdapAuthenticationResourceDefinition.CONNECTION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case BASE_DN: {
                    LdapAuthenticationResourceDefinition.BASE_DN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case RECURSIVE: {
                    LdapAuthenticationResourceDefinition.RECURSIVE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case USER_DN: {
                    LdapAuthenticationResourceDefinition.USER_DN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case ALLOW_EMPTY_PASSWORDS: {
                    LdapAuthenticationResourceDefinition.ALLOW_EMPTY_PASSWORDS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case USERNAME_LOAD: {
                    LdapAuthenticationResourceDefinition.USERNAME_LOAD.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
    }

    private void parseLdapAuthentication(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "ldap");
        ModelNode ldapAuthentication = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(ldapAuthentication);
        this.parseLdapAuthenticationAttributes(reader, ldapAuthentication);
        ModelNode addLdapCache = null;
        boolean choiceFound = false;
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            if (choiceFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case CACHE: {
                    if (addLdapCache != null) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    addLdapCache = this.parseLdapCache(reader);
                    continue block5;
                }
                case ADVANCED_FILTER: {
                    choiceFound = true;
                    String filter = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.FILTER.getLocalName());
                    LdapAuthenticationResourceDefinition.ADVANCED_FILTER.parseAndSetParameter(filter, ldapAuthentication, (XMLStreamReader)reader);
                    continue block5;
                }
                case USERNAME_FILTER: {
                    choiceFound = true;
                    String usernameAttr = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.ATTRIBUTE.getLocalName());
                    LdapAuthenticationResourceDefinition.USERNAME_FILTER.parseAndSetParameter(usernameAttr, ldapAuthentication, (XMLStreamReader)reader);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!choiceFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.ADVANCED_FILTER, Element.USERNAME_FILTER));
        }
        if (addLdapCache != null) {
            this.correctCacheAddress(ldapAuthentication, addLdapCache);
            list.add(addLdapCache);
        }
    }

    private ModelNode parseLdapCache(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode addr = new ModelNode();
        ModelNode addCacheOp = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        String type = "by-search-time";
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    if ("by-access-time".equals(value) || "by-search-time".equals(value)) {
                        type = value;
                        continue block6;
                    }
                    throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                }
                case EVICTION_TIME: {
                    LdapCacheResourceDefinition.EVICTION_TIME.parseAndSetParameter(value, addCacheOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case CACHE_FAILURES: {
                    LdapCacheResourceDefinition.CACHE_FAILURES.parseAndSetParameter(value, addCacheOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case MAX_CACHE_SIZE: {
                    LdapCacheResourceDefinition.MAX_CACHE_SIZE.parseAndSetParameter(value, addCacheOp, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addCacheOp.get("address").add("cache", type);
        return addCacheOp;
    }

    private void correctCacheAddress(ModelNode parentAdd, ModelNode cacheAdd) {
        List addressList = cacheAdd.get("address").asPropertyList();
        ModelNode cacheAddress = parentAdd.get("address").clone();
        for (Property current : addressList) {
            cacheAddress.add(current.getName(), current.getValue().asString());
        }
        cacheAdd.get("address").set(cacheAddress);
    }

    private void parseLocalAuthentication(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "local");
        ModelNode local = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(local);
        int count = reader.getAttributeCount();
        HashSet<Attribute> attributesFound = new HashSet<Attribute>(count);
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            if (attributesFound.contains(attribute)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            attributesFound.add(attribute);
            switch (attribute) {
                case DEFAULT_USER: {
                    LocalAuthenticationResourceDefinition.DEFAULT_USER.parseAndSetParameter(value, local, (XMLStreamReader)reader);
                    continue block5;
                }
                case ALLOWED_USERS: {
                    LocalAuthenticationResourceDefinition.ALLOWED_USERS.parseAndSetParameter(value, local, (XMLStreamReader)reader);
                    continue block5;
                }
                case SKIP_GROUP_LOADING: {
                    LocalAuthenticationResourceDefinition.SKIP_GROUP_LOADING.parseAndSetParameter(value, local, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parsePropertiesAuthentication(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "properties");
        ModelNode properties = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(properties);
        String path = null;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    path = value;
                    PropertiesAuthenticationResourceDefinition.PATH.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block5;
                }
                case RELATIVE_TO: {
                    PropertiesAuthenticationResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block5;
                }
                case PLAIN_TEXT: {
                    PropertiesAuthenticationResourceDefinition.PLAIN_TEXT.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (path == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseUsersAuthentication(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode usersAddress = realmAddress.clone().add("authentication", "users");
        list.add(Util.getEmptyOperation((String)"add", (ModelNode)usersAddress));
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case USER: {
                    this.parseUser(reader, usersAddress, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseUser(XMLExtendedStreamReader reader, ModelNode usersAddress, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.USERNAME.getLocalName());
        String userName = reader.getAttributeValue(0);
        ModelNode userAddress = usersAddress.clone().add("user", userName);
        ModelNode user = Util.getEmptyOperation((String)"add", (ModelNode)userAddress);
        list.add(user);
        boolean hasPassword = false;
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PASSWORD: {
                    String password = reader.getElementText();
                    UserResourceDefinition.PASSWORD.parseAndSetParameter(password, user, (XMLStreamReader)reader);
                    hasPassword = true;
                    continue block4;
                }
                case CREDENTIAL_REFERENCE: {
                    UserResourceDefinition.CREDENTIAL_REFERENCE.getParser().parseElement((AttributeDefinition)UserResourceDefinition.CREDENTIAL_REFERENCE, reader, user);
                    hasPassword = true;
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!hasPassword) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, EnumSet.of(Element.PASSWORD));
        }
    }

    private void parseTruststore(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").set(realmAddress).add("authentication", "truststore");
        this.parseKeystore(reader, op, false);
        list.add(op);
    }

    private void parseAuthorization(XMLExtendedStreamReader reader, ModelNode realmAdd, List<ModelNode> list) throws XMLStreamException {
        ModelNode realmAddress = realmAdd.get("address");
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAP_GROUPS_TO_ROLES: {
                    SecurityRealmResourceDefinition.MAP_GROUPS_TO_ROLES.parseAndSetParameter(value, realmAdd, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        boolean authzFound = false;
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (authzFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PROPERTIES: {
                    this.parsePropertiesAuthorization(reader, realmAddress, list);
                    authzFound = true;
                    continue block9;
                }
                case PLUG_IN: {
                    ModelNode parentAddress = realmAddress.clone().add("authorization");
                    this.parsePlugIn_Authorization(reader, parentAddress, list);
                    authzFound = true;
                    continue block9;
                }
                case LDAP: {
                    this.parseLdapAuthorization(reader, realmAddress, list);
                    authzFound = true;
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseLdapAuthorization(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authorization", "ldap");
        ModelNode ldapAuthorization = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(ldapAuthorization);
        EnumSet<Attribute> required = EnumSet.of(Attribute.CONNECTION);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case CONNECTION: {
                    LdapAuthorizationResourceDefinition.CONNECTION.parseAndSetParameter(value, ldapAuthorization, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        HashSet<Element> foundElements = new HashSet<Element>();
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (!foundElements.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case USERNAME_TO_DN: {
                    this.parseUsernameToDn(reader, addr, list);
                    continue block8;
                }
                case GROUP_SEARCH: {
                    this.parseGroupSearch(reader, addr, list);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseUsernameToDn(XMLExtendedStreamReader reader, ModelNode ldapAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode childAdd = new ModelNode();
        childAdd.get("operation").set("add");
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case FORCE: {
                    BaseLdapUserSearchResource.FORCE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        boolean filterFound = false;
        ModelNode cacheAdd = null;
        ModelNode address = ldapAddress.clone().add("username-to-dn");
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (filterFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case CACHE: {
                    if (cacheAdd != null) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    cacheAdd = this.parseLdapCache(reader);
                    continue block10;
                }
                case USERNAME_IS_DN: {
                    filterFound = true;
                    this.parseUsernameIsDn(reader, address, childAdd);
                    continue block10;
                }
                case USERNAME_FILTER: {
                    filterFound = true;
                    this.parseUsernameFilter(reader, address, childAdd);
                    continue block10;
                }
                case ADVANCED_FILTER: {
                    filterFound = true;
                    this.parseAdvancedFilter(reader, address, childAdd);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!filterFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.USERNAME_IS_DN, Element.USERNAME_FILTER, Element.ADVANCED_FILTER));
        }
        list.add(childAdd);
        if (cacheAdd != null) {
            this.correctCacheAddress(childAdd, cacheAdd);
            list.add(cacheAdd);
        }
    }

    private void parseUsernameIsDn(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addOp.get("address").set(parentAddress.clone().add("username-is-dn"));
    }

    private void parseUsernameFilter(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        boolean baseDnFound = false;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case BASE_DN: {
                    baseDnFound = true;
                    UserSearchResourceDefintion.BASE_DN.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case RECURSIVE: {
                    UserSearchResourceDefintion.RECURSIVE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case USER_DN_ATTRIBUTE: {
                    UserSearchResourceDefintion.USER_DN_ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case ATTRIBUTE: {
                    UserSearchResourceDefintion.ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!baseDnFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.BASE_DN));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addOp.get("address").set(parentAddress.clone().add("username-filter"));
    }

    private void parseAdvancedFilter(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        boolean baseDnFound = false;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case BASE_DN: {
                    baseDnFound = true;
                    AdvancedUserSearchResourceDefintion.BASE_DN.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case RECURSIVE: {
                    AdvancedUserSearchResourceDefintion.RECURSIVE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case USER_DN_ATTRIBUTE: {
                    UserSearchResourceDefintion.USER_DN_ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case FILTER: {
                    AdvancedUserSearchResourceDefintion.FILTER.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!baseDnFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.BASE_DN));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addOp.get("address").set(parentAddress.clone().add("advanced-filter"));
    }

    private void parseGroupSearch(XMLExtendedStreamReader reader, ModelNode ldapAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode childAdd = new ModelNode();
        childAdd.get("operation").set("add");
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case GROUP_NAME: {
                    BaseLdapGroupSearchResource.GROUP_NAME.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block11;
                }
                case ITERATIVE: {
                    BaseLdapGroupSearchResource.ITERATIVE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block11;
                }
                case GROUP_DN_ATTRIBUTE: {
                    BaseLdapGroupSearchResource.GROUP_DN_ATTRIBUTE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block11;
                }
                case GROUP_NAME_ATTRIBUTE: {
                    BaseLdapGroupSearchResource.GROUP_NAME_ATTRIBUTE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        boolean filterFound = false;
        ModelNode cacheAdd = null;
        ModelNode address = ldapAddress.clone().add("group-search");
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (filterFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case CACHE: {
                    if (cacheAdd != null) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    cacheAdd = this.parseLdapCache(reader);
                    continue block12;
                }
                case GROUP_TO_PRINCIPAL: {
                    filterFound = true;
                    this.parseGroupToPrincipal(reader, address, childAdd);
                    continue block12;
                }
                case PRINCIPAL_TO_GROUP: {
                    filterFound = true;
                    this.parsePrincipalToGroup(reader, address, childAdd);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!filterFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.GROUP_TO_PRINCIPAL, Element.PRINCIPAL_TO_GROUP));
        }
        list.add(childAdd);
        if (cacheAdd != null) {
            this.correctCacheAddress(childAdd, cacheAdd);
            list.add(cacheAdd);
        }
    }

    private void parseGroupToPrincipalAttributes(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        boolean baseDnFound = false;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case BASE_DN: {
                    baseDnFound = true;
                    GroupToPrincipalResourceDefinition.BASE_DN.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case RECURSIVE: {
                    GroupToPrincipalResourceDefinition.RECURSIVE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case SEARCH_BY: {
                    GroupToPrincipalResourceDefinition.SEARCH_BY.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case PREFER_ORIGINAL_CONNECTION: {
                    GroupToPrincipalResourceDefinition.PREFER_ORIGINAL_CONNECTION.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!baseDnFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.BASE_DN));
        }
    }

    private void parseGroupToPrincipal(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        this.parseGroupToPrincipalAttributes(reader, addOp);
        boolean elementFound = false;
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (elementFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            elementFound = true;
            switch (element) {
                case MEMBERSHIP_FILTER: {
                    this.parseMembershipFilter(reader, addOp);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        addOp.get("address").set(parentAddress.clone().add("group-to-principal"));
    }

    private void parseMembershipFilter(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        boolean principalAttribute = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PRINCIPAL_ATTRIBUTE: {
                    principalAttribute = true;
                    GroupToPrincipalResourceDefinition.PRINCIPAL_ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!principalAttribute) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PRINCIPAL_ATTRIBUTE));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parsePrincipalToGroup(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case GROUP_ATTRIBUTE: {
                    PrincipalToGroupResourceDefinition.GROUP_ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case PREFER_ORIGINAL_CONNECTION: {
                    PrincipalToGroupResourceDefinition.PREFER_ORIGINAL_CONNECTION.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case SKIP_MISSING_GROUPS: {
                    PrincipalToGroupResourceDefinition.SKIP_MISSING_GROUPS.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case PARSE_ROLES_FROM_DN: {
                    PrincipalToGroupResourceDefinition.PARSE_ROLES_FROM_DN.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addOp.get("address").set(parentAddress.clone().add("principal-to-group"));
    }

    private void parsePropertiesAuthorization(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authorization", "properties");
        ModelNode properties = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(properties);
        String path = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    path = value;
                    PropertiesAuthorizationResourceDefinition.PATH.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block4;
                }
                case RELATIVE_TO: {
                    PropertiesAuthorizationResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (path == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parsePlugIn_Authentication(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = parentAddress.clone().add("plug-in");
        ModelNode plugIn = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(plugIn);
        boolean nameFound = false;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    PlugInAuthenticationResourceDefinition.NAME.parseAndSetParameter(value, plugIn, (XMLStreamReader)reader);
                    nameFound = true;
                    continue block10;
                }
                case MECHANISM: {
                    PlugInAuthenticationResourceDefinition.MECHANISM.parseAndSetParameter(value, plugIn, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!nameFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    block12: while (reader.hasNext() && reader.nextTag() != 2) {
                        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
                        Element propertyElement = Element.forName((String)reader.getLocalName());
                        switch (propertyElement) {
                            case PROPERTY: {
                                this.parseProperty(reader, addr, list);
                                continue block12;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parsePlugIn_Authorization(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = parentAddress.clone().add("plug-in");
        ModelNode plugIn = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(plugIn);
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
        String plugInName = reader.getAttributeValue(0);
        plugIn.get("name").set(plugInName);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    block7: while (reader.hasNext() && reader.nextTag() != 2) {
                        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
                        Element propertyElement = Element.forName((String)reader.getLocalName());
                        switch (propertyElement) {
                            case PROPERTY: {
                                this.parseProperty(reader, addr, list);
                                continue block7;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseProperty(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        list.add(add);
        boolean addressFound = false;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    add.get("address").set(parentAddress).add("property", value);
                    addressFound = true;
                    continue block4;
                }
                case VALUE: {
                    PropertyResourceDefinition.VALUE.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!addressFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    @Override
    public void writeManagement(XMLExtendedStreamWriter writer, ModelNode management, boolean allowInterfaces) throws XMLStreamException {
        ModelNode identity;
        boolean hasSecurityRealm = management.hasDefined("security-realm");
        boolean hasConnection = management.hasDefined("ldap-connection");
        boolean hasInterface = allowInterfaces && management.hasDefined("management-interface");
        ModelNode accessAuthorization = management.hasDefined("access") ? management.get(new String[]{"access", "authorization"}) : null;
        boolean accessAuthorizationDefined = accessAuthorization != null && accessAuthorization.isDefined();
        boolean hasServerGroupRoles = accessAuthorizationDefined && accessAuthorization.hasDefined("server-group-scoped-role");
        boolean hasConfigurationChanges = management.hasDefined(new String[]{"service", "configuration-changes"});
        boolean hasHostRoles = accessAuthorizationDefined && (accessAuthorization.hasDefined("host-scoped-role") || accessAuthorization.hasDefined("host-scoped-roles"));
        boolean hasRoleMapping = accessAuthorizationDefined && accessAuthorization.hasDefined("role-mapping");
        Map<String, Map<String, Set<String>>> configuredAccessConstraints = AccessControlXml.getConfiguredAccessConstraints(accessAuthorization);
        boolean hasProvider = accessAuthorizationDefined && accessAuthorization.hasDefined(AccessAuthorizationResourceDefinition.PROVIDER.getName());
        boolean hasCombinationPolicy = accessAuthorizationDefined && accessAuthorization.hasDefined(AccessAuthorizationResourceDefinition.PERMISSION_COMBINATION_POLICY.getName());
        ModelNode auditLog = management.hasDefined("access") ? management.get(new String[]{"access", "audit"}) : new ModelNode();
        ModelNode modelNode = identity = management.hasDefined("access") ? management.get(new String[]{"access", "identity"}) : new ModelNode();
        if (!(hasSecurityRealm || hasConnection || hasInterface || hasServerGroupRoles || hasHostRoles || hasRoleMapping || configuredAccessConstraints.size() != 0 || hasProvider || hasCombinationPolicy || auditLog.isDefined() || identity.isDefined())) {
            return;
        }
        writer.writeStartElement(Element.MANAGEMENT.getLocalName());
        if (hasConfigurationChanges) {
            this.writeConfigurationChanges(writer, management.get(new String[]{"service", "configuration-changes"}));
        }
        if (identity.isDefined()) {
            this.writeIdentity(writer, identity);
        }
        if (hasSecurityRealm) {
            this.writeSecurityRealm(writer, management);
        }
        if (hasConnection) {
            this.writeOutboundConnections(writer, management);
        }
        if (auditLog.isDefined() && !this.delegate.writeAuditLog(writer, auditLog)) {
            throw DomainManagementLogger.ROOT_LOGGER.unsupportedResource("audit");
        }
        if (allowInterfaces && hasInterface) {
            this.writeManagementInterfaces(writer, management);
        }
        if (accessAuthorizationDefined && !this.delegate.writeAccessControl(writer, accessAuthorization)) {
            throw DomainManagementLogger.ROOT_LOGGER.unsupportedResource("authorization");
        }
        writer.writeEndElement();
    }

    private void writeIdentity(XMLExtendedStreamWriter writer, ModelNode identity) throws XMLStreamException {
        writer.writeStartElement(Element.IDENTITY.getLocalName());
        AccessIdentityResourceDefinition.SECURITY_DOMAIN.marshallAsAttribute(identity, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeSecurityRealm(XMLExtendedStreamWriter writer, ModelNode management) throws XMLStreamException {
        ModelNode securityRealms = management.get("security-realm");
        writer.writeStartElement(Element.SECURITY_REALMS.getLocalName());
        for (String variableName : securityRealms.keys()) {
            writer.writeStartElement(Element.SECURITY_REALM.getLocalName());
            WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.NAME, (String)variableName);
            ModelNode realm = securityRealms.get(variableName);
            if (realm.hasDefined("plug-in")) {
                this.writePlugIns(writer, realm.get("plug-in"));
            }
            if (realm.hasDefined("server-identity")) {
                this.writeServerIdentities(writer, realm);
            }
            if (realm.hasDefined("authentication")) {
                this.writeAuthentication(writer, realm);
            }
            this.writeAuthorization(writer, realm);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writePlugIns(XMLExtendedStreamWriter writer, ModelNode plugIns) throws XMLStreamException {
        writer.writeStartElement(Element.PLUG_INS.getLocalName());
        for (String variable : plugIns.keys()) {
            writer.writeEmptyElement(Element.PLUG_IN.getLocalName());
            writer.writeAttribute(Attribute.MODULE.getLocalName(), variable);
        }
        writer.writeEndElement();
    }

    private void writeServerIdentities(XMLExtendedStreamWriter writer, ModelNode realm) throws XMLStreamException {
        writer.writeStartElement(Element.SERVER_IDENTITIES.getLocalName());
        ModelNode serverIdentities = realm.get("server-identity");
        if (serverIdentities.hasDefined("kerberos")) {
            writer.writeStartElement(Element.KERBEROS.getLocalName());
            ModelNode kerberos = serverIdentities.require("kerberos");
            if (kerberos.hasDefined("keytab")) {
                ModelNode keytabs = kerberos.get("keytab");
                for (String current : keytabs.keys()) {
                    ModelNode currentNode = keytabs.get(current);
                    writer.writeEmptyElement("keytab");
                    writer.writeAttribute(Attribute.PRINCIPAL.getLocalName(), current);
                    KeytabResourceDefinition.PATH.marshallAsAttribute(currentNode, (XMLStreamWriter)writer);
                    KeytabResourceDefinition.RELATIVE_TO.marshallAsAttribute(currentNode, (XMLStreamWriter)writer);
                    KeytabResourceDefinition.FOR_HOSTS.getMarshaller().marshallAsAttribute((AttributeDefinition)KeytabResourceDefinition.FOR_HOSTS, currentNode, true, (XMLStreamWriter)writer);
                    KeytabResourceDefinition.DEBUG.marshallAsAttribute(currentNode, (XMLStreamWriter)writer);
                }
            }
            writer.writeEndElement();
        }
        if (serverIdentities.hasDefined("ssl")) {
            boolean hasCredential;
            writer.writeStartElement(Element.SSL.getLocalName());
            ModelNode ssl = serverIdentities.get("ssl");
            SSLServerIdentityResourceDefinition.PROTOCOL.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
            if (ssl.hasDefined("enabled-cipher-suites") || ssl.hasDefined("enabled-protocols")) {
                writer.writeEmptyElement(Element.ENGINE.getLocalName());
                SSLServerIdentityResourceDefinition.ENABLED_CIPHER_SUITES.marshallAsElement(ssl, (XMLStreamWriter)writer);
                SSLServerIdentityResourceDefinition.ENABLED_PROTOCOLS.marshallAsElement(ssl, (XMLStreamWriter)writer);
            }
            boolean hasProvider = ssl.hasDefined("keystore-provider") && !"JKS".equalsIgnoreCase(ssl.require("keystore-provider").asString());
            boolean bl = hasCredential = ssl.hasDefined(KeystoreAttributes.KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE.getName()) || ssl.hasDefined(KeystoreAttributes.KEY_PASSWORD_CREDENTIAL_REFERENCE.getName());
            if (hasProvider || ssl.hasDefined(KeystoreAttributes.KEYSTORE_PATH.getName())) {
                if (hasCredential) {
                    writer.writeStartElement(Element.KEYSTORE.getLocalName());
                } else {
                    writer.writeEmptyElement(Element.KEYSTORE.getLocalName());
                }
                KeystoreAttributes.KEYSTORE_PROVIDER.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
                KeystoreAttributes.KEYSTORE_PATH.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
                KeystoreAttributes.KEYSTORE_RELATIVE_TO.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
                KeystoreAttributes.KEYSTORE_PASSWORD.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
                KeystoreAttributes.ALIAS.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
                KeystoreAttributes.KEY_PASSWORD.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
                KeystoreAttributes.GENERATE_SELF_SIGNED_CERTIFICATE_HOST.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
                KeystoreAttributes.KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE.marshallAsElement(ssl, (XMLStreamWriter)writer);
                KeystoreAttributes.KEY_PASSWORD_CREDENTIAL_REFERENCE.marshallAsElement(ssl, (XMLStreamWriter)writer);
                if (hasCredential) {
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
        }
        if (serverIdentities.hasDefined("secret")) {
            ModelNode secret = serverIdentities.get("secret");
            boolean hasCredential = secret.hasDefined(SecretServerIdentityResourceDefinition.CREDENTIAL_REFERENCE.getName());
            if (hasCredential) {
                writer.writeStartElement(Element.SECRET.getLocalName());
            } else {
                writer.writeEmptyElement(Element.SECRET.getLocalName());
            }
            SecretServerIdentityResourceDefinition.VALUE.marshallAsAttribute(secret, (XMLStreamWriter)writer);
            SecretServerIdentityResourceDefinition.CREDENTIAL_REFERENCE.marshallAsElement(secret, (XMLStreamWriter)writer);
            if (hasCredential) {
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private void writeLdapCacheIfDefined(XMLExtendedStreamWriter writer, ModelNode parent) throws XMLStreamException {
        if (parent.hasDefined("cache")) {
            String type;
            ModelNode cache;
            ModelNode cacheHolder = parent.require("cache");
            if (cacheHolder.hasDefined("by-access-time")) {
                cache = cacheHolder.require("by-access-time");
                type = "by-access-time";
            } else if (cacheHolder.hasDefined("by-search-time")) {
                cache = cacheHolder.require("by-search-time");
                type = "by-search-time";
            } else {
                return;
            }
            writer.writeStartElement(Element.CACHE.getLocalName());
            if (!type.equals("by-search-time")) {
                writer.writeAttribute(Attribute.TYPE.getLocalName(), type);
            }
            LdapCacheResourceDefinition.EVICTION_TIME.marshallAsAttribute(cache, (XMLStreamWriter)writer);
            LdapCacheResourceDefinition.CACHE_FAILURES.marshallAsAttribute(cache, (XMLStreamWriter)writer);
            LdapCacheResourceDefinition.MAX_CACHE_SIZE.marshallAsAttribute(cache, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private void writeAuthentication(XMLExtendedStreamWriter writer, ModelNode realm) throws XMLStreamException {
        writer.writeStartElement(Element.AUTHENTICATION.getLocalName());
        ModelNode authentication = realm.require("authentication");
        if (authentication.hasDefined("truststore")) {
            ModelNode truststore = authentication.require("truststore");
            boolean hasCredential = truststore.hasDefined(KeystoreAttributes.KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE.getName());
            if (hasCredential) {
                writer.writeStartElement(Element.TRUSTSTORE.getLocalName());
            } else {
                writer.writeEmptyElement(Element.TRUSTSTORE.getLocalName());
            }
            KeystoreAttributes.KEYSTORE_PROVIDER.marshallAsAttribute(truststore, (XMLStreamWriter)writer);
            KeystoreAttributes.KEYSTORE_PATH.marshallAsAttribute(truststore, (XMLStreamWriter)writer);
            KeystoreAttributes.KEYSTORE_RELATIVE_TO.marshallAsAttribute(truststore, (XMLStreamWriter)writer);
            KeystoreAttributes.KEYSTORE_PASSWORD.marshallAsAttribute(truststore, (XMLStreamWriter)writer);
            KeystoreAttributes.KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE.marshallAsElement(truststore, (XMLStreamWriter)writer);
            if (hasCredential) {
                writer.writeEndElement();
            }
        }
        if (authentication.hasDefined("local")) {
            ModelNode local = authentication.require("local");
            writer.writeStartElement(Element.LOCAL.getLocalName());
            LocalAuthenticationResourceDefinition.DEFAULT_USER.marshallAsAttribute(local, (XMLStreamWriter)writer);
            LocalAuthenticationResourceDefinition.ALLOWED_USERS.marshallAsAttribute(local, (XMLStreamWriter)writer);
            LocalAuthenticationResourceDefinition.SKIP_GROUP_LOADING.marshallAsAttribute(local, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (authentication.hasDefined("kerberos")) {
            ModelNode kerberos = authentication.require("kerberos");
            writer.writeEmptyElement(Element.KERBEROS.getLocalName());
            KerberosAuthenticationResourceDefinition.REMOVE_REALM.marshallAsAttribute(kerberos, (XMLStreamWriter)writer);
        }
        if (authentication.hasDefined("jaas")) {
            ModelNode jaas = authentication.get("jaas");
            writer.writeStartElement(Element.JAAS.getLocalName());
            JaasAuthenticationResourceDefinition.NAME.marshallAsAttribute(jaas, (XMLStreamWriter)writer);
            JaasAuthenticationResourceDefinition.ASSIGN_GROUPS.marshallAsAttribute(jaas, (XMLStreamWriter)writer);
            writer.writeEndElement();
        } else if (authentication.hasDefined("ldap")) {
            ModelNode userLdap = authentication.get("ldap");
            writer.writeStartElement(Element.LDAP.getLocalName());
            LdapAuthenticationResourceDefinition.CONNECTION.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            LdapAuthenticationResourceDefinition.BASE_DN.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            LdapAuthenticationResourceDefinition.RECURSIVE.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            LdapAuthenticationResourceDefinition.USER_DN.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            LdapAuthenticationResourceDefinition.ALLOW_EMPTY_PASSWORDS.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            LdapAuthenticationResourceDefinition.USERNAME_LOAD.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            this.writeLdapCacheIfDefined(writer, userLdap);
            if (LdapAuthenticationResourceDefinition.USERNAME_FILTER.isMarshallable(userLdap)) {
                writer.writeEmptyElement(Element.USERNAME_FILTER.getLocalName());
                LdapAuthenticationResourceDefinition.USERNAME_FILTER.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            } else if (LdapAuthenticationResourceDefinition.ADVANCED_FILTER.isMarshallable(userLdap)) {
                writer.writeEmptyElement(Element.ADVANCED_FILTER.getLocalName());
                LdapAuthenticationResourceDefinition.ADVANCED_FILTER.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        } else if (authentication.hasDefined("properties")) {
            ModelNode properties = authentication.require("properties");
            writer.writeEmptyElement(Element.PROPERTIES.getLocalName());
            PropertiesAuthenticationResourceDefinition.PATH.marshallAsAttribute(properties, (XMLStreamWriter)writer);
            PropertiesAuthenticationResourceDefinition.RELATIVE_TO.marshallAsAttribute(properties, (XMLStreamWriter)writer);
            PropertiesAuthenticationResourceDefinition.PLAIN_TEXT.marshallAsAttribute(properties, (XMLStreamWriter)writer);
        } else if (authentication.has("users")) {
            ModelNode userDomain = authentication.get("users");
            ModelNode users = userDomain.hasDefined("user") ? userDomain.require("user") : new ModelNode().setEmptyObject();
            writer.writeStartElement(Element.USERS.getLocalName());
            for (String userName : users.keys()) {
                ModelNode currentUser = users.get(userName);
                writer.writeStartElement(Element.USER.getLocalName());
                writer.writeAttribute(Attribute.USERNAME.getLocalName(), userName);
                UserResourceDefinition.PASSWORD.marshallAsElement(currentUser, (XMLStreamWriter)writer);
                UserResourceDefinition.CREDENTIAL_REFERENCE.marshallAsElement(currentUser, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        } else if (authentication.hasDefined("plug-in")) {
            this.writePlugIn_Authentication(writer, authentication.get("plug-in"));
        }
        writer.writeEndElement();
    }

    private void writePlugIn_Authentication(XMLExtendedStreamWriter writer, ModelNode plugIn) throws XMLStreamException {
        writer.writeStartElement(Element.PLUG_IN.getLocalName());
        AbstractPlugInAuthResourceDefinition.NAME.marshallAsAttribute(plugIn, (XMLStreamWriter)writer);
        PlugInAuthenticationResourceDefinition.MECHANISM.marshallAsAttribute(plugIn, (XMLStreamWriter)writer);
        if (plugIn.hasDefined("property")) {
            writer.writeStartElement("properties");
            ModelNode properties = plugIn.get("property");
            for (String current : properties.keys()) {
                writer.writeEmptyElement("property");
                writer.writeAttribute(Attribute.NAME.getLocalName(), current);
                PropertyResourceDefinition.VALUE.marshallAsAttribute(properties.get(current), (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeAuthorization(XMLExtendedStreamWriter writer, ModelNode realm) throws XMLStreamException {
        String mapGroupsToRoles;
        String defaultMapGroupsToRoles = Boolean.toString(SecurityRealmResourceDefinition.MAP_GROUPS_TO_ROLES.getDefaultValue().asBoolean());
        String string = mapGroupsToRoles = realm.hasDefined("map-groups-to-roles") ? realm.require("map-groups-to-roles").asString() : defaultMapGroupsToRoles;
        if (realm.hasDefined("authorization") || !defaultMapGroupsToRoles.equals(mapGroupsToRoles)) {
            writer.writeStartElement(Element.AUTHORIZATION.getLocalName());
            SecurityRealmResourceDefinition.MAP_GROUPS_TO_ROLES.marshallAsAttribute(realm, (XMLStreamWriter)writer);
            if (realm.hasDefined("authorization")) {
                ModelNode authorization = realm.require("authorization");
                if (authorization.hasDefined("properties")) {
                    ModelNode properties = authorization.require("properties");
                    writer.writeEmptyElement(Element.PROPERTIES.getLocalName());
                    PropertiesAuthorizationResourceDefinition.PATH.marshallAsAttribute(properties, (XMLStreamWriter)writer);
                    PropertiesAuthorizationResourceDefinition.RELATIVE_TO.marshallAsAttribute(properties, (XMLStreamWriter)writer);
                } else if (authorization.hasDefined("plug-in")) {
                    this.writePlugIn_Authorization(writer, authorization.get("plug-in"));
                } else if (authorization.hasDefined("ldap")) {
                    this.writeLdapAuthorization(writer, authorization.get("ldap"));
                }
            }
            writer.writeEndElement();
        }
    }

    private void writeLdapAuthorization(XMLExtendedStreamWriter writer, ModelNode ldapNode) throws XMLStreamException {
        ModelNode groupSearch;
        ModelNode usenameToDn;
        writer.writeStartElement(Element.LDAP.getLocalName());
        LdapAuthorizationResourceDefinition.CONNECTION.marshallAsAttribute(ldapNode, (XMLStreamWriter)writer);
        if (ldapNode.hasDefined("username-to-dn") && ((usenameToDn = ldapNode.require("username-to-dn")).hasDefined("username-is-dn") || usenameToDn.hasDefined("username-filter") || usenameToDn.hasDefined("advanced-filter"))) {
            writer.writeStartElement(Element.USERNAME_TO_DN.getLocalName());
            if (usenameToDn.hasDefined("username-is-dn")) {
                ModelNode usernameIsDn = usenameToDn.require("username-is-dn");
                UserIsDnResourceDefintion.FORCE.marshallAsAttribute(usernameIsDn, (XMLStreamWriter)writer);
                this.writeLdapCacheIfDefined(writer, usernameIsDn);
                writer.writeEmptyElement(Element.USERNAME_IS_DN.getLocalName());
            } else if (usenameToDn.hasDefined("username-filter")) {
                ModelNode usernameFilter = usenameToDn.require("username-filter");
                UserSearchResourceDefintion.FORCE.marshallAsAttribute(usernameFilter, (XMLStreamWriter)writer);
                this.writeLdapCacheIfDefined(writer, usernameFilter);
                writer.writeStartElement(Element.USERNAME_FILTER.getLocalName());
                UserSearchResourceDefintion.BASE_DN.marshallAsAttribute(usernameFilter, (XMLStreamWriter)writer);
                UserSearchResourceDefintion.RECURSIVE.marshallAsAttribute(usernameFilter, (XMLStreamWriter)writer);
                UserSearchResourceDefintion.USER_DN_ATTRIBUTE.marshallAsAttribute(usernameFilter, (XMLStreamWriter)writer);
                UserSearchResourceDefintion.ATTRIBUTE.marshallAsAttribute(usernameFilter, (XMLStreamWriter)writer);
                writer.writeEndElement();
            } else {
                ModelNode advancedFilter = usenameToDn.require("advanced-filter");
                AdvancedUserSearchResourceDefintion.FORCE.marshallAsAttribute(advancedFilter, (XMLStreamWriter)writer);
                this.writeLdapCacheIfDefined(writer, advancedFilter);
                writer.writeStartElement(Element.ADVANCED_FILTER.getLocalName());
                AdvancedUserSearchResourceDefintion.BASE_DN.marshallAsAttribute(advancedFilter, (XMLStreamWriter)writer);
                AdvancedUserSearchResourceDefintion.RECURSIVE.marshallAsAttribute(advancedFilter, (XMLStreamWriter)writer);
                AdvancedUserSearchResourceDefintion.USER_DN_ATTRIBUTE.marshallAsAttribute(advancedFilter, (XMLStreamWriter)writer);
                AdvancedUserSearchResourceDefintion.FILTER.marshallAsAttribute(advancedFilter, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (ldapNode.hasDefined("group-search") && ((groupSearch = ldapNode.require("group-search")).hasDefined("group-to-principal") || groupSearch.hasDefined("principal-to-group"))) {
            writer.writeStartElement(Element.GROUP_SEARCH.getLocalName());
            if (groupSearch.hasDefined("group-to-principal")) {
                ModelNode groupToPrincipal = groupSearch.require("group-to-principal");
                GroupToPrincipalResourceDefinition.GROUP_NAME.marshallAsAttribute(groupToPrincipal, (XMLStreamWriter)writer);
                GroupToPrincipalResourceDefinition.ITERATIVE.marshallAsAttribute(groupToPrincipal, (XMLStreamWriter)writer);
                GroupToPrincipalResourceDefinition.GROUP_DN_ATTRIBUTE.marshallAsAttribute(groupToPrincipal, (XMLStreamWriter)writer);
                GroupToPrincipalResourceDefinition.GROUP_NAME_ATTRIBUTE.marshallAsAttribute(groupToPrincipal, (XMLStreamWriter)writer);
                this.writeLdapCacheIfDefined(writer, groupToPrincipal);
                writer.writeStartElement(Element.GROUP_TO_PRINCIPAL.getLocalName());
                GroupToPrincipalResourceDefinition.SEARCH_BY.marshallAsAttribute(groupToPrincipal, (XMLStreamWriter)writer);
                GroupToPrincipalResourceDefinition.BASE_DN.marshallAsAttribute(groupToPrincipal, (XMLStreamWriter)writer);
                GroupToPrincipalResourceDefinition.RECURSIVE.marshallAsAttribute(groupToPrincipal, (XMLStreamWriter)writer);
                GroupToPrincipalResourceDefinition.PREFER_ORIGINAL_CONNECTION.marshallAsAttribute(groupToPrincipal, (XMLStreamWriter)writer);
                writer.writeStartElement(Element.MEMBERSHIP_FILTER.getLocalName());
                GroupToPrincipalResourceDefinition.PRINCIPAL_ATTRIBUTE.marshallAsAttribute(groupToPrincipal, (XMLStreamWriter)writer);
                writer.writeEndElement();
                writer.writeEndElement();
            } else {
                ModelNode principalToGroup = groupSearch.require("principal-to-group");
                PrincipalToGroupResourceDefinition.GROUP_NAME.marshallAsAttribute(principalToGroup, (XMLStreamWriter)writer);
                PrincipalToGroupResourceDefinition.ITERATIVE.marshallAsAttribute(principalToGroup, (XMLStreamWriter)writer);
                PrincipalToGroupResourceDefinition.GROUP_DN_ATTRIBUTE.marshallAsAttribute(principalToGroup, (XMLStreamWriter)writer);
                PrincipalToGroupResourceDefinition.GROUP_NAME_ATTRIBUTE.marshallAsAttribute(principalToGroup, (XMLStreamWriter)writer);
                this.writeLdapCacheIfDefined(writer, principalToGroup);
                writer.writeStartElement(Element.PRINCIPAL_TO_GROUP.getLocalName());
                PrincipalToGroupResourceDefinition.GROUP_ATTRIBUTE.marshallAsAttribute(principalToGroup, (XMLStreamWriter)writer);
                PrincipalToGroupResourceDefinition.PREFER_ORIGINAL_CONNECTION.marshallAsAttribute(principalToGroup, (XMLStreamWriter)writer);
                PrincipalToGroupResourceDefinition.SKIP_MISSING_GROUPS.marshallAsAttribute(principalToGroup, (XMLStreamWriter)writer);
                PrincipalToGroupResourceDefinition.PARSE_ROLES_FROM_DN.marshallAsAttribute(principalToGroup, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writePlugIn_Authorization(XMLExtendedStreamWriter writer, ModelNode plugIn) throws XMLStreamException {
        writer.writeStartElement(Element.PLUG_IN.getLocalName());
        AbstractPlugInAuthResourceDefinition.NAME.marshallAsAttribute(plugIn, (XMLStreamWriter)writer);
        if (plugIn.hasDefined("property")) {
            writer.writeStartElement("properties");
            ModelNode properties = plugIn.get("property");
            for (String current : properties.keys()) {
                writer.writeEmptyElement("property");
                writer.writeAttribute(Attribute.NAME.getLocalName(), current);
                PropertyResourceDefinition.VALUE.marshallAsAttribute(properties.get(current), (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeOutboundConnections(XMLExtendedStreamWriter writer, ModelNode management) throws XMLStreamException {
        writer.writeStartElement(Element.OUTBOUND_CONNECTIONS.getLocalName());
        ModelNode ldapConns = management.get("ldap-connection");
        for (String variable : ldapConns.keys()) {
            ModelNode properties;
            Set propertySet;
            ModelNode connection = ldapConns.get(variable);
            writer.writeStartElement(Element.LDAP.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), variable);
            LdapConnectionResourceDefinition.URL.marshallAsAttribute(connection, (XMLStreamWriter)writer);
            LdapConnectionResourceDefinition.SEARCH_DN.marshallAsAttribute(connection, (XMLStreamWriter)writer);
            LdapConnectionResourceDefinition.SEARCH_CREDENTIAL.marshallAsAttribute(connection, (XMLStreamWriter)writer);
            LdapConnectionResourceDefinition.SECURITY_REALM.marshallAsAttribute(connection, (XMLStreamWriter)writer);
            LdapConnectionResourceDefinition.INITIAL_CONTEXT_FACTORY.marshallAsAttribute(connection, (XMLStreamWriter)writer);
            LdapConnectionResourceDefinition.REFERRALS.marshallAsAttribute(connection, (XMLStreamWriter)writer);
            LdapConnectionResourceDefinition.HANDLES_REFERRALS_FOR.getMarshaller().marshallAsAttribute((AttributeDefinition)LdapConnectionResourceDefinition.HANDLES_REFERRALS_FOR, connection, true, (XMLStreamWriter)writer);
            LdapConnectionResourceDefinition.ALWAYS_SEND_CLIENT_CERT.marshallAsAttribute(connection, (XMLStreamWriter)writer);
            if (connection.hasDefined(LdapConnectionResourceDefinition.SEARCH_CREDENTIAL_REFERENCE.getName())) {
                LdapConnectionResourceDefinition.SEARCH_CREDENTIAL_REFERENCE.marshallAsElement(connection, (XMLStreamWriter)writer);
            }
            if (connection.hasDefined("property") && (propertySet = (properties = connection.get("property")).keys()).size() > 0) {
                writer.writeStartElement("properties");
                for (String current : propertySet) {
                    writer.writeEmptyElement("property");
                    writer.writeAttribute(Attribute.NAME.getLocalName(), current);
                    LdapConnectionPropertyResourceDefinition.VALUE.marshallAsAttribute(properties.get(current), (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeManagementInterfaces(XMLExtendedStreamWriter writer, ModelNode management) throws XMLStreamException {
        writer.writeStartElement(Element.MANAGEMENT_INTERFACES.getLocalName());
        ModelNode managementInterfaces = management.get("management-interface");
        if (managementInterfaces.hasDefined("native-remoting-interface")) {
            writer.writeEmptyElement(Element.NATIVE_REMOTING_INTERFACE.getLocalName());
        }
        if (managementInterfaces.hasDefined("native-interface") && !this.delegate.writeNativeManagementProtocol(writer, managementInterfaces.get("native-interface"))) {
            throw DomainManagementLogger.ROOT_LOGGER.unsupportedResource("native-interface");
        }
        if (managementInterfaces.hasDefined("http-interface") && !this.delegate.writeHttpManagementProtocol(writer, managementInterfaces.get("http-interface"))) {
            throw DomainManagementLogger.ROOT_LOGGER.unsupportedResource("http-interface");
        }
        writer.writeEndElement();
    }

    private void writeConfigurationChanges(XMLExtendedStreamWriter writer, ModelNode configurationChanges) throws XMLStreamException {
        writer.writeStartElement(Element.CONFIGURATION_CHANGES.getLocalName());
        LegacyConfigurationChangeResourceDefinition.MAX_HISTORY.marshallAsAttribute(configurationChanges, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }
}

