/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.mcp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.RetryableException;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.pool.FlushMode;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionState;
import org.jboss.jca.core.connectionmanager.pool.api.CapacityDecrementer;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PrefillPool;
import org.jboss.jca.core.connectionmanager.pool.capacity.DefaultCapacity;
import org.jboss.jca.core.connectionmanager.pool.capacity.TimedOutDecrementer;
import org.jboss.jca.core.connectionmanager.pool.capacity.TimedOutFIFODecrementer;
import org.jboss.jca.core.connectionmanager.pool.idle.IdleRemover;
import org.jboss.jca.core.connectionmanager.pool.mcp.CapacityFiller;
import org.jboss.jca.core.connectionmanager.pool.mcp.CapacityRequest;
import org.jboss.jca.core.connectionmanager.pool.mcp.FillRequest;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolUtility;
import org.jboss.jca.core.connectionmanager.pool.mcp.PoolFiller;
import org.jboss.jca.core.connectionmanager.pool.validator.ConnectionValidator;
import org.jboss.jca.core.tracer.Tracer;
import org.jboss.logging.Messages;

public class SemaphoreConcurrentLinkedDequeManagedConnectionPool
implements ManagedConnectionPool {
    private CoreLogger log;
    private boolean debug;
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private ManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private Subject defaultSubject;
    private ConnectionRequestInfo defaultCri;
    private PoolConfiguration poolConfiguration;
    private Pool pool;
    private boolean fifo;
    private int maxSize;
    private ConcurrentLinkedDeque<ConnectionListenerWrapper> clq;
    private Map<ConnectionListener, ConnectionListenerWrapper> cls;
    private AtomicInteger poolSize = new AtomicInteger();
    private AtomicInteger checkedOutSize = new AtomicInteger();
    private Boolean supportsLazyAssociation;
    private long lastIdleCheck;
    private long lastUsed;

    @Override
    public void initialize(ManagedConnectionFactory mcf, ConnectionManager cm, Subject subject, ConnectionRequestInfo cri, PoolConfiguration pc, Pool p) {
        if (mcf == null) {
            throw new IllegalArgumentException("ManagedConnectionFactory is null");
        }
        if (cm == null) {
            throw new IllegalArgumentException("ConnectionManager is null");
        }
        if (pc == null) {
            throw new IllegalArgumentException("PoolConfiguration is null");
        }
        if (p == null) {
            throw new IllegalArgumentException("Pool is null");
        }
        this.mcf = mcf;
        this.cm = cm;
        this.defaultSubject = subject;
        this.defaultCri = cri;
        this.poolConfiguration = pc;
        this.maxSize = pc.getMaxSize();
        this.pool = p;
        this.fifo = p.isFIFO();
        this.log = this.pool.getLogger();
        this.debug = this.log.isDebugEnabled();
        this.clq = new ConcurrentLinkedDeque();
        this.cls = new ConcurrentHashMap<ConnectionListener, ConnectionListenerWrapper>();
        this.poolSize.set(0);
        this.checkedOutSize.set(0);
        this.supportsLazyAssociation = null;
        this.lastIdleCheck = System.currentTimeMillis();
        this.lastUsed = Long.MAX_VALUE;
        if ((pc.isPrefill() || pc.isStrictMin()) && p instanceof PrefillPool && pc.getInitialSize() > 0) {
            PoolFiller.fillPool(new FillRequest(this, pc.getInitialSize()));
        }
        if (this.poolConfiguration.getIdleTimeoutMinutes() > 0) {
            IdleRemover.getInstance().registerPool(this, (long)this.poolConfiguration.getIdleTimeoutMinutes() * 1000L * 60L);
        }
        if (this.poolConfiguration.isBackgroundValidation() && this.poolConfiguration.getBackgroundValidationMillis() > 0L) {
            if (this.debug) {
                this.log.debug("Registering for background validation at interval " + this.poolConfiguration.getBackgroundValidationMillis());
            }
            ConnectionValidator.getInstance().registerPool(this, this.poolConfiguration.getBackgroundValidationMillis());
        }
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public boolean isRunning() {
        return !this.pool.isShutdown();
    }

    @Override
    public boolean isEmpty() {
        return this.poolSize.get() == 0;
    }

    @Override
    public boolean isIdle() {
        return this.checkedOutSize.get() == 0;
    }

    @Override
    public int getActive() {
        return this.poolSize.get();
    }

    private boolean isSize(int size) {
        return this.poolSize.get() >= size;
    }

    @Override
    public void prefill() {
        if (this.isRunning() && (this.poolConfiguration.isPrefill() || this.poolConfiguration.isStrictMin()) && this.pool instanceof PrefillPool && this.poolConfiguration.getMinSize() > 0) {
            PoolFiller.fillPool(new FillRequest(this, this.poolConfiguration.getMinSize()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionListener getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (this.log.isTraceEnabled()) {
            Map<ConnectionListener, ConnectionListenerWrapper> map = this.cls;
            synchronized (map) {
                String method = "getConnection(" + subject + ", " + cri + ")";
                TreeSet<ConnectionListener> checkedOut = new TreeSet<ConnectionListener>();
                TreeSet<ConnectionListener> available = new TreeSet<ConnectionListener>();
                for (Map.Entry<ConnectionListener, ConnectionListenerWrapper> entry : this.cls.entrySet()) {
                    if (entry.getValue().isCheckedOut()) {
                        checkedOut.add(entry.getKey());
                        continue;
                    }
                    available.add(entry.getKey());
                }
                this.log.trace(ManagedConnectionPoolUtility.fullDetails(this, method, this.mcf, this.cm, this.pool, this.poolConfiguration, available, checkedOut, this.pool.getInternalStatistics(), subject, cri));
            }
        } else if (this.debug) {
            String method = "getConnection(" + subject + ", " + cri + ")";
            this.log.debug(ManagedConnectionPoolUtility.details(method, this.pool.getName(), this.pool.getInternalStatistics().getInUseCount(), this.maxSize));
        }
        subject = subject == null ? this.defaultSubject : subject;
        ConnectionRequestInfo connectionRequestInfo = cri = cri == null ? this.defaultCri : cri;
        if (this.pool.isFull()) {
            if (this.pool.getInternalStatistics().isEnabled()) {
                this.pool.getInternalStatistics().deltaWaitCount();
            }
            if (this.pool.isSharable() && (this.supportsLazyAssociation == null || this.supportsLazyAssociation.booleanValue())) {
                if (this.supportsLazyAssociation == null) {
                    this.checkLazyAssociation();
                }
                if (this.supportsLazyAssociation != null && this.supportsLazyAssociation.booleanValue()) {
                    if (this.log.isTraceEnabled()) {
                        this.log.tracef("Trying to detach - Pool: %s MCP: %s", this.pool.getName(), Integer.toHexString(System.identityHashCode(this)));
                    }
                    if (!this.detachConnectionListener() && this.log.isTraceEnabled()) {
                        this.log.tracef("Detaching didn't succeed - Pool: %s MCP: %s", this.pool.getName(), Integer.toHexString(System.identityHashCode(this)));
                    }
                }
            }
        }
        long startWait = this.pool.getInternalStatistics().isEnabled() ? System.currentTimeMillis() : 0L;
        try {
            if (this.pool.getLock().tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS)) {
                if (this.pool.getInternalStatistics().isEnabled()) {
                    this.pool.getInternalStatistics().deltaTotalBlockingTime(System.currentTimeMillis() - startWait);
                }
                ConnectionListenerWrapper clw = null;
                do {
                    if (!this.isRunning()) {
                        this.pool.getLock().release();
                        throw new ResourceException(bundle.thePoolHasBeenShutdown(this.pool.getName(), Integer.toHexString(System.identityHashCode(this))));
                    }
                    clw = this.fifo ? this.clq.pollFirst() : this.clq.pollLast();
                    if (clw == null) continue;
                    clw.setCheckedOut(true);
                    this.checkedOutSize.incrementAndGet();
                    try {
                        ManagedConnection matchedMC = this.mcf.matchManagedConnections(Collections.singleton(clw.getConnectionListener().getManagedConnection()), subject, cri);
                        boolean valid = true;
                        if (matchedMC != null) {
                            block49: {
                                if (this.poolConfiguration.isValidateOnMatch()) {
                                    if (this.mcf instanceof ValidatingManagedConnectionFactory) {
                                        try {
                                            ValidatingManagedConnectionFactory vcf = (ValidatingManagedConnectionFactory)this.mcf;
                                            Set candidateSet = Collections.singleton(clw.getConnectionListener().getManagedConnection());
                                            candidateSet = vcf.getInvalidConnections(candidateSet);
                                            if (candidateSet != null && candidateSet.size() > 0) {
                                                valid = false;
                                            }
                                            break block49;
                                        }
                                        catch (Throwable t) {
                                            valid = false;
                                            if (this.log.isTraceEnabled()) {
                                                this.log.trace("Exception while ValidateOnMatch: " + t.getMessage(), t);
                                            }
                                            break block49;
                                        }
                                    }
                                    this.log.validateOnMatchNonCompliantManagedConnectionFactory(this.mcf.getClass().getName());
                                }
                            }
                            if (valid) {
                                this.log.tracef("supplying ManagedConnection from pool: %s", clw.getConnectionListener());
                                this.lastUsed = System.currentTimeMillis();
                                clw.getConnectionListener().setLastCheckedOutTime(this.lastUsed);
                                if (this.pool.getInternalStatistics().isEnabled()) {
                                    this.pool.getInternalStatistics().deltaTotalGetTime(this.lastUsed - startWait);
                                    this.pool.getInternalStatistics().deltaTotalPoolTime(this.lastUsed - clw.getConnectionListener().getLastReturnedTime());
                                }
                                if (Tracer.isEnabled()) {
                                    Tracer.getConnectionListener(this.pool.getName(), this, clw.getConnectionListener(), true, this.pool.isInterleaving(), Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                                }
                                clw.setHasPermit(true);
                                return clw.getConnectionListener();
                            }
                        }
                        if (valid) {
                            this.log.destroyingConnectionNotSuccessfullyMatched(clw.getConnectionListener());
                        } else {
                            this.log.destroyingConnectionNotValidated(clw.getConnectionListener());
                        }
                        if (this.pool.getInternalStatistics().isEnabled()) {
                            this.pool.getInternalStatistics().deltaTotalPoolTime(System.currentTimeMillis() - clw.getConnectionListener().getLastReturnedTime());
                        }
                        if (Tracer.isEnabled()) {
                            Tracer.destroyConnectionListener(this.pool.getName(), this, clw.getConnectionListener(), false, false, true, false, false, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                        }
                        this.removeConnectionListenerFromPool(clw);
                        clw.getConnectionListener().destroy();
                        clw = null;
                    }
                    catch (Throwable t) {
                        this.log.throwableWhileTryingMatchManagedConnectionThenDestroyingConnection(clw.getConnectionListener(), t);
                        if (this.pool.getInternalStatistics().isEnabled()) {
                            this.pool.getInternalStatistics().deltaTotalPoolTime(System.currentTimeMillis() - clw.getConnectionListener().getLastReturnedTime());
                        }
                        if (Tracer.isEnabled()) {
                            Tracer.destroyConnectionListener(this.pool.getName(), this, clw.getConnectionListener(), false, false, false, false, true, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                        }
                        this.removeConnectionListenerFromPool(clw);
                        clw.getConnectionListener().destroy();
                        clw = null;
                    }
                    if (!this.poolConfiguration.isUseFastFail()) continue;
                    if (!this.log.isTraceEnabled()) break;
                    this.log.trace("Fast failing for connection attempt. No more attempts will be made to acquire connection from pool and a new connection will be created immeadiately");
                    break;
                } while (this.clq.size() > 0);
                try {
                    clw = new ConnectionListenerWrapper(this.createConnectionEventListener(subject, cri), true, true);
                    if (Tracer.isEnabled()) {
                        Tracer.createConnectionListener(this.pool.getName(), this, clw.getConnectionListener(), clw.getConnectionListener().getManagedConnection(), true, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                    }
                    clw.setCheckedOut(true);
                    this.checkedOutSize.incrementAndGet();
                    this.cls.put(clw.getConnectionListener(), clw);
                    this.log.tracef("supplying new ManagedConnection: %s", clw.getConnectionListener());
                    this.lastUsed = System.currentTimeMillis();
                    if (this.pool.getInternalStatistics().isEnabled()) {
                        this.pool.getInternalStatistics().deltaTotalGetTime(this.lastUsed - startWait);
                    }
                    this.prefill();
                    if (this.pool.getCapacity().getIncrementer() != null) {
                        CapacityFiller.schedule(new CapacityRequest(this, subject, cri));
                    }
                    if (Tracer.isEnabled()) {
                        Tracer.getConnectionListener(this.pool.getName(), this, clw.getConnectionListener(), false, this.pool.isInterleaving(), Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                    }
                    return clw.getConnectionListener();
                }
                catch (Throwable t) {
                    if (clw != null || !(t instanceof RetryableException)) {
                        this.log.throwableWhileAttemptingGetNewGonnection(clw != null ? clw.getConnectionListener() : null, t);
                    }
                    if (clw != null) {
                        if (Tracer.isEnabled()) {
                            Tracer.destroyConnectionListener(this.pool.getName(), this, clw.getConnectionListener(), false, false, false, false, true, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                        }
                        this.removeConnectionListenerFromPool(clw);
                        clw.getConnectionListener().destroy();
                    }
                    this.pool.getLock().release();
                    if (t instanceof ResourceException) {
                        throw (ResourceException)t;
                    }
                    throw new ResourceException(bundle.unexpectedThrowableWhileTryingCreateConnection(clw != null ? clw.getConnectionListener() : null), t);
                }
            }
            throw new ResourceException(bundle.noMManagedConnectionsAvailableWithinConfiguredBlockingTimeout(this.poolConfiguration.getBlockingTimeout()));
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            long end = this.pool.getInternalStatistics().isEnabled() ? System.currentTimeMillis() - startWait : 0L;
            this.pool.getInternalStatistics().deltaTotalBlockingTime(end);
            throw new ResourceException(bundle.interruptedWhileRequestingPermit(end));
        }
    }

    @Override
    public ConnectionListener findConnectionListener(ManagedConnection mc) {
        return this.findConnectionListener(mc, null);
    }

    @Override
    public ConnectionListener findConnectionListener(ManagedConnection mc, Object connection) {
        for (Map.Entry<ConnectionListener, ConnectionListenerWrapper> entry : this.cls.entrySet()) {
            if (!entry.getValue().isCheckedOut() || !entry.getKey().controls(mc, connection)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void returnConnection(ConnectionListener cl, boolean kill) {
        this.returnConnection(cl, kill, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnection(ConnectionListener cl, boolean kill, boolean cleanup) {
        if (this.pool.getInternalStatistics().isEnabled() && cl.getState() != ConnectionState.DESTROYED) {
            this.pool.getInternalStatistics().deltaTotalUsageTime(System.currentTimeMillis() - cl.getLastCheckedOutTime());
        }
        if (this.log.isTraceEnabled()) {
            Map<ConnectionListener, ConnectionListenerWrapper> map = this.cls;
            synchronized (map) {
                String method = "returnConnection(" + Integer.toHexString(System.identityHashCode(cl)) + ", " + kill + ")";
                TreeSet<ConnectionListener> checkedOut = new TreeSet<ConnectionListener>();
                TreeSet<ConnectionListener> available = new TreeSet<ConnectionListener>();
                for (Map.Entry<ConnectionListener, ConnectionListenerWrapper> entry : this.cls.entrySet()) {
                    if (entry.getValue().isCheckedOut()) {
                        checkedOut.add(entry.getKey());
                        continue;
                    }
                    available.add(entry.getKey());
                }
                this.log.trace(ManagedConnectionPoolUtility.fullDetails(this, method, this.mcf, this.cm, this.pool, this.poolConfiguration, available, checkedOut, this.pool.getInternalStatistics(), this.defaultSubject, this.defaultCri));
            }
        } else if (this.debug) {
            String method = "returnConnection(" + Integer.toHexString(System.identityHashCode(cl)) + ", " + kill + ")";
            this.log.debug(ManagedConnectionPoolUtility.details(method, this.pool.getName(), this.pool.getInternalStatistics().getInUseCount(), this.maxSize));
        }
        ConnectionListenerWrapper clw = this.cls.get(cl);
        if (cl.getState() == ConnectionState.DESTROYED) {
            this.log.tracef("ManagedConnection is being returned after it was destroyed: %s", cl);
            if (clw != null && clw.hasPermit()) {
                clw.setHasPermit(false);
                this.pool.getLock().release();
            }
            return;
        }
        if (cleanup) {
            try {
                cl.getManagedConnection().cleanup();
            }
            catch (ResourceException re) {
                this.log.resourceExceptionCleaningUpManagedConnection(cl, re);
                kill = true;
            }
        }
        if (clw == null || cl.getState() == ConnectionState.DESTROY || cl.getState() == ConnectionState.DESTROYED) {
            kill = true;
        }
        if (!kill && this.isSize(this.poolConfiguration.getMaxSize() + 1)) {
            this.log.destroyingReturnedConnectionMaximumPoolSizeExceeded(cl);
            kill = true;
        }
        boolean releasePermit = false;
        if (clw != null) {
            if (clw.hasPermit()) {
                clw.setHasPermit(false);
                releasePermit = true;
            }
            if (clw.isCheckedOut()) {
                clw.setCheckedOut(false);
                this.checkedOutSize.decrementAndGet();
            }
        }
        if (kill) {
            this.cls.remove(cl);
        } else {
            cl.toPool();
            if (!this.clq.contains(clw)) {
                this.clq.addLast(clw);
            } else {
                this.log.attemptReturnConnectionTwice(cl, new Throwable("STACKTRACE"));
            }
        }
        if (kill) {
            this.log.tracef("Destroying returned connection %s", cl);
            if (Tracer.isEnabled()) {
                Tracer.destroyConnectionListener(this.pool.getName(), this, clw.getConnectionListener(), true, false, false, false, false, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
            }
            this.removeConnectionListenerFromPool(clw);
            clw.getConnectionListener().destroy();
            clw = null;
        }
        if (releasePermit) {
            this.pool.getLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(FlushMode mode, Collection<ConnectionListener> toDestroy) {
        ArrayList<ConnectionListenerWrapper> destroy = null;
        Map<ConnectionListener, ConnectionListenerWrapper> map = this.cls;
        synchronized (map) {
            if (FlushMode.ALL == mode) {
                if (this.log.isTraceEnabled()) {
                    TreeSet<ConnectionListener> treeSet = new TreeSet<ConnectionListener>();
                    for (Map.Entry<ConnectionListener, ConnectionListenerWrapper> entry : this.cls.entrySet()) {
                        if (!entry.getValue().isCheckedOut()) continue;
                        treeSet.add(entry.getKey());
                    }
                    this.log.tracef("Flushing pool checkedOut=%s inPool=%s", treeSet, this.cls);
                }
                for (Map.Entry<ConnectionListener, ConnectionListenerWrapper> entry : this.cls.entrySet()) {
                    if (!entry.getValue().isCheckedOut()) continue;
                    this.log.tracef("Flush marking checked out connection for destruction %s", entry.getKey());
                    entry.getValue().setCheckedOut(false);
                    this.checkedOutSize.decrementAndGet();
                    if (this.pool.getInternalStatistics().isEnabled()) {
                        this.pool.getInternalStatistics().deltaTotalUsageTime(System.currentTimeMillis() - entry.getKey().getLastCheckedOutTime());
                    }
                    if (entry.getValue().hasPermit()) {
                        entry.getValue().setHasPermit(false);
                        this.pool.getLock().release();
                    }
                    entry.getKey().setState(ConnectionState.DESTROY);
                    if (destroy == null) {
                        destroy = new ArrayList(1);
                    }
                    destroy.add(entry.getValue());
                    this.clq.remove(entry.getValue());
                    this.cls.remove(entry.getKey());
                }
            } else if (FlushMode.GRACEFULLY == mode) {
                if (this.log.isTraceEnabled()) {
                    TreeSet<ConnectionListener> treeSet = new TreeSet<ConnectionListener>();
                    for (Map.Entry<ConnectionListener, ConnectionListenerWrapper> entry : this.cls.entrySet()) {
                        if (!entry.getValue().isCheckedOut()) continue;
                        treeSet.add(entry.getKey());
                    }
                    this.log.tracef("Gracefully flushing pool checkedOut=%s inPool=%s", treeSet, this.cls);
                }
                for (Map.Entry<ConnectionListener, ConnectionListenerWrapper> entry : this.cls.entrySet()) {
                    if (!entry.getValue().isCheckedOut()) continue;
                    this.log.tracef("Graceful flush marking checked out connection for destruction %s", entry.getKey());
                    entry.getKey().setState(ConnectionState.DESTROY);
                }
            }
            for (ConnectionListenerWrapper connectionListenerWrapper : this.clq) {
                boolean bl = true;
                if (FlushMode.INVALID == mode && connectionListenerWrapper.getConnectionListener().getState().equals((Object)ConnectionState.NORMAL) && this.mcf instanceof ValidatingManagedConnectionFactory) {
                    try {
                        ValidatingManagedConnectionFactory vcf = (ValidatingManagedConnectionFactory)this.mcf;
                        Set candidateSet = Collections.singleton(connectionListenerWrapper.getConnectionListener().getManagedConnection());
                        candidateSet = vcf.getInvalidConnections(candidateSet);
                        if (candidateSet == null || candidateSet.size() == 0) {
                            bl = false;
                        }
                    }
                    catch (Throwable t) {
                        this.log.trace("Exception during invalid flush", t);
                    }
                }
                if (!bl) continue;
                if (this.pool.getInternalStatistics().isEnabled()) {
                    this.pool.getInternalStatistics().deltaTotalPoolTime(System.currentTimeMillis() - connectionListenerWrapper.getConnectionListener().getLastReturnedTime());
                }
                this.clq.remove(connectionListenerWrapper);
                this.cls.remove(connectionListenerWrapper.getConnectionListener());
                if (destroy == null) {
                    destroy = new ArrayList<ConnectionListenerWrapper>(1);
                }
                connectionListenerWrapper.getConnectionListener().setState(ConnectionState.DESTROY);
                destroy.add(connectionListenerWrapper);
            }
        }
        if (destroy != null) {
            for (ConnectionListenerWrapper connectionListenerWrapper : destroy) {
                this.removeConnectionListenerFromPool(connectionListenerWrapper);
                toDestroy.add(connectionListenerWrapper.getConnectionListener());
                Object var5_13 = null;
            }
        }
        this.prefill();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIdleConnections() {
        long now = System.currentTimeMillis();
        long timeoutSetting = (long)this.poolConfiguration.getIdleTimeoutMinutes() * 1000L * 60L;
        CapacityDecrementer decrementer = this.pool.getCapacity().getDecrementer();
        if (decrementer == null) {
            decrementer = DefaultCapacity.DEFAULT_DECREMENTER;
        }
        if (TimedOutDecrementer.class.getName().equals(decrementer.getClass().getName()) || TimedOutFIFODecrementer.class.getName().equals(decrementer.getClass().getName()) ? now < this.lastIdleCheck + 60000L : now < this.lastIdleCheck + timeoutSetting) {
            return;
        }
        this.lastIdleCheck = now;
        ArrayList<Object> destroyConnections = new ArrayList<Object>();
        long timeout = now - timeoutSetting;
        boolean destroy = true;
        int destroyed = 0;
        if (this.log.isTraceEnabled()) {
            Map<ConnectionListener, ConnectionListenerWrapper> map = this.cls;
            synchronized (map) {
                String method = "removeIdleConnections(" + timeout + ")";
                TreeSet<ConnectionListener> treeSet = new TreeSet<ConnectionListener>();
                TreeSet<ConnectionListener> available = new TreeSet<ConnectionListener>();
                for (Map.Entry<ConnectionListener, ConnectionListenerWrapper> entry : this.cls.entrySet()) {
                    if (entry.getValue().isCheckedOut()) {
                        treeSet.add(entry.getKey());
                        continue;
                    }
                    available.add(entry.getKey());
                }
                this.log.trace(ManagedConnectionPoolUtility.fullDetails(this, method, this.mcf, this.cm, this.pool, this.poolConfiguration, available, treeSet, this.pool.getInternalStatistics(), this.defaultSubject, this.defaultCri));
            }
        } else if (this.debug) {
            String method = "removeIdleConnections(" + timeout + ")";
            this.log.debug(ManagedConnectionPoolUtility.details(method, this.pool.getName(), this.pool.getInternalStatistics().getInUseCount(), this.maxSize));
        }
        Iterator<ConnectionListenerWrapper> clwIter = this.clq.iterator();
        while (clwIter.hasNext() && destroy && this.clq.size() != 0) {
            ConnectionListenerWrapper clw = clwIter.next();
            destroy = decrementer.shouldDestroy(clw.getConnectionListener(), timeout, this.poolSize.get() - destroyed, this.poolConfiguration.getMinSize(), destroyed);
            if (!destroy) continue;
            if (this.shouldRemove() || !this.isRunning()) {
                if (this.pool.getInternalStatistics().isEnabled()) {
                    this.pool.getInternalStatistics().deltaTimedOut();
                }
                this.log.tracef("Idle connection cl=%s", clw.getConnectionListener());
                if (this.cls.remove(clw.getConnectionListener()) == null) {
                    this.log.tracef("Connection Pool did not contain: %s", clw.getConnectionListener());
                }
                if (!this.clq.remove(clw)) {
                    this.log.tracef("Available connection queue did not contain: %s", clw.getConnectionListener());
                }
                destroyConnections.add(clw);
                ++destroyed;
                continue;
            }
            destroy = false;
        }
        if (destroyConnections.size() > 0 || this.isEmpty()) {
            for (ConnectionListenerWrapper connectionListenerWrapper : destroyConnections) {
                this.log.tracef("Destroying connection %s", connectionListenerWrapper.getConnectionListener());
                if (this.pool.getInternalStatistics().isEnabled()) {
                    this.pool.getInternalStatistics().deltaTotalPoolTime(System.currentTimeMillis() - connectionListenerWrapper.getConnectionListener().getLastReturnedTime());
                }
                if (Tracer.isEnabled()) {
                    Tracer.destroyConnectionListener(this.pool.getName(), this, connectionListenerWrapper.getConnectionListener(), false, true, false, false, false, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                }
                this.removeConnectionListenerFromPool(connectionListenerWrapper);
                connectionListenerWrapper.getConnectionListener().destroy();
                Object var13_14 = null;
            }
            if (this.isRunning()) {
                boolean emptyManagedConnectionPool = false;
                if ((this.poolConfiguration.isPrefill() || this.poolConfiguration.isStrictMin()) && this.pool instanceof PrefillPool) {
                    if (this.poolConfiguration.getMinSize() > 0) {
                        this.prefill();
                    } else {
                        emptyManagedConnectionPool = true;
                    }
                } else {
                    emptyManagedConnectionPool = true;
                }
                if (emptyManagedConnectionPool && this.isEmpty()) {
                    this.pool.emptyManagedConnectionPool(this);
                }
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.log.isTraceEnabled()) {
            this.log.tracef("Shutdown - Pool: %s MCP: %s", this.pool.getName(), Integer.toHexString(System.identityHashCode(this)));
        }
        IdleRemover.getInstance().unregisterPool(this);
        ConnectionValidator.getInstance().unregisterPool(this);
        if (this.checkedOutSize.get() > 0) {
            for (Map.Entry<ConnectionListener, ConnectionListenerWrapper> entry : this.cls.entrySet()) {
                if (entry.getValue().isCheckedOut()) {
                    this.log.destroyingActiveConnection(this.pool.getName(), entry.getKey().getManagedConnection());
                }
                if (!Tracer.isEnabled()) continue;
                Tracer.clearConnectionListener(this.pool.getName(), this, entry.getKey());
            }
        }
        ArrayList<ConnectionListener> toDestroy = new ArrayList<ConnectionListener>();
        this.flush(FlushMode.ALL, toDestroy);
        for (ConnectionListener cl : toDestroy) {
            cl.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillTo(int size) {
        if (size <= 0) {
            return;
        }
        if (!this.poolConfiguration.isPrefill() && !this.poolConfiguration.isStrictMin()) {
            return;
        }
        if (!(this.pool instanceof PrefillPool)) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            Map<ConnectionListener, ConnectionListenerWrapper> map = this.cls;
            synchronized (map) {
                String method = "fillTo(" + size + ")";
                TreeSet<ConnectionListener> checkedOut = new TreeSet<ConnectionListener>();
                TreeSet<ConnectionListener> available = new TreeSet<ConnectionListener>();
                for (Map.Entry<ConnectionListener, ConnectionListenerWrapper> entry : this.cls.entrySet()) {
                    if (entry.getValue().isCheckedOut()) {
                        checkedOut.add(entry.getKey());
                        continue;
                    }
                    available.add(entry.getKey());
                }
                this.log.trace(ManagedConnectionPoolUtility.fullDetails(this, method, this.mcf, this.cm, this.pool, this.poolConfiguration, available, checkedOut, this.pool.getInternalStatistics(), this.defaultSubject, this.defaultCri));
            }
        } else if (this.debug) {
            String method = "fillTo(" + size + ")";
            this.log.debug(ManagedConnectionPoolUtility.details(method, this.pool.getName(), this.pool.getInternalStatistics().getInUseCount(), this.maxSize));
        }
        while (!this.pool.isFull()) {
            try {
                long startWait;
                long l = startWait = this.pool.getInternalStatistics().isEnabled() ? System.currentTimeMillis() : 0L;
                if (!this.pool.getLock().tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS)) continue;
                if (this.pool.getInternalStatistics().isEnabled()) {
                    this.pool.getInternalStatistics().deltaTotalBlockingTime(System.currentTimeMillis() - startWait);
                }
                try {
                    if (!this.isRunning()) {
                        return;
                    }
                    if (this.isSize(size)) {
                        return;
                    }
                    ConnectionListener cl = this.createConnectionEventListener(this.defaultSubject, this.defaultCri);
                    if (Tracer.isEnabled()) {
                        Tracer.createConnectionListener(this.pool.getName(), this, cl, cl.getManagedConnection(), false, true, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                    }
                    boolean added = false;
                    if (!this.isSize(size + 1)) {
                        this.log.tracef("Filling pool cl=%s", cl);
                        this.cls.put(cl, new ConnectionListenerWrapper(cl, false, false));
                        this.clq.addLast(this.cls.get(cl));
                        added = true;
                    }
                    if (added) continue;
                    if (Tracer.isEnabled()) {
                        Tracer.destroyConnectionListener(this.pool.getName(), this, cl, false, false, false, false, false, true, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                    }
                    ConnectionListenerWrapper clw = new ConnectionListenerWrapper(cl, false, false);
                    this.removeConnectionListenerFromPool(clw);
                    clw.getConnectionListener().destroy();
                    return;
                }
                finally {
                    this.pool.getLock().release();
                }
            }
            catch (InterruptedException ignored) {
                Thread.interrupted();
                this.log.trace("Interrupted while requesting permit in fillTo");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increaseCapacity(Subject subject, ConnectionRequestInfo cri) {
        int created = 1;
        boolean create = true;
        while (create && !this.pool.isFull()) {
            try {
                long startWait;
                long l = startWait = this.pool.getInternalStatistics().isEnabled() ? System.currentTimeMillis() : 0L;
                if (!this.pool.getLock().tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS)) continue;
                if (this.pool.getInternalStatistics().isEnabled()) {
                    this.pool.getInternalStatistics().deltaTotalBlockingTime(System.currentTimeMillis() - startWait);
                }
                try {
                    if (!this.isRunning()) {
                        return;
                    }
                    create = this.pool.getCapacity().getIncrementer().shouldCreate(this.poolSize.get(), this.poolConfiguration.getMaxSize(), created);
                    if (!create) continue;
                    try {
                        ConnectionListener cl = this.createConnectionEventListener(subject, cri);
                        if (Tracer.isEnabled()) {
                            Tracer.createConnectionListener(this.pool.getName(), this, cl, cl.getManagedConnection(), false, false, true, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                        }
                        boolean added = false;
                        if (!this.isSize(this.poolConfiguration.getMaxSize() + 1)) {
                            this.log.tracef("Capacity fill: cl=%s", cl);
                            this.cls.put(cl, new ConnectionListenerWrapper(cl, false, false));
                            this.clq.addLast(this.cls.get(cl));
                            ++created;
                            added = true;
                        }
                        if (added) continue;
                        if (Tracer.isEnabled()) {
                            Tracer.destroyConnectionListener(this.pool.getName(), this, cl, false, false, true, false, false, false, true, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                        }
                        ConnectionListenerWrapper clw = new ConnectionListenerWrapper(cl, false, false);
                        this.removeConnectionListenerFromPool(clw);
                        clw.getConnectionListener().destroy();
                        return;
                    }
                    catch (ResourceException re) {
                        this.log.unableFillPool(re, this.cm.getJndiName());
                        return;
                    }
                }
                finally {
                    this.pool.getLock().release();
                }
            }
            catch (InterruptedException ignored) {
                Thread.interrupted();
                this.log.trace("Interrupted while requesting permit in increaseCapacity");
            }
        }
    }

    @Override
    public void addConnectionListener(ConnectionListener cl) {
        this.cls.put(cl, new ConnectionListenerWrapper(cl, false, false));
        this.clq.addLast(this.cls.get(cl));
        this.poolSize.incrementAndGet();
        if (this.pool.getInternalStatistics().isEnabled()) {
            this.pool.getInternalStatistics().deltaCreatedCount();
        }
    }

    @Override
    public ConnectionListener removeConnectionListener() {
        if (this.cls.size() > 0) {
            ConnectionListenerWrapper clw;
            if (this.pool.getInternalStatistics().isEnabled()) {
                this.pool.getInternalStatistics().deltaDestroyedCount();
            }
            if (this.cls.remove((clw = this.clq.removeFirst()).getConnectionListener()) != null) {
                this.poolSize.decrementAndGet();
            }
            return clw.getConnectionListener();
        }
        return null;
    }

    private ConnectionListener createConnectionEventListener(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        long start = this.pool.getInternalStatistics().isEnabled() ? System.currentTimeMillis() : 0L;
        ManagedConnection mc = this.mcf.createManagedConnection(subject, cri);
        if (this.pool.getInternalStatistics().isEnabled()) {
            this.pool.getInternalStatistics().deltaTotalCreationTime(System.currentTimeMillis() - start);
            this.pool.getInternalStatistics().deltaCreatedCount();
        }
        try {
            ConnectionListener cl = this.cm.createConnectionListener(mc, this);
            this.poolSize.incrementAndGet();
            return cl;
        }
        catch (ResourceException re) {
            if (this.pool.getInternalStatistics().isEnabled()) {
                this.pool.getInternalStatistics().deltaDestroyedCount();
            }
            mc.destroy();
            throw re;
        }
    }

    @Override
    public void connectionListenerDestroyed(ConnectionListener cl) {
        if (this.pool.getInternalStatistics().isEnabled()) {
            this.pool.getInternalStatistics().deltaDestroyedCount();
        }
    }

    private void removeConnectionListenerFromPool(ConnectionListenerWrapper clw) {
        if (clw != null) {
            this.clq.remove(clw);
            this.cls.remove(clw.getConnectionListener());
            if (clw.isCheckedOut()) {
                clw.setCheckedOut(false);
                this.checkedOutSize.decrementAndGet();
            }
            this.poolSize.decrementAndGet();
        }
    }

    private boolean shouldRemove() {
        boolean remove = true;
        if (this.poolConfiguration.isStrictMin() && this.pool instanceof PrefillPool) {
            remove = this.isSize(this.poolConfiguration.getMinSize() + 1);
            this.log.tracef("StrictMin is active. Current connection will be removed is %b", remove);
        }
        return remove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void validateConnections() throws Exception {
        block33: {
            this.log.tracef("Attempting to validate connections for pool %s", this);
            if (!this.pool.getLock().tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS)) break block33;
            anyDestroyed = false;
            block20: while (true) {
                while (true) lbl-1000:
                // 3 sources

                {
                    cl = null;
                    destroyed = false;
                    var4_4 = this.cls;
                    synchronized (var4_4) {
                        if (this.clq.size() == 0) {
                            break block33;
                        }
                        cl = this.removeForFrequencyCheck();
                    }
                    if (cl == null) {
                        break block33;
                    }
                    try {
                        candidateSet = Collections.singleton(cl.getManagedConnection());
                        if (this.mcf instanceof ValidatingManagedConnectionFactory) {
                            vcf = (ValidatingManagedConnectionFactory)this.mcf;
                            if (((candidateSet = vcf.getInvalidConnections(candidateSet)) != null && candidateSet.size() > 0 || !this.isRunning()) && cl.getState() != ConnectionState.DESTROY) {
                                clw = this.cls.remove(cl);
                                if (this.pool.getInternalStatistics().isEnabled()) {
                                    this.pool.getInternalStatistics().deltaTotalPoolTime(System.currentTimeMillis() - clw.getConnectionListener().getLastReturnedTime());
                                }
                                if (Tracer.isEnabled()) {
                                    Tracer.destroyConnectionListener(this.pool.getName(), this, clw.getConnectionListener(), false, false, true, false, false, false, false, Tracer.isRecordCallstacks() != false ? new Throwable("CALLSTACK") : null);
                                }
                                this.removeConnectionListenerFromPool(clw);
                                clw.getConnectionListener().destroy();
                                clw = null;
                                destroyed = true;
                                anyDestroyed = true;
                            }
                        } else {
                            this.log.backgroundValidationNonCompliantManagedConnectionFactory();
                        }
                        if (destroyed) ** GOTO lbl-1000
                        candidateSet = this.cls;
                    }
                    catch (ResourceException re) {
                        if (cl != null) {
                            clw = this.cls.remove(cl);
                            if (this.pool.getInternalStatistics().isEnabled()) {
                                this.pool.getInternalStatistics().deltaTotalPoolTime(System.currentTimeMillis() - clw.getConnectionListener().getLastReturnedTime());
                            }
                            if (Tracer.isEnabled()) {
                                Tracer.destroyConnectionListener(this.pool.getName(), this, clw.getConnectionListener(), false, false, false, false, true, false, false, Tracer.isRecordCallstacks() != false ? new Throwable("CALLSTACK") : null);
                            }
                            this.removeConnectionListenerFromPool(clw);
                            clw.getConnectionListener().destroy();
                            clw = null;
                            destroyed = true;
                            anyDestroyed = true;
                        }
                        this.log.connectionValidatorIgnoredUnexpectedError(re);
                        continue block20;
                    }
                    finally {
                        if (destroyed) continue;
                        var4_4 = this.cls;
                        synchronized (var4_4) {
                            this.returnForFrequencyCheck(cl);
                        }
                        continue block20;
                    }
                    synchronized (candidateSet) {
                        this.returnForFrequencyCheck(cl);
                        continue block20;
                    }
                    break;
                }
                break;
            }
            finally {
                this.pool.getLock().release();
                if (anyDestroyed) {
                    this.prefill();
                }
            }
        }
    }

    String getPoolName() {
        if (this.pool == null) {
            return "";
        }
        return this.pool.getName();
    }

    private ConnectionListener removeForFrequencyCheck() {
        this.log.debug("Checking for connection within frequency");
        ConnectionListenerWrapper clw2 = null;
        for (ConnectionListenerWrapper clw2 : this.clq) {
            long lastCheck = clw2.getConnectionListener().getLastValidatedTime();
            if (System.currentTimeMillis() - lastCheck >= this.poolConfiguration.getBackgroundValidationMillis()) {
                this.clq.remove(clw2);
                break;
            }
            clw2 = null;
        }
        if (clw2 != null) {
            return clw2.getConnectionListener();
        }
        return null;
    }

    private void returnForFrequencyCheck(ConnectionListener cl) {
        this.log.debug("Returning for connection within frequency");
        cl.setLastValidatedTime(System.currentTimeMillis());
        this.clq.addLast(this.cls.get(cl));
    }

    private void checkLazyAssociation() {
        ConnectionListener cl = null;
        if (this.cls.size() > 0) {
            cl = this.cls.keySet().iterator().next();
        }
        if (cl != null) {
            if (cl.supportsLazyAssociation()) {
                if (this.debug) {
                    this.log.debug("Enable lazy association support for: " + this.pool.getName());
                }
                this.supportsLazyAssociation = Boolean.TRUE;
            } else {
                if (this.debug) {
                    this.log.debug("Disable lazy association support for: " + this.pool.getName());
                }
                this.supportsLazyAssociation = Boolean.FALSE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean detachConnectionListener() {
        Map<ConnectionListener, ConnectionListenerWrapper> map = this.cls;
        synchronized (map) {
            block9: {
                ConnectionListener cl = null;
                try {
                    for (Map.Entry<ConnectionListener, ConnectionListenerWrapper> entry : this.cls.entrySet()) {
                        cl = entry.getKey();
                        if (!entry.getValue().isCheckedOut() || cl.isEnlisted() || !(cl.getManagedConnection() instanceof DissociatableManagedConnection)) continue;
                        this.log.tracef("Detach: %s", cl);
                        DissociatableManagedConnection dmc = (DissociatableManagedConnection)cl.getManagedConnection();
                        dmc.dissociateConnections();
                        cl.unregisterConnections();
                        if (Tracer.isEnabled()) {
                            Tracer.returnConnectionListener(this.pool.getName(), this, cl, false, this.pool.isInterleaving(), Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                        }
                        this.returnConnection(cl, false, false);
                        return true;
                    }
                }
                catch (Throwable t) {
                    if (this.debug) {
                        this.log.debug("Exception during detach for: " + this.pool.getName(), t);
                    }
                    this.supportsLazyAssociation = Boolean.FALSE;
                    if (cl == null) break block9;
                    if (Tracer.isEnabled()) {
                        Tracer.returnConnectionListener(this.pool.getName(), this, cl, true, this.pool.isInterleaving(), Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                    }
                    this.returnConnection(cl, true, true);
                }
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SemaphoreConcurrentLinkedQueueManagedConnectionPool@");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[pool=").append(this.pool.getName());
        sb.append("]");
        return sb.toString();
    }

    static class ConnectionListenerWrapper {
        private volatile ConnectionListener cl;
        private volatile boolean checkedOut;
        private volatile boolean hasPermit;

        public ConnectionListenerWrapper(ConnectionListener connectionListener) {
            this(connectionListener, false, false);
        }

        public ConnectionListenerWrapper(ConnectionListener connectionListener, boolean checkedOut) {
            this(connectionListener, checkedOut, false);
        }

        public ConnectionListenerWrapper(ConnectionListener connectionListener, boolean checkedOut, boolean hasPermit) {
            this.cl = connectionListener;
            this.checkedOut = checkedOut;
            this.hasPermit = hasPermit;
        }

        public ConnectionListener getConnectionListener() {
            return this.cl;
        }

        public boolean isCheckedOut() {
            return this.checkedOut;
        }

        public void setCheckedOut(boolean checkedOut) {
            this.checkedOut = checkedOut;
        }

        public boolean hasPermit() {
            return this.hasPermit;
        }

        public void setHasPermit(boolean hasPermit) {
            this.hasPermit = hasPermit;
        }
    }
}

