/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.impl;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.backend.spi.DeleteByQueryLuceneWork;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.serialization.impl.LuceneWorkHydrator;
import org.hibernate.search.indexes.serialization.impl.SerializationHelper;
import org.hibernate.search.indexes.serialization.spi.Deserializer;
import org.hibernate.search.indexes.serialization.spi.LuceneFieldContext;
import org.hibernate.search.indexes.serialization.spi.LuceneNumericFieldContext;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.serialization.spi.SerializationProvider;
import org.hibernate.search.indexes.serialization.spi.Serializer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LuceneWorkSerializerImpl
implements LuceneWorkSerializer {
    private static Log log = LoggerFactory.make();
    private final ExtendedSearchIntegrator searchIntegrator;
    private final SerializationProvider provider;

    public LuceneWorkSerializerImpl(SerializationProvider provider, ExtendedSearchIntegrator searchIntegrator) {
        this.provider = provider;
        this.searchIntegrator = searchIntegrator;
        if (provider == null) {
            throw log.parametersShouldNotBeNull("provider");
        }
        if (searchIntegrator == null) {
            throw log.parametersShouldNotBeNull("searchIntegrator");
        }
    }

    @Override
    public byte[] toSerializedModel(List<LuceneWork> works) {
        try {
            Serializer serializer = this.provider.getSerializer();
            serializer.luceneWorks(works);
            for (LuceneWork work : works) {
                if (work instanceof OptimizeLuceneWork) {
                    serializer.addOptimizeAll();
                    continue;
                }
                if (work instanceof PurgeAllLuceneWork) {
                    serializer.addPurgeAll(work.getEntityClass().getName());
                    continue;
                }
                if (work instanceof FlushLuceneWork) {
                    serializer.addFlush();
                    continue;
                }
                if (work instanceof DeleteLuceneWork) {
                    this.processId(work, serializer);
                    serializer.addDelete(work.getEntityClass().getName());
                    continue;
                }
                if (work instanceof DeleteByQueryLuceneWork) {
                    serializer.addDeleteByQuery(work.getEntityClass().getName(), ((DeleteByQueryLuceneWork)work).getDeletionQuery());
                    continue;
                }
                if (work instanceof AddLuceneWork) {
                    this.serializeDocument(work.getDocument(), serializer);
                    this.processId(work, serializer);
                    serializer.addAdd(work.getEntityClass().getName(), work.getFieldToAnalyzerMap());
                    continue;
                }
                if (!(work instanceof UpdateLuceneWork)) continue;
                this.serializeDocument(work.getDocument(), serializer);
                this.processId(work, serializer);
                serializer.addUpdate(work.getEntityClass().getName(), work.getFieldToAnalyzerMap());
            }
            return serializer.serialize();
        }
        catch (RuntimeException e) {
            if (e instanceof SearchException) {
                throw e;
            }
            throw log.unableToSerializeLuceneWorks(e);
        }
    }

    private void processId(LuceneWork work, Serializer serializer) {
        Serializable id = work.getId();
        if (id instanceof Integer) {
            serializer.addIdAsInteger((Integer)id);
        } else if (id instanceof Long) {
            serializer.addIdAsLong((Long)id);
        } else if (id instanceof Float) {
            serializer.addIdAsFloat(((Float)id).floatValue());
        } else if (id instanceof Double) {
            serializer.addIdAsDouble((Double)id);
        } else if (id instanceof String) {
            serializer.addIdAsString(id.toString());
        } else {
            serializer.addIdSerializedInJava(SerializationHelper.toByteArray(id));
        }
    }

    @Override
    public List<LuceneWork> toLuceneWorks(byte[] data) {
        try {
            Deserializer deserializer = this.provider.getDeserializer();
            LuceneWorkHydrator hydrator = new LuceneWorkHydrator(this.searchIntegrator);
            deserializer.deserialize(data, hydrator);
            return hydrator.getLuceneWorks();
        }
        catch (RuntimeException e) {
            if (e instanceof SearchException) {
                throw e;
            }
            throw log.unableToReadSerializedLuceneWorks(e);
        }
    }

    private void serializeDocument(Document document, Serializer serializer) {
        List docFields = document.getFields();
        serializer.fields(docFields);
        for (IndexableField fieldable : docFields) {
            FieldType fieldType = (FieldType)fieldable.fieldType();
            FieldType.NumericType numericType = fieldType.numericType();
            if (numericType != null) {
                this.serializeNumericField(serializer, fieldable, fieldType, numericType);
                continue;
            }
            DocValuesType docValuesType = fieldType.docValuesType();
            if (docValuesType != null && docValuesType != DocValuesType.NONE) {
                this.serializeDocValues(serializer, (Field)fieldable);
                continue;
            }
            if (fieldable instanceof Field) {
                this.serializeField(serializer, (Field)fieldable);
                continue;
            }
            throw log.cannotSerializeCustomField(fieldable.getClass());
        }
        serializer.addDocument();
    }

    private void serializeDocValues(Serializer serializer, Field field) {
        DocValuesType docValuesType = field.fieldType().docValuesType();
        switch (docValuesType) {
            case NUMERIC: {
                serializer.addDocValuesFieldWithNumericValue(field.numericValue().longValue(), new LuceneFieldContext(field));
                break;
            }
            case SORTED_NUMERIC: {
                serializer.addDocValuesFieldWithNumericValue(field.numericValue().longValue(), new LuceneFieldContext(field));
                break;
            }
            case BINARY: {
                serializer.addDocValuesFieldWithBinaryValue(new LuceneFieldContext(field));
                break;
            }
            case SORTED: {
                serializer.addDocValuesFieldWithBinaryValue(new LuceneFieldContext(field));
                break;
            }
            case SORTED_SET: {
                serializer.addDocValuesFieldWithBinaryValue(new LuceneFieldContext(field));
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw log.unknownDocValuesTypeType(docValuesType.toString());
            }
        }
    }

    private void serializeField(Serializer serializer, Field fieldable) {
        if (fieldable.binaryValue() != null) {
            serializer.addFieldWithBinaryData(new LuceneFieldContext(fieldable));
        } else if (fieldable.stringValue() != null) {
            serializer.addFieldWithStringData(new LuceneFieldContext(fieldable));
        } else if (fieldable.readerValue() != null && fieldable.readerValue() instanceof Serializable) {
            serializer.addFieldWithSerializableReaderData(new LuceneFieldContext(fieldable));
        } else {
            if (fieldable.readerValue() != null) {
                throw log.conversionFromReaderToStringNotYetImplemented();
            }
            if (fieldable.tokenStreamValue() != null) {
                serializer.addFieldWithTokenStreamData(new LuceneFieldContext(fieldable));
            } else {
                throw log.unknownFieldType(fieldable.getClass());
            }
        }
    }

    private void serializeNumericField(Serializer serializer, IndexableField fieldable, FieldType fieldType, FieldType.NumericType numericType) {
        LuceneNumericFieldContext context = new LuceneNumericFieldContext(fieldType, fieldable.name(), fieldable.boost());
        switch (numericType) {
            case INT: {
                serializer.addIntNumericField(fieldable.numericValue().intValue(), context);
                break;
            }
            case LONG: {
                serializer.addLongNumericField(fieldable.numericValue().longValue(), context);
                break;
            }
            case FLOAT: {
                serializer.addFloatNumericField(fieldable.numericValue().floatValue(), context);
                break;
            }
            case DOUBLE: {
                serializer.addDoubleNumericField(fieldable.numericValue().doubleValue(), context);
                break;
            }
            default: {
                String dataType = numericType.toString();
                throw log.unknownNumericFieldType(dataType);
            }
        }
    }

    @Override
    public String describeSerializer() {
        return this.provider.toString();
    }
}

