/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.repository.wildfly;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jbpm.process.workitem.repository.service.RepoService;

@Path(value="/")
public class RepositoryService {
    @Inject
    private RepoService repoService;

    @GET
    @Path(value="/services")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    public Response getAllServices() {
        try {
            Response.ResponseBuilder responseBuilder = Response.ok((Object)this.repoService.getServices());
            return responseBuilder.build();
        }
        catch (Exception e) {
            throw new NotFoundException();
        }
    }

    @GET
    @Path(value="/services/count")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    public Response getAllServicesCount() {
        try {
            Response.ResponseBuilder responseBuilder = Response.ok((Object)this.repoService.getServices().size());
            return responseBuilder.build();
        }
        catch (Exception e) {
            throw new NotFoundException();
        }
    }

    @GET
    @Path(value="/services/{name}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    public Response getServiceByName(@PathParam(value="name") String name) {
        try {
            Response.ResponseBuilder responseBuilder = Response.ok((Object)this.repoService.getServiceByName(name));
            return responseBuilder.build();
        }
        catch (Exception e) {
            throw new NotFoundException();
        }
    }

    @GET
    @Path(value="/services/{name}/parameters")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    public Response getParametersByServiceName(@PathParam(value="name") String name) {
        try {
            Response.ResponseBuilder responseBuilder = Response.ok((Object)this.repoService.getServiceByName(name).getParameters());
            return responseBuilder.build();
        }
        catch (Exception e) {
            throw new NotFoundException();
        }
    }

    @GET
    @Path(value="/services/{name}/results")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    public Response getResultsByServiceName(@PathParam(value="name") String name) {
        try {
            Response.ResponseBuilder responseBuilder = Response.ok((Object)this.repoService.getServiceByName(name).getResults());
            return responseBuilder.build();
        }
        catch (Exception e) {
            throw new NotFoundException();
        }
    }

    @GET
    @Path(value="/services/{name}/mavendepends")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    public Response getMavenDependsByServiceName(@PathParam(value="name") String name) {
        try {
            Response.ResponseBuilder responseBuilder = Response.ok((Object)this.repoService.getServiceByName(name).getMavenDependencies());
            return responseBuilder.build();
        }
        catch (Exception e) {
            throw new NotFoundException();
        }
    }

    @GET
    @Path(value="/services/category/{category}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    public Response getResultsByServiceCategory(@PathParam(value="category") String category) {
        try {
            Response.ResponseBuilder responseBuilder = Response.ok((Object)this.repoService.getServicesByCategory(category));
            return responseBuilder.build();
        }
        catch (Exception e) {
            throw new NotFoundException();
        }
    }

    @GET
    @Path(value="/servicetriggers")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    public Response getTriggerServices() {
        try {
            Response.ResponseBuilder responseBuilder = Response.ok((Object)this.repoService.getTriggerServices());
            return responseBuilder.build();
        }
        catch (Exception e) {
            throw new NotFoundException();
        }
    }

    @GET
    @Path(value="/servicetriggers/count")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    public Response getTriggerServiceCounts() {
        try {
            Response.ResponseBuilder responseBuilder = Response.ok((Object)this.repoService.getTriggerServices().size());
            return responseBuilder.build();
        }
        catch (Exception e) {
            throw new NotFoundException();
        }
    }

    @GET
    @Path(value="/serviceactions")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    public Response getActionServices() {
        try {
            Response.ResponseBuilder responseBuilder = Response.ok((Object)this.repoService.getActionServices());
            return responseBuilder.build();
        }
        catch (Exception e) {
            throw new NotFoundException();
        }
    }

    @GET
    @Path(value="/serviceactions/count")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    public Response getActionServicesCount() {
        try {
            Response.ResponseBuilder responseBuilder = Response.ok((Object)this.repoService.getActionServices().size());
            return responseBuilder.build();
        }
        catch (Exception e) {
            throw new NotFoundException();
        }
    }
}

