/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.batch.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.batch.impl.DefaultBatch;

public class DefaultBatchManager
implements BatchManager {
    private Map<String, DefaultBatch> batches = Collections.emptyMap();
    private DefaultBatch activeBatch;

    @Override
    public boolean holdbackActiveBatch(String name) {
        if (this.activeBatch == null) {
            return false;
        }
        if (this.batches.containsKey(name)) {
            return false;
        }
        if (this.batches.isEmpty()) {
            this.batches = new HashMap<String, DefaultBatch>();
        }
        this.batches.put(name, this.activeBatch);
        this.activeBatch = null;
        return true;
    }

    @Override
    public boolean discardActiveBatch() {
        if (this.activeBatch == null) {
            return false;
        }
        this.activeBatch = null;
        return true;
    }

    @Override
    public Set<String> getHeldbackNames() {
        return this.batches.keySet();
    }

    @Override
    public Batch getActiveBatch() {
        return this.activeBatch;
    }

    @Override
    public boolean isHeldback(String name) {
        return this.batches.containsKey(name);
    }

    @Override
    public boolean activateNewBatch() {
        if (this.activeBatch != null) {
            return false;
        }
        this.activeBatch = new DefaultBatch();
        return true;
    }

    @Override
    public boolean isBatchActive() {
        return this.activeBatch != null;
    }

    @Override
    public boolean activateHeldbackBatch(String name) {
        if (this.activeBatch != null) {
            return false;
        }
        if (!this.batches.containsKey(name)) {
            return false;
        }
        this.activeBatch = this.batches.remove(name);
        return this.activeBatch != null;
    }
}

