/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.nio.channels.FileChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.xnio.FileAccess;
import org.xnio.FileSystemWatcher;
import org.xnio.IoUtils;
import org.xnio.LocalSocketAddress;
import org.xnio.ObjectProperties;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.PollingFileSystemWatcher;
import org.xnio.ReadPropertyAction;
import org.xnio.Version;
import org.xnio.XnioFileChannel;
import org.xnio.XnioProvider;
import org.xnio.XnioWorker;
import org.xnio._private.Messages;
import org.xnio.management.XnioProviderMXBean;
import org.xnio.management.XnioServerMXBean;
import org.xnio.management.XnioWorkerMXBean;
import org.xnio.ssl.JsseSslUtils;
import org.xnio.ssl.JsseXnioSsl;
import org.xnio.ssl.XnioSsl;

public abstract class Xnio {
    static final InetSocketAddress ANY_INET_ADDRESS = new InetSocketAddress(0);
    static final LocalSocketAddress ANY_LOCAL_ADDRESS = new LocalSocketAddress("");
    private static final EnumMap<FileAccess, OptionMap> FILE_ACCESS_OPTION_MAPS;
    private static final RuntimePermission ALLOW_BLOCKING_SETTING;
    public static final boolean NIO2 = true;
    private final String name;
    private static final ThreadLocal<Boolean> BLOCKING;

    protected Xnio(String name) {
        if (name == null) {
            throw Messages.msg.nullParameter("name");
        }
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean allowBlocking(boolean newSetting) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ALLOW_BLOCKING_SETTING);
        }
        ThreadLocal<Boolean> threadLocal = BLOCKING;
        try {
            boolean bl = threadLocal.get();
            return bl;
        }
        finally {
            threadLocal.set(newSetting);
        }
    }

    public static boolean isBlockingAllowed() {
        return BLOCKING.get();
    }

    public static void checkBlockingAllowed() throws IllegalStateException {
        if (!BLOCKING.get().booleanValue()) {
            throw Messages.msg.blockingNotAllowed();
        }
    }

    public static Xnio getInstance(final ClassLoader classLoader) {
        return Xnio.doGetInstance(null, AccessController.doPrivileged(new PrivilegedAction<ServiceLoader<XnioProvider>>(){

            @Override
            public ServiceLoader<XnioProvider> run() {
                return ServiceLoader.load(XnioProvider.class, classLoader);
            }
        }));
    }

    public static Xnio getInstance() {
        return Xnio.doGetInstance(null, AccessController.doPrivileged(new PrivilegedAction<ServiceLoader<XnioProvider>>(){

            @Override
            public ServiceLoader<XnioProvider> run() {
                return ServiceLoader.load(XnioProvider.class, Xnio.class.getClassLoader());
            }
        }));
    }

    public static Xnio getInstance(String provider, final ClassLoader classLoader) {
        return Xnio.doGetInstance(provider, AccessController.doPrivileged(new PrivilegedAction<ServiceLoader<XnioProvider>>(){

            @Override
            public ServiceLoader<XnioProvider> run() {
                return ServiceLoader.load(XnioProvider.class, classLoader);
            }
        }));
    }

    public static Xnio getInstance(String provider) {
        return Xnio.doGetInstance(provider, AccessController.doPrivileged(new PrivilegedAction<ServiceLoader<XnioProvider>>(){

            @Override
            public ServiceLoader<XnioProvider> run() {
                return ServiceLoader.load(XnioProvider.class, Xnio.class.getClassLoader());
            }
        }));
    }

    private static synchronized Xnio doGetInstance(String provider, ServiceLoader<XnioProvider> serviceLoader) {
        Iterator<XnioProvider> iterator = serviceLoader.iterator();
        block7: while (true) {
            try {
                while (iterator.hasNext()) {
                    XnioProvider xnioProvider = iterator.next();
                    try {
                        if (provider != null && !provider.equals(xnioProvider.getName())) continue block7;
                        return xnioProvider.getInstance();
                    }
                    catch (Throwable t) {
                        Messages.msg.debugf(t, "Not loading provider %s", (Object)xnioProvider.getName());
                    }
                }
            }
            catch (Throwable t) {
                Messages.msg.debugf(t, "Skipping non-loadable provider", new Object[0]);
                continue;
            }
            break;
        }
        try {
            Xnio xnio = OsgiSupport.doGetOsgiService();
            if (xnio != null) {
                return xnio;
            }
        }
        catch (NoClassDefFoundError xnio) {
        }
        catch (Throwable t) {
            Messages.msg.debugf(t, "Not using OSGi service", new Object[0]);
        }
        throw Messages.msg.noProviderFound();
    }

    public XnioSsl getSslProvider(OptionMap optionMap) throws GeneralSecurityException {
        return new JsseXnioSsl(this, optionMap);
    }

    public XnioSsl getSslProvider(KeyManager[] keyManagers, TrustManager[] trustManagers, OptionMap optionMap) throws GeneralSecurityException {
        return new JsseXnioSsl(this, optionMap, JsseSslUtils.createSSLContext(keyManagers, trustManagers, null, optionMap));
    }

    public FileChannel openFile(File file, OptionMap options) throws IOException {
        if (file == null) {
            throw Messages.msg.nullParameter("file");
        }
        if (options == null) {
            throw Messages.msg.nullParameter("options");
        }
        try {
            FileAccess fileAccess = options.get(Options.FILE_ACCESS, FileAccess.READ_WRITE);
            boolean append = options.get(Options.FILE_APPEND, false);
            boolean create = options.get(Options.FILE_CREATE, fileAccess != FileAccess.READ_ONLY);
            EnumSet<StandardOpenOption> openOptions = EnumSet.noneOf(StandardOpenOption.class);
            if (create) {
                openOptions.add(StandardOpenOption.CREATE);
            }
            if (fileAccess.isRead()) {
                openOptions.add(StandardOpenOption.READ);
            }
            if (fileAccess.isWrite()) {
                openOptions.add(StandardOpenOption.WRITE);
            }
            if (append) {
                openOptions.add(StandardOpenOption.APPEND);
            }
            Path path = file.toPath();
            return new XnioFileChannel(path.getFileSystem().provider().newFileChannel(path, openOptions, new FileAttribute[0]));
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public FileChannel openFile(String fileName, OptionMap options) throws IOException {
        if (fileName == null) {
            throw Messages.msg.nullParameter("fileName");
        }
        return this.openFile(new File(fileName), options);
    }

    public FileChannel openFile(File file, FileAccess access) throws IOException {
        if (access == null) {
            throw Messages.msg.nullParameter("access");
        }
        return this.openFile(file, FILE_ACCESS_OPTION_MAPS.get((Object)access));
    }

    public FileChannel openFile(String fileName, FileAccess access) throws IOException {
        if (access == null) {
            throw Messages.msg.nullParameter("access");
        }
        if (fileName == null) {
            throw Messages.msg.nullParameter("fileName");
        }
        return this.openFile(new File(fileName), FILE_ACCESS_OPTION_MAPS.get((Object)access));
    }

    protected FileChannel unwrapFileChannel(FileChannel src) {
        if (src instanceof XnioFileChannel) {
            return ((XnioFileChannel)src).getDelegate();
        }
        return src;
    }

    public XnioWorker.Builder createWorkerBuilder() {
        return new XnioWorker.Builder(this);
    }

    protected abstract XnioWorker build(XnioWorker.Builder var1);

    public XnioWorker createWorker(OptionMap optionMap) throws IOException, IllegalArgumentException {
        return this.createWorker(null, optionMap);
    }

    public XnioWorker createWorker(ThreadGroup threadGroup, OptionMap optionMap) throws IOException, IllegalArgumentException {
        return this.createWorker(threadGroup, optionMap, null);
    }

    public XnioWorker createWorker(ThreadGroup threadGroup, OptionMap optionMap, Runnable terminationTask) throws IOException, IllegalArgumentException {
        XnioWorker.Builder workerBuilder = this.createWorkerBuilder();
        workerBuilder.populateFromOptions(optionMap);
        workerBuilder.setThreadGroup(threadGroup);
        workerBuilder.setTerminationTask(terminationTask);
        return workerBuilder.build();
    }

    public FileSystemWatcher createFileSystemWatcher(String name, OptionMap options) {
        int pollInterval = options.get(Options.WATCHER_POLL_INTERVAL, 5000);
        boolean daemonThread = options.get(Options.THREAD_DAEMON, true);
        return new PollingFileSystemWatcher(name, pollInterval, daemonThread);
    }

    public final String getName() {
        return this.name;
    }

    public final String toString() {
        return String.format("XNIO provider \"%s\" <%s@%s>", this.getName(), this.getClass().getName(), Integer.toHexString(this.hashCode()));
    }

    protected static String getProperty(String name) {
        if (!name.startsWith("xnio.")) {
            throw Messages.msg.propReadForbidden();
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new ReadPropertyAction(name, null));
        }
        return System.getProperty(name);
    }

    protected static String getProperty(String name, String defaultValue) {
        if (!name.startsWith("xnio.")) {
            throw Messages.msg.propReadForbidden();
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new ReadPropertyAction(name, defaultValue));
        }
        return System.getProperty(name, defaultValue);
    }

    protected static Closeable register(XnioProviderMXBean providerMXBean) {
        try {
            ObjectName objectName = new ObjectName("org.xnio", ObjectProperties.properties(ObjectProperties.property("type", "Xnio"), ObjectProperties.property("provider", ObjectName.quote(providerMXBean.getName()))));
            MBeanHolder.MBEAN_SERVER.registerMBean(providerMXBean, objectName);
            return new MBeanCloseable(objectName);
        }
        catch (Throwable ignored) {
            return IoUtils.nullCloseable();
        }
    }

    protected static Closeable register(XnioWorkerMXBean workerMXBean) {
        try {
            ObjectName objectName = new ObjectName("org.xnio", ObjectProperties.properties(ObjectProperties.property("type", "Xnio"), ObjectProperties.property("provider", ObjectName.quote(workerMXBean.getProviderName())), ObjectProperties.property("worker", ObjectName.quote(workerMXBean.getName()))));
            MBeanHolder.MBEAN_SERVER.registerMBean(workerMXBean, objectName);
            return new MBeanCloseable(objectName);
        }
        catch (Throwable ignored) {
            return IoUtils.nullCloseable();
        }
    }

    protected static Closeable register(XnioServerMXBean serverMXBean) {
        try {
            ObjectName objectName = new ObjectName("org.xnio", ObjectProperties.properties(ObjectProperties.property("type", "Xnio"), ObjectProperties.property("provider", ObjectName.quote(serverMXBean.getProviderName())), ObjectProperties.property("worker", ObjectName.quote(serverMXBean.getWorkerName())), ObjectProperties.property("address", ObjectName.quote(serverMXBean.getBindAddress()))));
            MBeanHolder.MBEAN_SERVER.registerMBean(serverMXBean, objectName);
            return new MBeanCloseable(objectName);
        }
        catch (Throwable ignored) {
            return IoUtils.nullCloseable();
        }
    }

    static {
        ALLOW_BLOCKING_SETTING = new RuntimePermission("changeThreadBlockingSetting");
        Messages.msg.greeting(Version.VERSION);
        EnumMap<FileAccess, OptionMap> map = new EnumMap<FileAccess, OptionMap>(FileAccess.class);
        for (FileAccess access : FileAccess.values()) {
            map.put(access, OptionMap.create(Options.FILE_ACCESS, access));
        }
        FILE_ACCESS_OPTION_MAPS = map;
        BLOCKING = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.TRUE;
            }
        };
    }

    static class MBeanCloseable
    extends AtomicBoolean
    implements Closeable {
        private final ObjectName objectName;

        MBeanCloseable(ObjectName objectName) {
            this.objectName = objectName;
        }

        @Override
        public void close() {
            if (!this.getAndSet(true)) {
                try {
                    MBeanHolder.MBEAN_SERVER.unregisterMBean(this.objectName);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    static class OsgiSupport {
        OsgiSupport() {
        }

        static Xnio doGetOsgiService() {
            Bundle bundle2 = FrameworkUtil.getBundle(Xnio.class);
            BundleContext context = bundle2.getBundleContext();
            if (context == null) {
                throw new IllegalStateException("Bundle not started");
            }
            ServiceReference sr = context.getServiceReference(Xnio.class);
            if (sr == null) {
                return null;
            }
            return (Xnio)context.getService(sr);
        }
    }

    static final class MBeanHolder {
        private static final MBeanServer MBEAN_SERVER = AccessController.doPrivileged(new PrivilegedAction<MBeanServer>(){

            @Override
            public MBeanServer run() {
                return ManagementFactory.getPlatformMBeanServer();
            }
        });

        MBeanHolder() {
        }
    }
}

