/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jxc;

import com.sun.tools.jxc.NGCCRuntimeEx;
import com.sun.tools.jxc.gen.config.Config;
import com.sun.tools.jxc.gen.config.Schema;
import com.sun.tools.xjc.SchemaCache;
import com.sun.tools.xjc.api.Reference;
import com.sun.tools.xjc.util.ForkContentHandler;
import com.sun.xml.bind.v2.util.XmlFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.ValidatorHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class ConfigReader {
    private final Set<Reference> classesToBeIncluded = new HashSet<Reference>();
    private final SchemaOutputResolver schemaOutputResolver;
    private final ProcessingEnvironment env;
    private static SchemaCache configSchema = new SchemaCache("config.xsd", Config.class, true);

    public ConfigReader(ProcessingEnvironment env, Collection<? extends TypeElement> classes, File xmlFile, ErrorHandler errorHandler) throws SAXException, IOException {
        this.env = env;
        Config config = this.parseAndGetConfig(xmlFile, errorHandler, env.getOptions().containsKey("-disableXmlSecurity"));
        this.checkAllClasses(config, classes);
        String path = xmlFile.getAbsolutePath();
        String xmlPath = path.substring(0, path.lastIndexOf(File.separatorChar));
        this.schemaOutputResolver = this.createSchemaOutputResolver(config, xmlPath);
    }

    public Collection<Reference> getClassesToBeIncluded() {
        return this.classesToBeIncluded;
    }

    private void checkAllClasses(Config config, Collection<? extends TypeElement> rootClasses) {
        List includeRegexList = config.getClasses().getIncludes();
        List excludeRegexList = config.getClasses().getExcludes();
        block0: for (TypeElement typeElement : rootClasses) {
            boolean match;
            String qualifiedName = typeElement.getQualifiedName().toString();
            for (Pattern pattern : excludeRegexList) {
                match = this.checkPatternMatch(qualifiedName, pattern);
                if (!match) continue;
                continue block0;
            }
            for (Pattern pattern : includeRegexList) {
                match = this.checkPatternMatch(qualifiedName, pattern);
                if (!match) continue;
                this.classesToBeIncluded.add(new Reference(typeElement, this.env));
                continue block0;
            }
        }
    }

    public SchemaOutputResolver getSchemaOutputResolver() {
        return this.schemaOutputResolver;
    }

    private SchemaOutputResolver createSchemaOutputResolver(Config config, String xmlpath) {
        File baseDir = new File(xmlpath, config.getBaseDir().getPath());
        SchemaOutputResolverImpl outResolver = new SchemaOutputResolverImpl(baseDir);
        for (Schema schema : config.getSchema()) {
            String namespace = schema.getNamespace();
            File location = schema.getLocation();
            outResolver.addSchemaInfo(namespace, location);
        }
        return outResolver;
    }

    private boolean checkPatternMatch(String qualifiedName, Pattern pattern) {
        Matcher matcher = pattern.matcher(qualifiedName);
        return matcher.matches();
    }

    private Config parseAndGetConfig(File xmlFile, ErrorHandler errorHandler, boolean disableSecureProcessing) throws SAXException, IOException {
        XMLReader reader;
        try {
            SAXParserFactory factory = XmlFactory.createParserFactory((boolean)disableSecureProcessing);
            reader = factory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException e) {
            throw new Error(e);
        }
        NGCCRuntimeEx runtime = new NGCCRuntimeEx(errorHandler);
        ValidatorHandler validator = configSchema.newValidator();
        validator.setErrorHandler(errorHandler);
        reader.setContentHandler(new ForkContentHandler(validator, runtime));
        reader.setErrorHandler(errorHandler);
        Config config = new Config(runtime);
        runtime.setRootHandler(config);
        reader.parse(new InputSource(xmlFile.toURL().toExternalForm()));
        runtime.reset();
        return config;
    }

    private static final class SchemaOutputResolverImpl
    extends SchemaOutputResolver {
        private final File baseDir;
        private final Map<String, File> schemas = new HashMap<String, File>();

        public Result createOutput(String namespaceUri, String suggestedFileName) {
            if (this.schemas.containsKey(namespaceUri)) {
                File loc = this.schemas.get(namespaceUri);
                if (loc == null) {
                    return null;
                }
                loc.getParentFile().mkdirs();
                return new StreamResult(loc);
            }
            File schemaFile = new File(this.baseDir, suggestedFileName);
            return new StreamResult(schemaFile);
        }

        public SchemaOutputResolverImpl(File baseDir) {
            assert (baseDir != null);
            this.baseDir = baseDir;
        }

        public void addSchemaInfo(String namespaceUri, File location) {
            if (namespaceUri == null) {
                namespaceUri = "";
            }
            this.schemas.put(namespaceUri, location);
        }
    }
}

