/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.wildfly.clustering.web.cache.session.FilteringHttpSession;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

public class ImmutableFilteringHttpSession
implements FilteringHttpSession {
    private final ImmutableSession session;
    private final ServletContext context;

    public ImmutableFilteringHttpSession(ImmutableSession session, ServletContext context) {
        this.session = session;
        this.context = context;
    }

    @Override
    public <T> Map<String, T> getAttributes(Class<T> targetClass) {
        ImmutableSessionAttributes attributes = this.session.getAttributes();
        Set names = attributes.getAttributeNames();
        if (names.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, T> result = new HashMap<String, T>(names.size());
        for (String name : names) {
            Object attribute = attributes.getAttribute(name);
            if (!targetClass.isInstance(attribute)) continue;
            result.put(name, targetClass.cast(attribute));
        }
        return Collections.unmodifiableMap(result);
    }

    public long getCreationTime() {
        return this.session.getMetaData().getCreationTime().toEpochMilli();
    }

    public String getId() {
        return this.session.getId();
    }

    public long getLastAccessedTime() {
        return this.session.getMetaData().getLastAccessedTime().toEpochMilli();
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public void setMaxInactiveInterval(int interval) {
    }

    public int getMaxInactiveInterval() {
        return (int)this.session.getMetaData().getMaxInactiveInterval().get(ChronoUnit.SECONDS);
    }

    public Object getAttribute(String name) {
        return this.session.getAttributes().getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.session.getAttributes().getAttributeNames());
    }

    public void setAttribute(String name, Object value) {
    }

    public void removeAttribute(String name) {
    }

    public void invalidate() {
    }

    public boolean isNew() {
        return this.session.getMetaData().isNew();
    }

    @Deprecated
    public String[] getValueNames() {
        return Collections.list(this.getAttributeNames()).toArray(new String[0]);
    }

    @Deprecated
    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    @Deprecated
    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    @Deprecated
    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        return new HttpSessionContext(){

            public Enumeration<String> getIds() {
                return Collections.enumeration(Collections.emptyList());
            }

            public HttpSession getSession(String sessionId) {
                return null;
            }
        };
    }
}

