/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import org.infinispan.container.offheap.OffsetCalculator;

class ModulusOffsetCalculator
implements OffsetCalculator {
    private static final int HASH_BITS = Integer.MAX_VALUE;
    private final int offsetModulus;

    public ModulusOffsetCalculator(int numBlocks) {
        if (numBlocks <= 0 && (numBlocks & numBlocks - 1) == 0) {
            throw new IllegalArgumentException("maxOffset " + numBlocks + " must be greater than 0 and a power of 2");
        }
        this.offsetModulus = numBlocks;
    }

    @Override
    public int calculateOffsetUsingHashCode(int hashCode) {
        return ModulusOffsetCalculator.spread(hashCode) % this.offsetModulus;
    }

    private static int spread(int h) {
        return (h ^ h >>> 16) & Integer.MAX_VALUE;
    }
}

