/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.cache.impl.EncoderCache;
import org.infinispan.cache.impl.SimpleCacheImpl;
import org.infinispan.cache.impl.StatsCollectingCache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.dataconversion.ByteArrayWrapper;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.TranscoderMarshallerAdapter;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ContentTypeConfiguration;
import org.infinispan.configuration.cache.JMXStatisticsConfiguration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.ImmutableContext;
import org.infinispan.encoding.DataConversion;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.eviction.impl.ActivationManagerStub;
import org.infinispan.eviction.impl.PassivationManagerStub;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.interceptors.impl.CacheMgmtInterceptor;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.cluster.ClusterEventManager;
import org.infinispan.notifications.cachelistener.cluster.impl.ClusterEventManagerStub;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.manager.PersistenceManagerStub;
import org.infinispan.transaction.xa.recovery.RecoveryAdminOperations;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteAdminOperations;

public class InternalCacheFactory<K, V>
extends AbstractNamedCacheComponentFactory {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());

    public Cache<K, V> createCache(Configuration configuration, GlobalComponentRegistry globalComponentRegistry, String cacheName) throws CacheConfigurationException {
        try {
            if (configuration.compatibility().enabled()) {
                log.warnCompatibilityDeprecated(cacheName);
            }
            if (configuration.simpleCache()) {
                return this.createSimpleCache(configuration, globalComponentRegistry, cacheName);
            }
            return this.createAndWire(configuration, globalComponentRegistry, cacheName);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private AdvancedCache<K, V> createAndWire(Configuration configuration, GlobalComponentRegistry globalComponentRegistry, String cacheName) throws Exception {
        StreamingMarshaller marshaller = globalComponentRegistry.getOrCreateComponent(StreamingMarshaller.class);
        BiFunction actualBuilder = (kc, kv) -> new CacheImpl(cacheName);
        BiFunction usedBuilder = configuration.clustering().cacheMode().isReplicated() && !configuration.persistence().usingStores() && !configuration.transaction().transactionMode().isTransactional() && configuration.clustering().stateTransfer().awaitInitialTransfer() ? (kc, kv) -> {
            AbstractGetAdvancedCache cache = new GetReplCache((AdvancedCache)actualBuilder.apply((DataConversion)kc, (DataConversion)kv));
            if (configuration.jmxStatistics().available()) {
                cache = new StatsCache(cache);
            }
            if (configuration.clustering().partitionHandling().whenSplit() != PartitionHandling.ALLOW_READ_WRITES) {
                cache = new PartitionHandlingCache(cache);
            }
            return cache;
        } : actualBuilder;
        AdvancedCache<K, V> cache = this.buildEncodingCache(usedBuilder, configuration);
        this.bootstrap(cacheName, cache, configuration, globalComponentRegistry, marshaller);
        if (marshaller != null) {
            this.componentRegistry.wireDependencies(marshaller);
        }
        return cache;
    }

    private AdvancedCache<K, V> buildEncodingCache(BiFunction<DataConversion, DataConversion, AdvancedCache<K, V>> wrappedCacheBuilder, Configuration configuration) {
        ContentTypeConfiguration keyEncodingConfig = configuration.encoding().keyDataType();
        ContentTypeConfiguration valueEncodingConfig = configuration.encoding().valueDataType();
        MediaType keyType = keyEncodingConfig.mediaType();
        MediaType valueType = valueEncodingConfig.mediaType();
        DataConversion keyDataConversion = DataConversion.newKeyDataConversion(null, ByteArrayWrapper.class, keyType);
        DataConversion valueDataConversion = DataConversion.newValueDataConversion(null, ByteArrayWrapper.class, valueType);
        return new EncoderCache<K, V>(wrappedCacheBuilder.apply(keyDataConversion, valueDataConversion), keyDataConversion, valueDataConversion);
    }

    private AdvancedCache<K, V> createSimpleCache(Configuration configuration, GlobalComponentRegistry globalComponentRegistry, String cacheName) {
        JMXStatisticsConfiguration jmxStatistics = configuration.jmxStatistics();
        boolean statisticsAvailable = jmxStatistics != null && jmxStatistics.available();
        AdvancedCache<K, V> cache = statisticsAvailable ? this.buildEncodingCache((kc, vc) -> new StatsCollectingCache(cacheName, (DataConversion)kc, (DataConversion)vc), configuration) : this.buildEncodingCache((kc, vc) -> new SimpleCacheImpl(cacheName, (DataConversion)kc, (DataConversion)vc), configuration);
        this.configuration = configuration;
        this.componentRegistry = new ComponentRegistry(cacheName, configuration, cache, globalComponentRegistry, globalComponentRegistry.getClassLoader()){

            @Override
            protected void bootstrapComponents() {
                this.registerComponent(new ClusterEventManagerStub(), ClusterEventManager.class);
                this.registerComponent((Object)new PassivationManagerStub(), PassivationManager.class);
                this.registerComponent((Object)new ActivationManagerStub(), ActivationManager.class);
                this.registerComponent((Object)new PersistenceManagerStub(), PersistenceManager.class);
            }

            @Override
            public void cacheComponents() {
                this.getOrCreateComponent(InternalExpirationManager.class);
            }
        };
        this.basicComponentRegistry = this.componentRegistry.getComponent(BasicComponentRegistry.class);
        this.basicComponentRegistry.registerAlias(Cache.class.getName(), AdvancedCache.class.getName(), AdvancedCache.class);
        this.basicComponentRegistry.registerComponent(AdvancedCache.class, cache, false);
        this.componentRegistry.registerComponent((Object)new CacheJmxRegistration(), CacheJmxRegistration.class);
        this.componentRegistry.registerComponent((Object)new RollingUpgradeManager(), RollingUpgradeManager.class);
        return cache;
    }

    private void bootstrap(String cacheName, AdvancedCache<?, ?> cache, Configuration configuration, GlobalComponentRegistry globalComponentRegistry, StreamingMarshaller globalMarshaller) {
        this.configuration = configuration;
        this.componentRegistry = new ComponentRegistry(cacheName, configuration, cache, globalComponentRegistry, globalComponentRegistry.getClassLoader());
        EncoderRegistry encoderRegistry = globalComponentRegistry.getComponent(EncoderRegistry.class);
        if (configuration.compatibility().enabled() && configuration.compatibility().marshaller() != null) {
            Marshaller marshaller = configuration.compatibility().marshaller();
            this.componentRegistry.wireDependencies(marshaller);
            if (!encoderRegistry.isConversionSupported(MediaType.APPLICATION_OBJECT, marshaller.mediaType())) {
                encoderRegistry.registerTranscoder((Transcoder)new TranscoderMarshallerAdapter(marshaller));
            }
        }
        encoderRegistry.registerTranscoder((Transcoder)new TranscoderMarshallerAdapter((Marshaller)globalMarshaller));
        this.basicComponentRegistry = this.componentRegistry.getComponent(BasicComponentRegistry.class);
        this.basicComponentRegistry.registerAlias(Cache.class.getName(), AdvancedCache.class.getName(), AdvancedCache.class);
        this.basicComponentRegistry.registerComponent(AdvancedCache.class.getName(), cache, false);
        this.componentRegistry.registerComponent(new CacheJmxRegistration(), CacheJmxRegistration.class.getName(), true);
        if (configuration.transaction().recovery().enabled()) {
            this.componentRegistry.registerComponent(new RecoveryAdminOperations(), RecoveryAdminOperations.class.getName(), true);
        }
        if (configuration.sites().hasEnabledBackups()) {
            this.componentRegistry.registerComponent(new XSiteAdminOperations(), XSiteAdminOperations.class.getName(), true);
        }
        this.componentRegistry.registerComponent(new RollingUpgradeManager(), RollingUpgradeManager.class.getName(), true);
    }

    @Override
    public Object construct(String componentName) {
        throw new UnsupportedOperationException("Should never be invoked - this is a bootstrap factory.");
    }

    private static void assertKeyNotNull(Object key) {
        Objects.requireNonNull(key, "Null keys are not supported!");
    }

    private static void checkCanRun(Cache<?, ?> cache, String cacheName) {
        ComponentStatus status = cache.getStatus();
        if (status == ComponentStatus.FAILED || status == ComponentStatus.TERMINATED) {
            throw log.cacheIsTerminated(cacheName, status.toString());
        }
    }

    private static class GetReplCache<K, V>
    extends AbstractGetAdvancedCache<K, V, GetReplCache<K, V>> {
        @Inject
        private CacheNotifier<K, V> cacheNotifier;

        private GetReplCache(AdvancedCache<K, V> cache) {
            super(cache, new AbstractDelegatingAdvancedCache.AdvancedCacheWrapper<K, V>(){

                @Override
                public AdvancedCache<K, V> wrap(AdvancedCache<K, V> cache) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public AdvancedCache<K, V> wrap(AdvancedCache<K, V> self, AdvancedCache<K, V> newDelegate) {
                    GetReplCache oldCache = (GetReplCache)self;
                    GetReplCache newCache = new GetReplCache(newDelegate);
                    newCache.internalWire(oldCache);
                    return newCache;
                }
            });
        }

        @Override
        protected void internalWire(GetReplCache<K, V> cache) {
            this.cacheNotifier = cache.cacheNotifier;
            super.internalWire(cache);
        }

        @Override
        public V get(Object key) {
            Object value = super.get(key);
            if (value != null) {
                this.cacheNotifier.notifyCacheEntryVisited(key, value, true, ImmutableContext.INSTANCE, null);
                this.cacheNotifier.notifyCacheEntryVisited(key, value, false, ImmutableContext.INSTANCE, null);
            }
            return value;
        }
    }

    private static class StatsCache<K, V>
    extends AbstractGetAdvancedCache<K, V, StatsCache<K, V>> {
        @Inject
        private TimeService timeService;
        private CacheMgmtInterceptor interceptor;

        public StatsCache(AbstractGetAdvancedCache<K, V, ?> cache) {
            this((AdvancedCache<K, V>)cache);
        }

        private StatsCache(AdvancedCache<K, V> cache) {
            super(cache, new AbstractDelegatingAdvancedCache.AdvancedCacheWrapper<K, V>(){

                @Override
                public AdvancedCache<K, V> wrap(AdvancedCache<K, V> cache) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public AdvancedCache<K, V> wrap(AdvancedCache<K, V> self, AdvancedCache<K, V> newDelegate) {
                    StatsCache newCache = new StatsCache(newDelegate);
                    newCache.internalWire((StatsCache)self);
                    newCache.interceptorStart();
                    return newCache;
                }
            });
        }

        @Override
        protected void internalWire(StatsCache<K, V> cache) {
            this.timeService = cache.timeService;
            super.internalWire(cache);
        }

        private void interceptorStart() {
            this.interceptor = this.cache.getAsyncInterceptorChain().findInterceptorWithClass(CacheMgmtInterceptor.class);
        }

        @Override
        public V get(Object key) {
            Object value;
            if (this.interceptor == null) {
                this.interceptorStart();
            }
            if (this.interceptor.getStatisticsEnabled()) {
                long beginTime = this.timeService.time();
                value = this.cache.get(key);
                this.interceptor.addDataRead(value != null, this.timeService.timeDuration(beginTime, TimeUnit.NANOSECONDS));
            } else {
                value = this.cache.get(key);
            }
            return (V)value;
        }
    }

    private static class PartitionHandlingCache<K, V>
    extends AbstractGetAdvancedCache<K, V, PartitionHandlingCache<K, V>> {
        @Inject
        private PartitionHandlingManager manager;
        private final long bitFlags;

        public PartitionHandlingCache(AbstractGetAdvancedCache<K, V, ?> cache) {
            this(cache, 0L);
        }

        private PartitionHandlingCache(AdvancedCache<K, V> cache, long bitFlags) {
            super(cache, new AbstractDelegatingAdvancedCache.AdvancedCacheWrapper<K, V>(){

                @Override
                public AdvancedCache<K, V> wrap(AdvancedCache<K, V> cache) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public AdvancedCache<K, V> wrap(AdvancedCache<K, V> self, AdvancedCache<K, V> newDelegate) {
                    PartitionHandlingCache prev = (PartitionHandlingCache)self;
                    PartitionHandlingCache newCache = new PartitionHandlingCache(newDelegate, prev.bitFlags);
                    newCache.internalWire(prev);
                    return newCache;
                }
            });
            this.bitFlags = bitFlags;
        }

        @Override
        protected void internalWire(PartitionHandlingCache<K, V> cache) {
            this.manager = cache.manager;
            super.internalWire(cache);
        }

        @Override
        public V get(Object key) {
            Object value = this.cache.get(key);
            if (!EnumUtil.containsAny((long)this.bitFlags, (long)(FlagBitSets.CACHE_MODE_LOCAL | FlagBitSets.SKIP_OWNERSHIP_CHECK))) {
                this.manager.checkRead(key, this.bitFlags);
            }
            return (V)value;
        }

        @Override
        public AdvancedCache<K, V> withFlags(Flag ... flags) {
            long newFlags = EnumUtil.bitSetOf((Enum[])flags);
            long updatedFlags = EnumUtil.mergeBitSets((long)this.bitFlags, (long)newFlags);
            if (this.bitFlags != updatedFlags) {
                PartitionHandlingCache newCache = new PartitionHandlingCache(super.withFlags(flags), updatedFlags);
                newCache.internalWire(this);
                return newCache;
            }
            return this;
        }

        @Override
        public AdvancedCache<K, V> withFlags(Collection<Flag> flags) {
            long newFlags = EnumUtil.bitSetOf(flags);
            long updatedFlags = EnumUtil.mergeBitSets((long)this.bitFlags, (long)newFlags);
            if (this.bitFlags != updatedFlags) {
                PartitionHandlingCache newCache = new PartitionHandlingCache(super.withFlags(flags), updatedFlags);
                newCache.internalWire(this);
                return newCache;
            }
            return this;
        }

        @Override
        public AdvancedCache<K, V> noFlags() {
            if (this.bitFlags != 0L) {
                PartitionHandlingCache newCache = new PartitionHandlingCache(super.noFlags(), 0L);
                newCache.internalWire(this);
                return newCache;
            }
            return this;
        }
    }

    private static abstract class AbstractGetAdvancedCache<K, V, T extends AbstractGetAdvancedCache<K, V, T>>
    extends AbstractDelegatingAdvancedCache<K, V> {
        @Inject
        protected ComponentRegistry componentRegistry;

        public AbstractGetAdvancedCache(AdvancedCache<K, V> cache, AbstractDelegatingAdvancedCache.AdvancedCacheWrapper<K, V> wrapper) {
            super(cache, wrapper);
        }

        @Inject
        public void wireRealCache() {
            this.componentRegistry.wireDependencies(this.cache);
        }

        protected void internalWire(T cache) {
            this.componentRegistry = ((AbstractGetAdvancedCache)cache).componentRegistry;
            this.wireRealCache();
        }

        @Override
        public V get(Object key) {
            InternalCacheFactory.assertKeyNotNull(key);
            InternalCacheFactory.checkCanRun(this.cache, this.cache.getName());
            InternalCacheEntry ice = this.getDataContainer().get(key);
            if (ice != null) {
                return ice.getValue();
            }
            return null;
        }

        @Override
        public V getOrDefault(Object key, V defaultValue) {
            V value = this.get(key);
            return value != null ? value : defaultValue;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        @Override
        public CompletableFuture<V> getAsync(K key) {
            try {
                return CompletableFuture.completedFuture(this.get(key));
            }
            catch (Throwable t) {
                return CompletableFutures.completedExceptionFuture(t);
            }
        }
    }
}

