/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.ServiceValueCaptorServiceConfigurator;
import org.jboss.as.clustering.controller.ServiceValueRegistry;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.common.beans.property.BeanUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modcluster.ModClusterServiceMBean;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.modcluster.load.impl.DynamicLoadBalanceFactorProvider;
import org.jboss.modcluster.load.impl.SimpleLoadBalanceFactorProvider;
import org.jboss.modcluster.load.metric.LoadMetric;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.mod_cluster.BoottimeHandlerProvider;
import org.wildfly.extension.mod_cluster.ContainerEventHandlerAdapterServiceConfiguratorProvider;
import org.wildfly.extension.mod_cluster.ContainerEventHandlerServiceConfigurator;
import org.wildfly.extension.mod_cluster.CustomLoadMetricResourceDefinition;
import org.wildfly.extension.mod_cluster.DynamicLoadProviderResourceDefinition;
import org.wildfly.extension.mod_cluster.LoadMetricEnum;
import org.wildfly.extension.mod_cluster.LoadMetricResourceDefinition;
import org.wildfly.extension.mod_cluster.ModClusterLogger;
import org.wildfly.extension.mod_cluster.ProxyConfigurationResourceDefinition;
import org.wildfly.extension.mod_cluster.ProxyConfigurationServiceConfigurator;
import org.wildfly.extension.mod_cluster.SimpleLoadProviderResourceDefinition;

class ModClusterSubsystemServiceHandler
implements ResourceServiceHandler {
    private final ServiceValueRegistry<ModClusterServiceMBean> registry;

    ModClusterSubsystemServiceHandler(ServiceValueRegistry<ModClusterServiceMBean> registry) {
        this.registry = registry;
    }

    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        if (!context.isBooting()) {
            return;
        }
        Resource subsystemResource = context.readResource(PathAddress.EMPTY_ADDRESS);
        if (subsystemResource.hasChildren(ProxyConfigurationResourceDefinition.WILDCARD_PATH.getKey())) {
            HashSet<String> adapterNames = new HashSet<String>();
            HashSet<LoadMetric> enabledMetrics = new HashSet<LoadMetric>();
            for (Resource.ResourceEntry proxyResource : subsystemResource.getChildren(ProxyConfigurationResourceDefinition.WILDCARD_PATH.getKey())) {
                String proxyName = proxyResource.getName();
                PathAddress proxyAddress = context.getCurrentAddress().append(new PathElement[]{ProxyConfigurationResourceDefinition.pathElement(proxyName)});
                adapterNames.add(proxyName);
                ModelNode proxyModel = Resource.Tools.readModel((Resource)proxyResource);
                ServiceTarget target = context.getServiceTarget();
                ProxyConfigurationServiceConfigurator configurationBuilder = new ProxyConfigurationServiceConfigurator(proxyAddress);
                configurationBuilder.configure(context, proxyModel).build(target).install();
                HashSet<LoadMetric> metrics = new HashSet<LoadMetric>();
                LoadBalanceFactorProvider loadProvider = this.getLoadProvider(proxyName, metrics, context, proxyModel);
                enabledMetrics.addAll(metrics);
                String listenerName = ProxyConfigurationResourceDefinition.Attribute.LISTENER.resolveModelAttribute((ExpressionResolver)context, proxyModel).asString();
                int statusInterval = ProxyConfigurationResourceDefinition.Attribute.STATUS_INTERVAL.resolveModelAttribute((ExpressionResolver)context, proxyModel).asInt();
                ContainerEventHandlerServiceConfigurator configurator = new ContainerEventHandlerServiceConfigurator(proxyAddress, loadProvider);
                configurator.build(target).install();
                new ServiceValueCaptorServiceConfigurator(this.registry.add(configurator.getServiceName())).build(target).install();
                for (ContainerEventHandlerAdapterServiceConfiguratorProvider provider : ServiceLoader.load(ContainerEventHandlerAdapterServiceConfiguratorProvider.class, ContainerEventHandlerAdapterServiceConfiguratorProvider.class.getClassLoader())) {
                    provider.getServiceConfigurator(proxyName, listenerName, Duration.ofSeconds(statusInterval)).configure(context).build(target).setInitialMode(ServiceController.Mode.PASSIVE).install();
                }
            }
            for (BoottimeHandlerProvider handler : ServiceLoader.load(BoottimeHandlerProvider.class, BoottimeHandlerProvider.class.getClassLoader())) {
                handler.performBoottime(context, adapterNames, enabledMetrics);
            }
        }
    }

    private LoadBalanceFactorProvider getLoadProvider(String proxyName, Set<LoadMetric> metrics, OperationContext context, ModelNode model) throws OperationFailedException {
        SimpleLoadBalanceFactorProvider load = null;
        if (model.get(SimpleLoadProviderResourceDefinition.PATH.getKeyValuePair()).isDefined()) {
            ModelNode simpleProviderModel = model.get(SimpleLoadProviderResourceDefinition.PATH.getKeyValuePair());
            int value = SimpleLoadProviderResourceDefinition.Attribute.FACTOR.resolveModelAttribute((ExpressionResolver)context, simpleProviderModel).asInt();
            SimpleLoadBalanceFactorProvider simpleLoadProvider = new SimpleLoadBalanceFactorProvider();
            simpleLoadProvider.setLoadBalanceFactor(value);
            load = simpleLoadProvider;
        }
        if (model.get(DynamicLoadProviderResourceDefinition.PATH.getKeyValuePair()).isDefined()) {
            ModelNode node = model.get(DynamicLoadProviderResourceDefinition.PATH.getKeyValuePair());
            int decayFactor = DynamicLoadProviderResourceDefinition.Attribute.DECAY.resolveModelAttribute((ExpressionResolver)context, node).asInt();
            int history = DynamicLoadProviderResourceDefinition.Attribute.HISTORY.resolveModelAttribute((ExpressionResolver)context, node).asInt();
            int initialLoad = DynamicLoadProviderResourceDefinition.Attribute.INITIAL_LOAD.resolveModelAttribute((ExpressionResolver)context, node).asInt();
            if (node.hasDefined(LoadMetricResourceDefinition.WILDCARD_PATH.getKey())) {
                this.addLoadMetrics(metrics, node.get(LoadMetricResourceDefinition.WILDCARD_PATH.getKey()), context);
            }
            if (node.hasDefined(CustomLoadMetricResourceDefinition.WILDCARD_PATH.getKey())) {
                this.addLoadMetrics(metrics, node.get(CustomLoadMetricResourceDefinition.WILDCARD_PATH.getKey()), context);
            }
            if (!metrics.isEmpty()) {
                DynamicLoadBalanceFactorProvider loadBalanceFactorProvider = new DynamicLoadBalanceFactorProvider(metrics, initialLoad);
                loadBalanceFactorProvider.setDecayFactor((float)decayFactor);
                loadBalanceFactorProvider.setHistory(history);
                load = loadBalanceFactorProvider;
            }
        }
        if (load == null) {
            ModClusterLogger.ROOT_LOGGER.usingSimpleLoadProvider(proxyName);
            load = new SimpleLoadBalanceFactorProvider();
        }
        return load;
    }

    private void addLoadMetrics(Set<LoadMetric> metrics, ModelNode nodes, OperationContext context) throws OperationFailedException {
        for (Property property1 : nodes.asPropertyList()) {
            ModelNode node = property1.getValue();
            double capacity = LoadMetricResourceDefinition.SharedAttribute.CAPACITY.resolveModelAttribute((ExpressionResolver)context, node).asDouble();
            int weight = LoadMetricResourceDefinition.SharedAttribute.WEIGHT.resolveModelAttribute((ExpressionResolver)context, node).asInt();
            Class<? extends LoadMetric> loadMetricClass = null;
            if (node.hasDefined(LoadMetricResourceDefinition.Attribute.TYPE.getName())) {
                String type = LoadMetricResourceDefinition.Attribute.TYPE.resolveModelAttribute((ExpressionResolver)context, node).asString();
                if (type.equals("mem")) {
                    ModClusterLogger.ROOT_LOGGER.unsupportedMetric(type);
                    continue;
                }
                LoadMetricEnum metric = LoadMetricEnum.forType(type);
                loadMetricClass = metric != null ? metric.getLoadMetricClass() : null;
            } else {
                String className = CustomLoadMetricResourceDefinition.Attribute.CLASS.resolveModelAttribute((ExpressionResolver)context, node).asString();
                String moduleName = CustomLoadMetricResourceDefinition.Attribute.MODULE.resolveModelAttribute((ExpressionResolver)context, node).asString();
                try {
                    Module module = Module.getContextModuleLoader().loadModule(moduleName);
                    loadMetricClass = module.getClassLoader().loadClass(className).asSubclass(LoadMetric.class);
                }
                catch (ModuleLoadException e) {
                    ModClusterLogger.ROOT_LOGGER.errorLoadingModuleForCustomMetric(moduleName, e);
                }
                catch (ClassNotFoundException e) {
                    ModClusterLogger.ROOT_LOGGER.errorAddingMetrics(e);
                }
            }
            if (loadMetricClass == null) continue;
            try {
                LoadMetric metric = loadMetricClass.newInstance();
                metric.setCapacity(capacity);
                metric.setWeight(weight);
                Properties props = new Properties();
                for (Property property : ModelNodes.optionalPropertyList((ModelNode)LoadMetricResourceDefinition.SharedAttribute.PROPERTY.resolveModelAttribute((ExpressionResolver)context, node)).orElse(Collections.emptyList())) {
                    props.put(property.getName(), property.getValue().asString());
                }
                if (!props.isEmpty()) {
                    try {
                        BeanUtils.mapJavaBeanProperties((Object)metric, (Properties)props, (boolean)true);
                    }
                    catch (Exception ex) {
                        ModClusterLogger.ROOT_LOGGER.errorApplyingMetricProperties(ex, loadMetricClass.getCanonicalName());
                        continue;
                    }
                }
                metrics.add(metric);
            }
            catch (IllegalAccessException | InstantiationException e) {
                ModClusterLogger.ROOT_LOGGER.errorAddingMetrics(e);
            }
        }
    }

    public void removeServices(OperationContext context, ModelNode model) {
    }
}

