/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.ContentType;
import org.jboss.as.patching.metadata.MiscContentItem;
import org.jboss.as.patching.metadata.ModuleItem;

class Location {
    private final ContentItem item;
    private final int hashCode;

    Location(ContentItem item) {
        this.item = item;
        this.hashCode = Location.hashCode(item);
    }

    public ContentItem getItem() {
        return this.item;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        return this.hashCode == location.hashCode;
    }

    static int hashCode(ContentItem item) {
        ContentType type = item.getContentType();
        switch (type) {
            case MODULE: 
            case BUNDLE: {
                ModuleItem module = (ModuleItem)item;
                String[] path = module.getName().split("\\.");
                return Location.hashCode(type.toString(), module.getSlot(), path);
            }
            case MISC: {
                MiscContentItem misc = (MiscContentItem)item;
                return Location.hashCode(type.toString(), misc.getName(), misc.getPath());
            }
        }
        throw new IllegalStateException();
    }

    static int hashCode(String root, String name, String ... path) {
        int hash = root.hashCode();
        for (String p : path) {
            hash = 31 * hash + p.hashCode();
        }
        hash = 31 * hash + name.hashCode();
        return hash;
    }
}

