/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.federation;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.federation.FederationAddressPolicyConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationPolicy;
import org.apache.activemq.artemis.core.config.federation.FederationPolicySet;
import org.apache.activemq.artemis.core.config.federation.FederationQueuePolicyConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationUpstreamConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.federation.Federation;
import org.apache.activemq.artemis.core.server.federation.FederationConnection;
import org.apache.activemq.artemis.core.server.federation.address.FederatedAddress;
import org.apache.activemq.artemis.core.server.federation.queue.FederatedQueue;

public class FederationUpstream {
    private final ActiveMQServer server;
    private final Federation federation;
    private final SimpleString name;
    private FederationConnection connection;
    private FederationUpstreamConfiguration config;
    private Map<String, FederatedQueue> federatedQueueMap = new HashMap<String, FederatedQueue>();
    private Map<String, FederatedAddress> federatedAddressMap = new HashMap<String, FederatedAddress>();
    private Exception circuitBreakerException;
    private long lastCreateClientSessionFactoryExceptionTimestamp;

    public FederationUpstream(ActiveMQServer server, Federation federation, String name, FederationUpstreamConfiguration config) {
        this.server = server;
        this.federation = federation;
        Objects.requireNonNull(config.getName());
        this.name = SimpleString.toSimpleString((String)config.getName());
        this.config = config;
        this.connection = new FederationConnection(server.getConfiguration(), name, config.getConnectionConfiguration());
    }

    public synchronized void start() {
        this.connection.start();
        for (FederatedQueue federatedQueue : this.federatedQueueMap.values()) {
            federatedQueue.start();
        }
        for (FederatedAddress federatedAddress : this.federatedAddressMap.values()) {
            federatedAddress.start();
        }
    }

    public synchronized void stop() {
        for (FederatedAddress federatedAddress : this.federatedAddressMap.values()) {
            federatedAddress.stop();
        }
        this.federatedAddressMap.clear();
        for (FederatedQueue federatedQueue : this.federatedQueueMap.values()) {
            federatedQueue.stop();
        }
        this.federatedQueueMap.clear();
        this.connection.stop();
    }

    public void deploy(Set<String> policyRefsToDeploy, Map<String, FederationPolicy> policyMap) throws ActiveMQException {
        this.deployPolicyRefs(policyRefsToDeploy, policyMap, 0);
    }

    private void deployPolicyRefs(Set<String> policyRefsToDeploy, Map<String, FederationPolicy> policyMap, int recursionDepth) throws ActiveMQException {
        for (String policyRef : policyRefsToDeploy) {
            FederationPolicy policy = policyMap.get(policyRef);
            if (policy != null) {
                if (policy instanceof FederationPolicySet) {
                    FederationPolicySet federationPolicySet = (FederationPolicySet)policy;
                    if (recursionDepth < 10) {
                        this.deployPolicyRefs(federationPolicySet.getPolicyRefs(), policyMap, ++recursionDepth);
                        continue;
                    }
                    ActiveMQServerLogger.LOGGER.federationAvoidStackOverflowPolicyRef(this.name.toString(), policyRef);
                    continue;
                }
                if (policy instanceof FederationQueuePolicyConfiguration) {
                    this.deploy((FederationQueuePolicyConfiguration)policy);
                    continue;
                }
                if (policy instanceof FederationAddressPolicyConfiguration) {
                    this.deploy((FederationAddressPolicyConfiguration)policy);
                    continue;
                }
                ActiveMQServerLogger.LOGGER.federationUnknownPolicyType(this.name.toString(), policyRef);
                continue;
            }
            ActiveMQServerLogger.LOGGER.federationCantFindPolicyRef(this.name.toString(), policyRef);
        }
    }

    public synchronized boolean deploy(FederationQueuePolicyConfiguration federatedQueueConfig) throws ActiveMQException {
        String name = federatedQueueConfig.getName();
        FederatedQueue existing = this.federatedQueueMap.get(name);
        if (existing == null || !existing.getConfig().equals(federatedQueueConfig)) {
            this.undeployQueue(name);
            FederatedQueue federatedQueue = new FederatedQueue(this.federation, federatedQueueConfig, this.server, this);
            this.federatedQueueMap.put(name, federatedQueue);
            this.federation.register(federatedQueue);
            if (this.connection.isStarted()) {
                federatedQueue.start();
            }
            return true;
        }
        return false;
    }

    public synchronized boolean deploy(FederationAddressPolicyConfiguration federatedAddressConfig) throws ActiveMQException {
        String name = federatedAddressConfig.getName();
        FederatedAddress existing = this.federatedAddressMap.get(name);
        if (existing == null || !existing.getConfig().equals(federatedAddressConfig)) {
            this.undeployAddress(name);
            FederatedAddress federatedAddress = new FederatedAddress(this.federation, federatedAddressConfig, this.server, this);
            this.federatedAddressMap.put(name, federatedAddress);
            this.federation.register(federatedAddress);
            if (this.connection.isStarted()) {
                federatedAddress.start();
            }
            return true;
        }
        return false;
    }

    private void undeployAddress(String name) {
        FederatedAddress federatedAddress = this.federatedAddressMap.remove(name);
        if (federatedAddress != null) {
            federatedAddress.stop();
            this.federation.unregister(federatedAddress);
        }
    }

    private void undeployQueue(String name) {
        FederatedQueue federatedQueue = this.federatedQueueMap.remove(name);
        if (federatedQueue != null) {
            federatedQueue.stop();
            this.federation.unregister(federatedQueue);
        }
    }

    public FederationUpstreamConfiguration getConfig() {
        return this.config;
    }

    public SimpleString getName() {
        return this.name;
    }

    public FederationConnection getConnection() {
        return this.connection;
    }

    public String getUser() {
        String user = this.config.getConnectionConfiguration().getUsername();
        if (user == null || user.isEmpty()) {
            return this.federation.getFederationUser();
        }
        return user;
    }

    public String getPassword() {
        String password = this.config.getConnectionConfiguration().getPassword();
        if (password == null || password.isEmpty()) {
            return this.federation.getFederationPassword();
        }
        return password;
    }

    public int getPriorityAdjustment() {
        return this.config.getConnectionConfiguration().getPriorityAdjustment();
    }
}

