/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin.time.impl;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.spi.EncodingBridge;
import org.hibernate.search.bridge.spi.IgnoreAnalyzerBridge;
import org.hibernate.search.bridge.spi.NullMarker;
import org.hibernate.search.bridge.util.impl.ToStringNullMarker;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DurationBridge
implements TwoWayFieldBridge,
IgnoreAnalyzerBridge,
EncodingBridge {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    public static final DurationBridge INSTANCE = new DurationBridge();

    private DurationBridge() {
    }

    @Override
    public String objectToString(Object object) {
        if (object == null) {
            return null;
        }
        return String.valueOf(this.toNanos((Duration)object));
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value != null) {
            Long nanos = this.toNanos((Duration)value);
            luceneOptions.addNumericFieldToDocument(name, nanos, document);
        }
    }

    private Long toNanos(Duration value) {
        try {
            Long nanos = value.toNanos();
            return nanos;
        }
        catch (ArithmeticException ae) {
            throw log.valueTooLargeForConversionException(Duration.class, value, ae);
        }
    }

    @Override
    public Object get(String name, Document document) {
        String nanosFromIndex = document.get(name);
        Long nanos = Long.valueOf(nanosFromIndex);
        return Duration.ofNanos(nanos);
    }

    @Override
    public NumericFieldSettingsDescriptor.NumericEncodingType getEncodingType() {
        return NumericFieldSettingsDescriptor.NumericEncodingType.LONG;
    }

    @Override
    public NullMarker createNullMarker(String indexNullAs) throws IllegalArgumentException {
        try {
            return new ToStringNullMarker(Long.parseLong(indexNullAs));
        }
        catch (NumberFormatException e) {
            throw log.invalidNullMarkerForLong(e);
        }
    }
}

