/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import org.hibernate.search.annotations.FacetEncodingType;
import org.hibernate.search.engine.metadata.impl.BackReference;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.DocumentFieldPath;

public class FacetMetadata {
    private final BackReference<DocumentFieldMetadata> sourceField;
    private final DocumentFieldPath path;
    private final boolean encodingAuto;
    private final FacetEncodingType encoding;

    private FacetMetadata(Builder builder) {
        this.sourceField = builder.sourceField;
        this.path = builder.path;
        this.encodingAuto = builder.encodingAuto;
        this.encoding = builder.encoding;
    }

    public DocumentFieldMetadata getSourceField() {
        return this.sourceField.get();
    }

    public String getAbsoluteName() {
        return this.path.getAbsoluteName();
    }

    public DocumentFieldPath getPath() {
        return this.path;
    }

    public boolean isEncodingAuto() {
        return this.encodingAuto;
    }

    public FacetEncodingType getEncoding() {
        return this.encoding;
    }

    public String toString() {
        return "FacetMetadata{sourceField='" + this.sourceField + '\'' + "path='" + this.path + '\'' + ", encoding=" + (Object)((Object)this.encoding) + '}';
    }

    public static class Builder {
        private final BackReference<DocumentFieldMetadata> sourceField;
        private final DocumentFieldPath path;
        private FacetEncodingType encoding = FacetEncodingType.AUTO;
        private boolean encodingAuto = true;

        public Builder(BackReference<DocumentFieldMetadata> sourceField, DocumentFieldPath path) {
            this.sourceField = sourceField;
            this.path = path;
        }

        public void setFacetEncoding(FacetEncodingType encoding) {
            this.encoding = encoding;
        }

        public void setFacetEncodingAuto(boolean encodingAuto) {
            this.encodingAuto = encodingAuto;
        }

        public FacetMetadata build() {
            return new FacetMetadata(this);
        }
    }
}

