/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.smallrye.openapi.api.models.ComponentsImpl;
import io.smallrye.openapi.api.models.ExternalDocumentationImpl;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.models.OperationImpl;
import io.smallrye.openapi.api.models.PathItemImpl;
import io.smallrye.openapi.api.models.PathsImpl;
import io.smallrye.openapi.api.models.callbacks.CallbackImpl;
import io.smallrye.openapi.api.models.examples.ExampleImpl;
import io.smallrye.openapi.api.models.headers.HeaderImpl;
import io.smallrye.openapi.api.models.info.ContactImpl;
import io.smallrye.openapi.api.models.info.InfoImpl;
import io.smallrye.openapi.api.models.info.LicenseImpl;
import io.smallrye.openapi.api.models.links.LinkImpl;
import io.smallrye.openapi.api.models.media.ContentImpl;
import io.smallrye.openapi.api.models.media.DiscriminatorImpl;
import io.smallrye.openapi.api.models.media.EncodingImpl;
import io.smallrye.openapi.api.models.media.MediaTypeImpl;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.models.media.XMLImpl;
import io.smallrye.openapi.api.models.parameters.ParameterImpl;
import io.smallrye.openapi.api.models.parameters.RequestBodyImpl;
import io.smallrye.openapi.api.models.responses.APIResponseImpl;
import io.smallrye.openapi.api.models.responses.APIResponsesImpl;
import io.smallrye.openapi.api.models.security.OAuthFlowImpl;
import io.smallrye.openapi.api.models.security.OAuthFlowsImpl;
import io.smallrye.openapi.api.models.security.ScopesImpl;
import io.smallrye.openapi.api.models.security.SecurityRequirementImpl;
import io.smallrye.openapi.api.models.security.SecuritySchemeImpl;
import io.smallrye.openapi.api.models.servers.ServerImpl;
import io.smallrye.openapi.api.models.servers.ServerVariableImpl;
import io.smallrye.openapi.api.models.servers.ServerVariablesImpl;
import io.smallrye.openapi.api.models.tags.TagImpl;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.Scopes;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.eclipse.microprofile.openapi.models.servers.ServerVariables;
import org.eclipse.microprofile.openapi.models.tags.Tag;

public class OpenApiParser {
    private static final Map<String, Encoding.Style> ENCODING_STYLE_LOOKUP;
    private static final Map<String, Parameter.Style> PARAMETER_STYLE_LOOKUP;
    private static final Map<String, Header.Style> HEADER_STYLE_LOOKUP;
    private static final Map<String, SecurityScheme.Type> SECURITY_SCHEME_TYPE_LOOKUP;
    private static final Map<String, SecurityScheme.In> SECURITY_SCHEME_IN_LOOKUP;
    private static final Map<String, Parameter.In> PARAMETER_IN_LOOKUP;
    private final JsonNode tree;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final OpenAPIImpl parse(URL url) throws IOException, ParseException {
        try {
            boolean isYaml;
            String fname = url.getFile();
            if (fname == null) {
                throw new IOException("No file name for URL: " + url.toURI().toString());
            }
            int lidx = fname.lastIndexOf(46);
            if (lidx == -1) throw new IOException("Invalid file name for URL: " + url.toURI().toString());
            if (lidx >= fname.length()) {
                throw new IOException("Invalid file name for URL: " + url.toURI().toString());
            }
            String ext = fname.substring(lidx + 1);
            boolean isJson = ext.equalsIgnoreCase("json");
            boolean bl = isYaml = ext.equalsIgnoreCase("yaml") || ext.equalsIgnoreCase("yml");
            if (!isJson && !isYaml) {
                throw new IOException("Invalid file extension for URL (expected json, yaml, or yml): " + url.toURI().toString());
            }
            try (InputStream stream = url.openStream();){
                OpenAPIImpl openAPIImpl = OpenApiParser.parse(stream, isJson ? OpenApiSerializer.Format.JSON : OpenApiSerializer.Format.YAML);
                return openAPIImpl;
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public static final OpenAPIImpl parse(InputStream stream, OpenApiSerializer.Format format) throws IOException {
        ObjectMapper mapper = format == OpenApiSerializer.Format.JSON ? new ObjectMapper() : new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode tree = mapper.readTree(stream);
        OpenApiParser parser = new OpenApiParser(tree);
        return parser.parse();
    }

    public OpenApiParser(JsonNode tree) {
        this.tree = tree;
    }

    private OpenAPIImpl parse() {
        OpenAPIImpl oai = new OpenAPIImpl();
        this.readOpenAPI(this.tree, oai);
        return oai;
    }

    private void readOpenAPI(JsonNode node, OpenAPIImpl model) {
        model.setOpenapi(JsonUtil.stringProperty(node, "openapi"));
        model.setInfo(this.readInfo(node.get("info")));
        model.setExternalDocs(this.readExternalDocs(node.get("externalDocs")));
        model.setServers(this.readServers(node.get("servers")));
        model.setSecurity(this.readSecurityRequirements(node.get("security")));
        model.setTags(this.readTags(node.get("tags")));
        model.setPaths(this.readPaths(node.get("paths")));
        model.setComponents(this.readComponents(node.get("components")));
        this.readExtensions(node, model);
    }

    private Info readInfo(JsonNode node) {
        if (node == null) {
            return null;
        }
        InfoImpl model = new InfoImpl();
        model.setTitle(JsonUtil.stringProperty(node, "title"));
        model.setDescription(JsonUtil.stringProperty(node, "description"));
        model.setTermsOfService(JsonUtil.stringProperty(node, "termsOfService"));
        model.setContact(this.readContact(node.get("contact")));
        model.setLicense(this.readLicense(node.get("license")));
        model.setVersion(JsonUtil.stringProperty(node, "version"));
        this.readExtensions(node, model);
        return model;
    }

    private Contact readContact(JsonNode node) {
        if (node == null) {
            return null;
        }
        ContactImpl model = new ContactImpl();
        model.setName(JsonUtil.stringProperty(node, "name"));
        model.setUrl(JsonUtil.stringProperty(node, "url"));
        model.setEmail(JsonUtil.stringProperty(node, "email"));
        this.readExtensions(node, model);
        return model;
    }

    private License readLicense(JsonNode node) {
        if (node == null) {
            return null;
        }
        LicenseImpl model = new LicenseImpl();
        model.setName(JsonUtil.stringProperty(node, "name"));
        model.setUrl(JsonUtil.stringProperty(node, "url"));
        this.readExtensions(node, model);
        return model;
    }

    private ExternalDocumentation readExternalDocs(JsonNode node) {
        if (node == null) {
            return null;
        }
        ExternalDocumentationImpl model = new ExternalDocumentationImpl();
        model.setDescription(JsonUtil.stringProperty(node, "description"));
        model.setUrl(JsonUtil.stringProperty(node, "url"));
        this.readExtensions(node, model);
        return model;
    }

    private List<Tag> readTags(JsonNode node) {
        if (node == null || !node.isArray()) {
            return null;
        }
        ArrayNode nodes = (ArrayNode)node;
        ArrayList<Tag> rval = new ArrayList<Tag>(nodes.size());
        for (JsonNode tagNode : nodes) {
            TagImpl model = new TagImpl();
            model.setName(JsonUtil.stringProperty(tagNode, "name"));
            model.setDescription(JsonUtil.stringProperty(tagNode, "description"));
            model.setExternalDocs(this.readExternalDocs(tagNode.get("externalDocs")));
            this.readExtensions(tagNode, model);
            rval.add(model);
        }
        return rval;
    }

    private List<Server> readServers(JsonNode node) {
        if (node == null || !node.isArray()) {
            return null;
        }
        ArrayNode nodes = (ArrayNode)node;
        ArrayList<Server> rval = new ArrayList<Server>(nodes.size());
        for (JsonNode serverNode : nodes) {
            ServerImpl model = new ServerImpl();
            model.setUrl(JsonUtil.stringProperty(serverNode, "url"));
            model.setDescription(JsonUtil.stringProperty(serverNode, "description"));
            model.setVariables(this.readServerVariables(serverNode.get("variables")));
            this.readExtensions(serverNode, model);
            rval.add(model);
        }
        return rval;
    }

    private ServerVariables readServerVariables(JsonNode node) {
        if (node == null) {
            return null;
        }
        ServerVariablesImpl model = new ServerVariablesImpl();
        Iterator iterator = node.fieldNames();
        while (iterator.hasNext()) {
            String fieldName = (String)iterator.next();
            if (fieldName.toLowerCase().startsWith("x-")) continue;
            JsonNode varNode = node.get(fieldName);
            ServerVariable varModel = this.readServerVariable(varNode);
            model.put(fieldName, varModel);
        }
        this.readExtensions(node, (Extensible<?>)model);
        return model;
    }

    private ServerVariable readServerVariable(JsonNode node) {
        if (node == null) {
            return null;
        }
        ServerVariableImpl model = new ServerVariableImpl();
        JsonNode enumNode = node.get("enum");
        if (enumNode != null && enumNode.isArray()) {
            ArrayList<String> enums = new ArrayList<String>(enumNode.size());
            for (JsonNode n : enumNode) {
                enums.add(n.asText());
            }
            model.setEnumeration(enums);
        }
        model.setDefaultValue(JsonUtil.stringProperty(node, "default"));
        model.setDescription(JsonUtil.stringProperty(node, "description"));
        this.readExtensions(node, model);
        return model;
    }

    private Paths readPaths(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        PathsImpl model = new PathsImpl();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            if (fieldName.startsWith("x-")) continue;
            model.addPathItem(fieldName, this.readPathItem(node.get(fieldName)));
        }
        this.readExtensions(node, (Extensible<?>)model);
        return model;
    }

    private Components readComponents(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        ComponentsImpl model = new ComponentsImpl();
        model.setSchemas(this.readSchemas(node.get("schemas")));
        model.setResponses(this.readResponses(node.get("responses")));
        model.setParameters(this.readParameters(node.get("parameters")));
        model.setExamples(this.readExamples(node.get("examples")));
        model.setRequestBodies(this.readRequestBodies(node.get("requestBodies")));
        model.setHeaders(this.readHeaders(node.get("headers")));
        model.setSecuritySchemes(this.readSecuritySchemes(node.get("securitySchemes")));
        model.setLinks(this.readLinks(node.get("links")));
        model.setCallbacks(this.readCallbacks(node.get("callbacks")));
        this.readExtensions(node, model);
        return model;
    }

    private Map<String, Schema> readSchemas(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        LinkedHashMap<String, Schema> models = new LinkedHashMap<String, Schema>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode childNode = node.get(fieldName);
            models.put(fieldName, this.readSchema(childNode));
        }
        return models;
    }

    private Schema readSchema(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        SchemaImpl model = new SchemaImpl();
        model.setRef(JsonUtil.stringProperty(node, "$ref"));
        model.setFormat(JsonUtil.stringProperty(node, "format"));
        model.setTitle(JsonUtil.stringProperty(node, "title"));
        model.setDescription(JsonUtil.stringProperty(node, "description"));
        model.setDefaultValue(this.readObject(node.get("default")));
        model.setMultipleOf(JsonUtil.bigDecimalProperty(node, "multipleOf"));
        model.setMaximum(JsonUtil.bigDecimalProperty(node, "maximum"));
        model.setExclusiveMaximum(JsonUtil.booleanProperty(node, "exclusiveMaximum"));
        model.setMinimum(JsonUtil.bigDecimalProperty(node, "minimum"));
        model.setExclusiveMinimum(JsonUtil.booleanProperty(node, "exclusiveMinimum"));
        model.setMaxLength(JsonUtil.intProperty(node, "maxLength"));
        model.setMinLength(JsonUtil.intProperty(node, "minLength"));
        model.setPattern(JsonUtil.stringProperty(node, "pattern"));
        model.setMaxItems(JsonUtil.intProperty(node, "maxItems"));
        model.setMinItems(JsonUtil.intProperty(node, "minItems"));
        model.setUniqueItems(JsonUtil.booleanProperty(node, "uniqueItems"));
        model.setMaxProperties(JsonUtil.intProperty(node, "maxProperties"));
        model.setMinProperties(JsonUtil.intProperty(node, "minProperties"));
        model.setRequired(this.readStringArray(node.get("required")));
        model.setEnumeration(this.readObjectArray(node.get("enum")));
        model.setType(this.readSchemaType(node.get("type")));
        model.setItems(this.readSchema(node.get("items")));
        model.setNot(this.readSchema(node.get("not")));
        model.setAllOf(this.readSchemaArray(node.get("allOf")));
        model.setProperties(this.readSchemas(node.get("properties")));
        if (node.has("additionalProperties") && node.get("additionalProperties").isObject()) {
            model.setAdditionalPropertiesSchema(this.readSchema(node.get("additionalProperties")));
        } else {
            model.setAdditionalPropertiesBoolean(JsonUtil.booleanProperty(node, "additionalProperties"));
        }
        model.setReadOnly(JsonUtil.booleanProperty(node, "readOnly"));
        model.setXml(this.readXML(node.get("xml")));
        model.setExternalDocs(this.readExternalDocs(node.get("externalDocs")));
        model.setExample(this.readObject(node.get("example")));
        model.setOneOf(this.readSchemaArray(node.get("oneOf")));
        model.setAnyOf(this.readSchemaArray(node.get("anyOf")));
        model.setNot(this.readSchema(node.get("not")));
        model.setDiscriminator(this.readDiscriminator(node.get("discriminator")));
        model.setNullable(JsonUtil.booleanProperty(node, "nullable"));
        model.setWriteOnly(JsonUtil.booleanProperty(node, "writeOnly"));
        model.setDeprecated(JsonUtil.booleanProperty(node, "deprecated"));
        this.readExtensions(node, model);
        return model;
    }

    private XML readXML(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        XMLImpl model = new XMLImpl();
        model.setName(JsonUtil.stringProperty(node, "name"));
        model.setNamespace(JsonUtil.stringProperty(node, "namespace"));
        model.setPrefix(JsonUtil.stringProperty(node, "prefix"));
        model.setAttribute(JsonUtil.booleanProperty(node, "attribute"));
        model.setWrapped(JsonUtil.booleanProperty(node, "wrapped"));
        this.readExtensions(node, model);
        return model;
    }

    private Discriminator readDiscriminator(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        DiscriminatorImpl model = new DiscriminatorImpl();
        model.setPropertyName(JsonUtil.stringProperty(node, "propertyName"));
        model.setMapping(this.readStringMap(node.get("mapping")));
        return model;
    }

    private Map<String, APIResponse> readResponses(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        LinkedHashMap<String, APIResponse> models = new LinkedHashMap<String, APIResponse>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode childNode = node.get(fieldName);
            models.put(fieldName, this.readAPIResponse(childNode));
        }
        return models;
    }

    private APIResponse readAPIResponse(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        APIResponseImpl model = new APIResponseImpl();
        model.setRef(JsonUtil.stringProperty(node, "$ref"));
        model.setDescription(JsonUtil.stringProperty(node, "description"));
        model.setHeaders(this.readHeaders(node.get("headers")));
        model.setContent(this.readContent(node.get("content")));
        model.setLinks(this.readLinks(node.get("links")));
        this.readExtensions(node, model);
        return model;
    }

    private Content readContent(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        ContentImpl model = new ContentImpl();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            model.addMediaType(fieldName, this.readMediaType(node.get(fieldName)));
        }
        return model;
    }

    private MediaType readMediaType(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        MediaTypeImpl model = new MediaTypeImpl();
        model.setSchema(this.readSchema(node.get("schema")));
        model.setExample(this.readObject(node.get("example")));
        model.setExamples(this.readExamples(node.get("examples")));
        model.setEncoding(this.readEncodings(node.get("encoding")));
        this.readExtensions(node, model);
        return model;
    }

    private Map<String, Encoding> readEncodings(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        LinkedHashMap<String, Encoding> encodings = new LinkedHashMap<String, Encoding>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String name = (String)fieldNames.next();
            encodings.put(name, this.readEncoding(node.get(name)));
        }
        return encodings;
    }

    private Encoding readEncoding(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        EncodingImpl model = new EncodingImpl();
        model.setContentType(JsonUtil.stringProperty(node, "contentType"));
        model.setHeaders(this.readHeaders(node.get("headers")));
        model.setStyle(this.readEncodingStyle(node.get("style")));
        model.setExplode(JsonUtil.booleanProperty(node, "explode"));
        model.setAllowReserved(JsonUtil.booleanProperty(node, "allowReserved"));
        this.readExtensions(node, model);
        return model;
    }

    private Encoding.Style readEncodingStyle(JsonNode node) {
        if (node == null || !node.isTextual()) {
            return null;
        }
        return ENCODING_STYLE_LOOKUP.get(node.asText());
    }

    private Map<String, Parameter> readParameters(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        LinkedHashMap<String, Parameter> models = new LinkedHashMap<String, Parameter>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode childNode = node.get(fieldName);
            models.put(fieldName, this.readParameter(childNode));
        }
        return models;
    }

    private Parameter readParameter(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        ParameterImpl model = new ParameterImpl();
        model.setRef(JsonUtil.stringProperty(node, "$ref"));
        model.setName(JsonUtil.stringProperty(node, "name"));
        model.setIn(this.readParameterIn(node.get("in")));
        model.setDescription(JsonUtil.stringProperty(node, "description"));
        model.setRequired(JsonUtil.booleanProperty(node, "required"));
        model.setSchema(this.readSchema(node.get("schema")));
        model.setAllowEmptyValue(JsonUtil.booleanProperty(node, "allowEmptyValue"));
        model.setDeprecated(JsonUtil.booleanProperty(node, "deprecated"));
        model.setStyle(this.readParameterStyle(node.get("style")));
        model.setExplode(JsonUtil.booleanProperty(node, "explode"));
        model.setAllowReserved(JsonUtil.booleanProperty(node, "allowReserved"));
        model.setExample(this.readObject(node.get("example")));
        model.setExamples(this.readExamples(node.get("examples")));
        model.setContent(this.readContent(node.get("content")));
        this.readExtensions(node, model);
        return model;
    }

    private Parameter.Style readParameterStyle(JsonNode node) {
        if (node == null || !node.isTextual()) {
            return null;
        }
        return PARAMETER_STYLE_LOOKUP.get(node.asText());
    }

    private Map<String, Example> readExamples(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        LinkedHashMap<String, Example> models = new LinkedHashMap<String, Example>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode childNode = node.get(fieldName);
            models.put(fieldName, this.readExample(childNode));
        }
        return models;
    }

    private Example readExample(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        ExampleImpl model = new ExampleImpl();
        model.setRef(JsonUtil.stringProperty(node, "$ref"));
        model.setSummary(JsonUtil.stringProperty(node, "summary"));
        model.setDescription(JsonUtil.stringProperty(node, "description"));
        model.setValue(this.readObject(node.get("value")));
        model.setExternalValue(JsonUtil.stringProperty(node, "externalValue"));
        this.readExtensions(node, model);
        return model;
    }

    private Map<String, RequestBody> readRequestBodies(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        LinkedHashMap<String, RequestBody> models = new LinkedHashMap<String, RequestBody>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode childNode = node.get(fieldName);
            models.put(fieldName, this.readRequestBody(childNode));
        }
        return models;
    }

    private RequestBody readRequestBody(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        RequestBodyImpl model = new RequestBodyImpl();
        model.setRef(JsonUtil.stringProperty(node, "$ref"));
        model.setDescription(JsonUtil.stringProperty(node, "description"));
        model.setContent(this.readContent(node.get("content")));
        model.setRequired(JsonUtil.booleanProperty(node, "required"));
        this.readExtensions(node, model);
        return model;
    }

    private Map<String, Header> readHeaders(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        LinkedHashMap<String, Header> models = new LinkedHashMap<String, Header>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode childNode = node.get(fieldName);
            models.put(fieldName, this.readHeader(childNode));
        }
        return models;
    }

    private Header readHeader(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        HeaderImpl model = new HeaderImpl();
        model.setRef(JsonUtil.stringProperty(node, "$ref"));
        model.setDescription(JsonUtil.stringProperty(node, "description"));
        model.setRequired(JsonUtil.booleanProperty(node, "required"));
        model.setDeprecated(JsonUtil.booleanProperty(node, "deprecated"));
        model.setAllowEmptyValue(JsonUtil.booleanProperty(node, "allowEmptyValue"));
        model.setStyle(this.readHeaderStyle(node.get("style")));
        model.setExplode(JsonUtil.booleanProperty(node, "explode"));
        model.setSchema(this.readSchema(node.get("schema")));
        model.setExample(this.readObject(node.get("example")));
        model.setExamples(this.readExamples(node.get("examples")));
        model.setContent(this.readContent(node.get("content")));
        this.readExtensions(node, model);
        return model;
    }

    private Header.Style readHeaderStyle(JsonNode node) {
        if (node == null || !node.isTextual()) {
            return null;
        }
        return HEADER_STYLE_LOOKUP.get(node.asText());
    }

    private Map<String, SecurityScheme> readSecuritySchemes(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        LinkedHashMap<String, SecurityScheme> models = new LinkedHashMap<String, SecurityScheme>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode childNode = node.get(fieldName);
            models.put(fieldName, this.readSecurityScheme(childNode));
        }
        return models;
    }

    private SecurityScheme readSecurityScheme(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        SecuritySchemeImpl model = new SecuritySchemeImpl();
        model.setRef(JsonUtil.stringProperty(node, "$ref"));
        model.setType(this.readSecuritySchemeType(node.get("type")));
        model.setDescription(JsonUtil.stringProperty(node, "description"));
        model.setName(JsonUtil.stringProperty(node, "name"));
        model.setIn(this.readSecuritySchemeIn(node.get("in")));
        model.setScheme(JsonUtil.stringProperty(node, "scheme"));
        model.setBearerFormat(JsonUtil.stringProperty(node, "bearerFormat"));
        model.setFlows(this.readOAuthFlows(node.get("flows")));
        model.setOpenIdConnectUrl(JsonUtil.stringProperty(node, "openIdConnectUrl"));
        this.readExtensions(node, model);
        return model;
    }

    private SecurityScheme.Type readSecuritySchemeType(JsonNode node) {
        if (node == null || !node.isTextual()) {
            return null;
        }
        return SECURITY_SCHEME_TYPE_LOOKUP.get(node.asText());
    }

    private SecurityScheme.In readSecuritySchemeIn(JsonNode node) {
        if (node == null || !node.isTextual()) {
            return null;
        }
        return SECURITY_SCHEME_IN_LOOKUP.get(node.asText());
    }

    private Parameter.In readParameterIn(JsonNode node) {
        if (node == null || !node.isTextual()) {
            return null;
        }
        return PARAMETER_IN_LOOKUP.get(node.asText());
    }

    private OAuthFlows readOAuthFlows(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        OAuthFlowsImpl model = new OAuthFlowsImpl();
        model.setImplicit(this.readOAuthFlow(node.get("implicit")));
        model.setPassword(this.readOAuthFlow(node.get("password")));
        model.setClientCredentials(this.readOAuthFlow(node.get("clientCredentials")));
        model.setAuthorizationCode(this.readOAuthFlow(node.get("authorizationCode")));
        this.readExtensions(node, model);
        return model;
    }

    private OAuthFlow readOAuthFlow(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        OAuthFlowImpl model = new OAuthFlowImpl();
        model.setAuthorizationUrl(JsonUtil.stringProperty(node, "authorizationUrl"));
        model.setTokenUrl(JsonUtil.stringProperty(node, "tokenUrl"));
        model.setRefreshUrl(JsonUtil.stringProperty(node, "refreshUrl"));
        model.setScopes(this.readScopes(node.get("scopes")));
        this.readExtensions(node, model);
        return model;
    }

    private Scopes readScopes(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        ScopesImpl model = new ScopesImpl();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            if (fieldName.startsWith("x-")) continue;
            String value = JsonUtil.stringProperty(node, fieldName);
            model.put(fieldName, value);
        }
        this.readExtensions(node, (Extensible<?>)model);
        return model;
    }

    private Map<String, Link> readLinks(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        LinkedHashMap<String, Link> models = new LinkedHashMap<String, Link>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode childNode = node.get(fieldName);
            models.put(fieldName, this.readLink(childNode));
        }
        return models;
    }

    private Link readLink(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        LinkImpl model = new LinkImpl();
        model.setRef(JsonUtil.stringProperty(node, "$ref"));
        model.setOperationRef(JsonUtil.stringProperty(node, "operationRef"));
        model.setOperationId(JsonUtil.stringProperty(node, "operationId"));
        model.setParameters(this.readLinkParameters(node.get("parameters")));
        model.setRequestBody(this.readObject(node.get("requestBody")));
        model.setDescription(JsonUtil.stringProperty(node, "description"));
        model.setServer(this.readServer(node.get("server")));
        this.readExtensions(node, model);
        return model;
    }

    private Map<String, Object> readLinkParameters(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        LinkedHashMap<String, Object> rval = new LinkedHashMap<String, Object>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            Object value = this.readObject(node.get(fieldName));
            rval.put(fieldName, value);
        }
        return rval;
    }

    private Server readServer(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        ServerImpl model = new ServerImpl();
        model.setUrl(JsonUtil.stringProperty(node, "url"));
        model.setDescription(JsonUtil.stringProperty(node, "description"));
        model.setVariables(this.readServerVariables(node.get("variables")));
        this.readExtensions(node, model);
        return model;
    }

    private Map<String, Callback> readCallbacks(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        LinkedHashMap<String, Callback> models = new LinkedHashMap<String, Callback>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode childNode = node.get(fieldName);
            models.put(fieldName, this.readCallback(childNode));
        }
        return models;
    }

    private Callback readCallback(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        CallbackImpl model = new CallbackImpl();
        model.setRef(JsonUtil.stringProperty(node, "$ref"));
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            if (fieldName.startsWith("x-") || fieldName.equals("$ref")) continue;
            model.put(fieldName, this.readPathItem(node.get(fieldName)));
        }
        this.readExtensions(node, (Extensible<?>)model);
        return model;
    }

    private PathItem readPathItem(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        PathItemImpl model = new PathItemImpl();
        model.setRef(JsonUtil.stringProperty(node, "$ref"));
        model.setSummary(JsonUtil.stringProperty(node, "summary"));
        model.setDescription(JsonUtil.stringProperty(node, "description"));
        model.setGET(this.readOperation(node.get("get")));
        model.setPUT(this.readOperation(node.get("put")));
        model.setPOST(this.readOperation(node.get("post")));
        model.setDELETE(this.readOperation(node.get("delete")));
        model.setOPTIONS(this.readOperation(node.get("options")));
        model.setHEAD(this.readOperation(node.get("head")));
        model.setPATCH(this.readOperation(node.get("patch")));
        model.setTRACE(this.readOperation(node.get("trace")));
        model.setParameters(this.readParameterList(node.get("parameters")));
        model.setServers(this.readServers(node.get("servers")));
        this.readExtensions(node, model);
        return model;
    }

    private Operation readOperation(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        OperationImpl model = new OperationImpl();
        model.setTags(this.readStringArray(node.get("tags")));
        model.setSummary(JsonUtil.stringProperty(node, "summary"));
        model.setDescription(JsonUtil.stringProperty(node, "description"));
        model.setExternalDocs(this.readExternalDocs(node.get("externalDocs")));
        model.setOperationId(JsonUtil.stringProperty(node, "operationId"));
        model.setParameters(this.readParameterList(node.get("parameters")));
        model.setRequestBody(this.readRequestBody(node.get("requestBody")));
        model.setResponses(this.readAPIResponses(node.get("responses")));
        model.setCallbacks(this.readCallbacks(node.get("callbacks")));
        model.setDeprecated(JsonUtil.booleanProperty(node, "deprecated"));
        model.setSecurity(this.readSecurityRequirements(node.get("security")));
        model.setServers(this.readServers(node.get("servers")));
        this.readExtensions(node, model);
        return model;
    }

    private APIResponses readAPIResponses(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        APIResponsesImpl model = new APIResponsesImpl();
        model.setDefaultValue(this.readAPIResponse(node.get("default")));
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            if ("default".equals(fieldName)) continue;
            model.addAPIResponse(fieldName, this.readAPIResponse(node.get(fieldName)));
        }
        return model;
    }

    private List<SecurityRequirement> readSecurityRequirements(JsonNode node) {
        if (node == null || !node.isArray()) {
            return null;
        }
        ArrayList<SecurityRequirement> model = new ArrayList<SecurityRequirement>(node.size());
        ArrayNode arrayNode = (ArrayNode)node;
        for (JsonNode arrayItem : arrayNode) {
            model.add(this.readSecurityRequirement(arrayItem));
        }
        return model;
    }

    private SecurityRequirement readSecurityRequirement(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        SecurityRequirementImpl model = new SecurityRequirementImpl();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode scopesNode = node.get(fieldName);
            List<String> scopes = this.readStringArray(scopesNode);
            if (scopes == null) {
                model.addScheme(fieldName);
                continue;
            }
            model.addScheme(fieldName, scopes);
        }
        return model;
    }

    private List<Parameter> readParameterList(JsonNode node) {
        if (node == null || !node.isArray()) {
            return null;
        }
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        ArrayNode arrayNode = (ArrayNode)node;
        for (JsonNode paramNode : arrayNode) {
            params.add(this.readParameter(paramNode));
        }
        return params;
    }

    private Schema.SchemaType readSchemaType(JsonNode node) {
        if (node == null || !node.isTextual()) {
            return null;
        }
        String strval = node.asText();
        return Schema.SchemaType.valueOf((String)strval.toUpperCase());
    }

    private List<String> readStringArray(JsonNode node) {
        if (node == null || !node.isArray()) {
            return null;
        }
        ArrayList<String> rval = new ArrayList<String>(node.size());
        ArrayNode arrayNode = (ArrayNode)node;
        for (JsonNode arrayItem : arrayNode) {
            if (arrayItem == null) continue;
            rval.add(arrayItem.asText());
        }
        return rval;
    }

    private List<Object> readObjectArray(JsonNode node) {
        if (node == null || !node.isArray()) {
            return null;
        }
        ArrayList<Object> rval = new ArrayList<Object>(node.size());
        ArrayNode arrayNode = (ArrayNode)node;
        for (JsonNode arrayItem : arrayNode) {
            if (arrayItem == null) continue;
            rval.add(this.readObject(arrayItem));
        }
        return rval;
    }

    private List<Schema> readSchemaArray(JsonNode node) {
        if (node == null || !node.isArray()) {
            return null;
        }
        ArrayList<Schema> rval = new ArrayList<Schema>(node.size());
        ArrayNode arrayNode = (ArrayNode)node;
        for (JsonNode arrayItem : arrayNode) {
            rval.add(this.readSchema(arrayItem));
        }
        return rval;
    }

    private Map<String, String> readStringMap(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        LinkedHashMap<String, String> rval = new LinkedHashMap<String, String>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            String value = JsonUtil.stringProperty(node, fieldName);
            rval.put(fieldName, value);
        }
        return rval;
    }

    private Object readObject(JsonNode node) {
        if (node == null) {
            return null;
        }
        if (node.isBigDecimal()) {
            return new BigDecimal(node.asText());
        }
        if (node.isBigInteger()) {
            return new BigInteger(node.asText());
        }
        if (node.isBoolean()) {
            return node.asBoolean();
        }
        if (node.isDouble()) {
            return node.asDouble();
        }
        if (node.isFloat()) {
            return node.asDouble();
        }
        if (node.isInt()) {
            return node.asInt();
        }
        if (node.isLong()) {
            return node.asLong();
        }
        if (node.isTextual()) {
            return node.asText();
        }
        if (node.isArray()) {
            ArrayNode arrayNode = (ArrayNode)node;
            ArrayList<Object> items = new ArrayList<Object>();
            for (JsonNode itemNode : arrayNode) {
                items.add(this.readObject(itemNode));
            }
            return items;
        }
        if (node.isObject()) {
            LinkedHashMap<String, Object> items = new LinkedHashMap<String, Object>();
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                String fieldName = (String)field.getKey();
                Object fieldValue = this.readObject((JsonNode)field.getValue());
                items.put(fieldName, fieldValue);
            }
            return items;
        }
        return null;
    }

    private void readExtensions(JsonNode node, Extensible<?> model) {
        Iterator iterator = node.fieldNames();
        while (iterator.hasNext()) {
            String fieldName = (String)iterator.next();
            if (!fieldName.toLowerCase().startsWith("x-")) continue;
            Object value = this.readObject(node.get(fieldName));
            model.addExtension(fieldName, value);
        }
    }

    static {
        Parameter.In[] parameterIns;
        SecurityScheme.In[] securitySchemeIns;
        SecurityScheme.Type[] securitySchemeTypes;
        Header.Style[] headerStyleValues;
        Parameter.Style[] parameterStyleValues;
        Encoding.Style[] encodingStyleValues;
        ENCODING_STYLE_LOOKUP = new LinkedHashMap<String, Encoding.Style>();
        PARAMETER_STYLE_LOOKUP = new LinkedHashMap<String, Parameter.Style>();
        HEADER_STYLE_LOOKUP = new LinkedHashMap<String, Header.Style>();
        SECURITY_SCHEME_TYPE_LOOKUP = new LinkedHashMap<String, SecurityScheme.Type>();
        SECURITY_SCHEME_IN_LOOKUP = new LinkedHashMap<String, SecurityScheme.In>();
        PARAMETER_IN_LOOKUP = new LinkedHashMap<String, Parameter.In>();
        for (Encoding.Style style : encodingStyleValues = Encoding.Style.values()) {
            ENCODING_STYLE_LOOKUP.put(style.toString(), style);
        }
        for (Parameter.Style style : parameterStyleValues = Parameter.Style.values()) {
            PARAMETER_STYLE_LOOKUP.put(style.toString(), style);
        }
        for (Header.Style style : headerStyleValues = Header.Style.values()) {
            HEADER_STYLE_LOOKUP.put(style.toString(), style);
        }
        for (SecurityScheme.Type type : securitySchemeTypes = SecurityScheme.Type.values()) {
            SECURITY_SCHEME_TYPE_LOOKUP.put(type.toString(), type);
        }
        for (SecurityScheme.In type : securitySchemeIns = SecurityScheme.In.values()) {
            SECURITY_SCHEME_IN_LOOKUP.put(type.toString(), type);
        }
        for (Parameter.In type : parameterIns = Parameter.In.values()) {
            PARAMETER_IN_LOOKUP.put(type.toString(), type);
        }
    }
}

