/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.distribution.ch.impl.AbstractConsistentHashFactory;
import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.distribution.ch.impl.OwnershipStatistics;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DefaultConsistentHashFactory
extends AbstractConsistentHashFactory<DefaultConsistentHash> {
    private static final Log log = LogFactory.getLog(DefaultConsistentHashFactory.class);

    @Override
    public DefaultConsistentHash create(Hash hashFunction, int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
        if (members.size() == 0) {
            throw new IllegalArgumentException("Can't construct a consistent hash without any members");
        }
        if (numOwners <= 0) {
            throw new IllegalArgumentException("The number of owners should be greater than 0");
        }
        this.checkCapacityFactors(members, capacityFactors);
        Builder builder = new Builder(hashFunction, numOwners, numSegments, members, capacityFactors);
        this.rebalanceBuilder(builder);
        return builder.build();
    }

    @Override
    public DefaultConsistentHash fromPersistentState(ScopedPersistentState state) {
        String consistentHashClass = state.getProperty("consistentHash");
        if (!DefaultConsistentHash.class.getName().equals(consistentHashClass)) {
            throw log.persistentConsistentHashMismatch(this.getClass().getName(), consistentHashClass);
        }
        return new DefaultConsistentHash(state);
    }

    @Override
    public DefaultConsistentHash updateMembers(DefaultConsistentHash baseCH, List<Address> actualMembers, Map<Address, Float> actualCapacityFactors) {
        boolean sameCapacityFactors;
        if (actualMembers.size() == 0) {
            throw new IllegalArgumentException("Can't construct a consistent hash without any members");
        }
        this.checkCapacityFactors(actualMembers, actualCapacityFactors);
        boolean bl = actualCapacityFactors == null ? baseCH.getCapacityFactors() == null : (sameCapacityFactors = actualCapacityFactors.equals(baseCH.getCapacityFactors()));
        if (actualMembers.equals(baseCH.getMembers()) && sameCapacityFactors) {
            return baseCH;
        }
        Builder builder = new Builder(baseCH, actualMembers, actualCapacityFactors);
        Builder balancedBuilder = null;
        for (int segment = 0; segment < baseCH.getNumSegments(); ++segment) {
            if (!builder.getOwners(segment).isEmpty()) continue;
            if (balancedBuilder == null) {
                balancedBuilder = new Builder(builder);
                this.rebalanceBuilder(balancedBuilder);
            }
            builder.addOwners(segment, balancedBuilder.getOwners(segment));
        }
        return builder.build();
    }

    @Override
    public DefaultConsistentHash rebalance(DefaultConsistentHash baseCH) {
        Builder builder = new Builder(baseCH);
        this.rebalanceBuilder(builder);
        DefaultConsistentHash balancedCH = builder.build();
        return balancedCH.equals(baseCH) ? baseCH : balancedCH;
    }

    @Override
    public DefaultConsistentHash union(DefaultConsistentHash dch1, DefaultConsistentHash dch2) {
        return dch1.union(dch2);
    }

    protected void rebalanceBuilder(Builder builder) {
        this.addPrimaryOwners(builder);
        this.addBackupOwners(builder);
    }

    protected void addPrimaryOwners(Builder builder) {
        this.addFirstOwner(builder);
        this.swapPrimaryOwnersWithBackups(builder);
        int actualNumOwners = builder.getActualNumOwners();
        this.replacePrimaryOwners(builder, actualNumOwners);
        this.replacePrimaryOwners(builder, actualNumOwners + 1);
    }

    private void addFirstOwner(Builder builder) {
        for (int segment = 0; segment < builder.getNumSegments(); ++segment) {
            Address newPrimary;
            if (builder.getOwners(segment).size() > 0 || (newPrimary = this.findNewPrimaryOwner(builder, builder.getMembers(), null)) == null) continue;
            builder.addPrimaryOwner(segment, newPrimary);
        }
    }

    protected void replacePrimaryOwners(Builder builder, int maxOwners) {
        boolean primaryOwnerReplaced = true;
        while (primaryOwnerReplaced) {
            Address worstNode = this.findWorstPrimaryOwner(builder, builder.getMembers());
            primaryOwnerReplaced = false;
            for (int segment = builder.getNumSegments() - 1; segment >= 0; --segment) {
                Address newPrimary;
                if (builder.getOwners(segment).size() >= maxOwners || !builder.getPrimaryOwner(segment).equals(worstNode) || (newPrimary = this.findNewPrimaryOwner(builder, builder.getMembers(), worstNode)) == null || builder.getOwners(segment).contains(newPrimary)) continue;
                builder.addPrimaryOwner(segment, newPrimary);
                primaryOwnerReplaced = true;
                worstNode = this.findWorstPrimaryOwner(builder, builder.getMembers());
            }
        }
    }

    protected void swapPrimaryOwnersWithBackups(Builder builder) {
        for (int segment = builder.getNumSegments() - 1; segment >= 0; --segment) {
            if (builder.getOwners(segment).isEmpty()) continue;
            Address primaryOwner = builder.getPrimaryOwner(segment);
            Address newPrimary = this.findNewPrimaryOwner(builder, builder.getBackupOwners(segment), primaryOwner);
            if (newPrimary == null) continue;
            builder.replacePrimaryOwnerWithBackup(segment, newPrimary);
        }
    }

    protected void addBackupOwners(Builder builder) {
        this.removeExtraBackupOwners(builder);
        this.doAddBackupOwners(builder);
        this.replaceBackupOwners(builder);
    }

    protected void removeExtraBackupOwners(Builder builder) {
        ArrayList<Address> untestedNodes = new ArrayList<Address>(builder.getMembers());
        while (!untestedNodes.isEmpty()) {
            boolean ownerRemoved = false;
            Address worstNode = this.findWorstBackupOwner(builder, untestedNodes);
            for (int segment = builder.getNumSegments() - 1; segment >= 0; --segment) {
                int ownerIdx;
                List<Address> owners = builder.getOwners(segment);
                if (owners.size() <= builder.getActualNumOwners() || (ownerIdx = owners.indexOf(worstNode)) <= 0) continue;
                builder.removeOwner(segment, worstNode);
                ownerRemoved = true;
                untestedNodes = new ArrayList<Address>(builder.getMembers());
                worstNode = this.findWorstBackupOwner(builder, untestedNodes);
            }
            if (ownerRemoved) continue;
            untestedNodes.remove(worstNode);
        }
    }

    private Address findWorstBackupOwner(Builder builder, List<Address> nodes) {
        Address worst = null;
        float maxSegmentsPerCapacity = -1.0f;
        for (Address owner : nodes) {
            float capacityFactor = builder.getCapacityFactor(owner);
            if (worst != null && !((float)(builder.getOwned(owner) - 1) >= capacityFactor * maxSegmentsPerCapacity)) continue;
            worst = owner;
            maxSegmentsPerCapacity = capacityFactor != 0.0f ? (float)(builder.getOwned(owner) - 1) / capacityFactor : 0.0f;
        }
        return worst;
    }

    protected void doAddBackupOwners(Builder builder) {
        for (int segment = 0; segment < builder.getNumSegments(); ++segment) {
            List<Address> owners = builder.getOwners(segment);
            while (owners.size() < builder.getActualNumOwners()) {
                Address newOwner = this.findNewBackupOwner(builder, owners, null);
                builder.addOwner(segment, newOwner);
            }
        }
    }

    protected void replaceBackupOwners(Builder builder) {
        ArrayList<Address> untestedNodes = new ArrayList<Address>(builder.getMembers());
        while (!untestedNodes.isEmpty()) {
            Address worstNode = this.findWorstBackupOwner(builder, untestedNodes);
            boolean backupOwnerReplaced = false;
            for (int segment = builder.getNumSegments() - 1; segment >= 0; --segment) {
                Address replacement;
                List<Address> owners = builder.getOwners(segment);
                int ownerIdx = owners.indexOf(worstNode);
                if (ownerIdx <= 0 || (replacement = this.findNewBackupOwner(builder, owners, worstNode)) == null) continue;
                builder.removeOwner(segment, worstNode);
                builder.addOwner(segment, replacement);
                backupOwnerReplaced = true;
                untestedNodes = new ArrayList<Address>(builder.getMembers());
                worstNode = this.findWorstBackupOwner(builder, untestedNodes);
            }
            if (backupOwnerReplaced) continue;
            untestedNodes.remove(worstNode);
        }
    }

    protected Address findNewBackupOwner(Builder builder, Collection<Address> excludes, Address owner) {
        Address best = null;
        float initialCapacityFactor = owner != null ? builder.getCapacityFactor(owner) : 0.0f;
        float bestSegmentsPerCapacity = initialCapacityFactor != 0.0f ? (float)(builder.getOwned(owner) - 1) / initialCapacityFactor : Float.MAX_VALUE;
        for (Address candidate : builder.getMembers()) {
            float capacityFactor;
            int owned;
            if (excludes != null && excludes.contains(candidate) || !((float)((owned = builder.getOwned(candidate)) + 1) <= (capacityFactor = builder.getCapacityFactor(candidate)) * bestSegmentsPerCapacity)) continue;
            best = candidate;
            bestSegmentsPerCapacity = (float)(owned + 1) / capacityFactor;
        }
        return best;
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass();
    }

    public int hashCode() {
        return 3853;
    }

    public static class Externalizer
    extends AbstractExternalizer<DefaultConsistentHashFactory> {
        public void writeObject(ObjectOutput output, DefaultConsistentHashFactory chf) throws IOException {
        }

        public DefaultConsistentHashFactory readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            return new DefaultConsistentHashFactory();
        }

        public Integer getId() {
            return 50;
        }

        public Set<Class<? extends DefaultConsistentHashFactory>> getTypeClasses() {
            return Collections.singleton(DefaultConsistentHashFactory.class);
        }
    }

    protected static class Builder
    extends AbstractConsistentHashFactory.Builder {
        private final int initialNumOwners;
        private final int actualNumOwners;
        private final List<Address>[] segmentOwners;
        private int modCount = 0;

        public Builder(Hash hashFunction, int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
            super(hashFunction, new OwnershipStatistics(members), members, capacityFactors);
            this.initialNumOwners = numOwners;
            this.actualNumOwners = this.computeActualNumOwners(numOwners, members, capacityFactors);
            this.segmentOwners = new List[numSegments];
            for (int segment = 0; segment < numSegments; ++segment) {
                this.segmentOwners[segment] = new ArrayList<Address>(this.actualNumOwners);
            }
        }

        public Builder(DefaultConsistentHash baseCH, List<Address> actualMembers, Map<Address, Float> actualCapacityFactors) {
            super(baseCH.getHashFunction(), new OwnershipStatistics(baseCH, actualMembers), actualMembers, actualCapacityFactors);
            int numSegments = baseCH.getNumSegments();
            HashSet<Address> actualMembersSet = new HashSet<Address>(actualMembers);
            List[] owners = new List[numSegments];
            for (int segment = 0; segment < numSegments; ++segment) {
                owners[segment] = new ArrayList<Address>(baseCH.locateOwnersForSegment(segment));
                owners[segment].retainAll(actualMembersSet);
            }
            this.initialNumOwners = baseCH.getNumOwners();
            this.actualNumOwners = this.computeActualNumOwners(this.initialNumOwners, actualMembers, actualCapacityFactors);
            this.segmentOwners = owners;
        }

        public Builder(DefaultConsistentHash baseCH) {
            this(baseCH, baseCH.getMembers(), baseCH.getCapacityFactors());
        }

        public Builder(Builder other) {
            super(other);
            int numSegments = other.getNumSegments();
            List[] owners = new List[numSegments];
            for (int segment = 0; segment < numSegments; ++segment) {
                owners[segment] = new ArrayList<Address>(other.segmentOwners[segment]);
            }
            this.initialNumOwners = other.initialNumOwners;
            this.actualNumOwners = other.actualNumOwners;
            this.segmentOwners = owners;
        }

        public int getActualNumOwners() {
            return this.actualNumOwners;
        }

        public int getNumSegments() {
            return this.segmentOwners.length;
        }

        public List<Address> getOwners(int segment) {
            return this.segmentOwners[segment];
        }

        public Address getPrimaryOwner(int segment) {
            return this.segmentOwners[segment].get(0);
        }

        public List<Address> getBackupOwners(int segment) {
            return this.segmentOwners[segment].subList(1, this.segmentOwners[segment].size());
        }

        public boolean addOwner(int segment, Address owner) {
            ++this.modCount;
            List<Address> thisSegmentOwners = this.segmentOwners[segment];
            if (thisSegmentOwners.contains(owner)) {
                return false;
            }
            thisSegmentOwners.add(owner);
            this.stats.incOwned(owner);
            if (thisSegmentOwners.size() == 1) {
                this.stats.incPrimaryOwned(owner);
            }
            return true;
        }

        public boolean addOwners(int segment, Collection<Address> newOwners) {
            boolean modified = false;
            for (Address owner : newOwners) {
                modified |= this.addOwner(segment, owner);
            }
            return modified;
        }

        public boolean removeOwner(int segment, Address owner) {
            boolean modified;
            ++this.modCount;
            List<Address> segmentOwners = this.segmentOwners[segment];
            if (segmentOwners.get(0).equals(owner)) {
                this.stats.decPrimaryOwned(owner);
            }
            if (modified = segmentOwners.remove(owner)) {
                this.stats.decOwned(owner);
            }
            return modified;
        }

        public void addPrimaryOwner(int segment, Address newPrimaryOwner) {
            ++this.modCount;
            List<Address> segmentOwners = this.segmentOwners[segment];
            int ownerIndex = segmentOwners.indexOf(newPrimaryOwner);
            if (ownerIndex >= 0) {
                throw new IllegalArgumentException("The new primary owner must not be a backup already");
            }
            if (!segmentOwners.isEmpty()) {
                Address oldPrimaryOwner = segmentOwners.get(0);
                this.stats.decPrimaryOwned(oldPrimaryOwner);
            }
            segmentOwners.add(0, newPrimaryOwner);
            this.stats.incOwned(newPrimaryOwner);
            this.stats.incPrimaryOwned(newPrimaryOwner);
        }

        public void replacePrimaryOwnerWithBackup(int segment, Address newPrimaryOwner) {
            ++this.modCount;
            List<Address> segmentOwners = this.segmentOwners[segment];
            int ownerIndex = segmentOwners.indexOf(newPrimaryOwner);
            if (ownerIndex <= 0) {
                throw new IllegalArgumentException("The new primary owner must already be a backup owner");
            }
            Address oldPrimaryOwner = segmentOwners.get(0);
            this.stats.decPrimaryOwned(oldPrimaryOwner);
            segmentOwners.remove(ownerIndex);
            segmentOwners.add(0, newPrimaryOwner);
            this.stats.incPrimaryOwned(newPrimaryOwner);
        }

        public DefaultConsistentHash build() {
            return new DefaultConsistentHash(this.hashFunction, this.initialNumOwners, this.segmentOwners.length, (List<Address>)this.members, this.capacityFactors, this.segmentOwners);
        }

        @Override
        public int getPrimaryOwned(Address node) {
            return this.stats.getPrimaryOwned(node);
        }

        public int getOwned(Address node) {
            return this.stats.getOwned(node);
        }

        public float getPrimaryOwnedPerCapacity(Address node) {
            float capacityFactor = this.getCapacityFactor(node);
            return capacityFactor != 0.0f ? (float)this.getPrimaryOwned(node) / capacityFactor : Float.MAX_VALUE;
        }

        public float getOwnedPerCapacity(Address node) {
            float capacityFactor = this.getCapacityFactor(node);
            return capacityFactor != 0.0f ? (float)this.getOwned(node) / capacityFactor : Float.MAX_VALUE;
        }

        public int computeActualNumOwners(int numOwners, List<Address> members, Map<Address, Float> capacityFactors) {
            int nodesWithLoad = members.size();
            if (capacityFactors != null) {
                nodesWithLoad = 0;
                for (Address node : members) {
                    if (capacityFactors.get(node).floatValue() == 0.0f) continue;
                    ++nodesWithLoad;
                }
            }
            return Math.min(numOwners, nodesWithLoad);
        }
    }
}

