/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;

public abstract class BaseRpcInterceptor
extends DDAsyncInterceptor {
    protected final boolean trace = this.getLog().isTraceEnabled();
    @Inject
    protected RpcManager rpcManager;
    @Inject
    protected ComponentRegistry componentRegistry;
    protected boolean defaultSynchronous;

    protected abstract Log getLog();

    @Start
    public void init() {
        this.defaultSynchronous = this.cacheConfiguration.clustering().cacheMode().isSynchronous();
    }

    protected final boolean isSynchronous(FlagAffectedCommand command) {
        if (command.hasAnyFlag(FlagBitSets.FORCE_SYNCHRONOUS)) {
            return true;
        }
        if (command.hasAnyFlag(FlagBitSets.FORCE_ASYNCHRONOUS)) {
            return false;
        }
        return this.defaultSynchronous;
    }

    protected final boolean isLocalModeForced(FlagAffectedCommand command) {
        if (command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
            if (this.trace) {
                this.getLog().trace("LOCAL mode forced on invocation.  Suppressing clustered events.");
            }
            return true;
        }
        return false;
    }

    protected boolean shouldInvokeRemoteTxCommand(TxInvocationContext ctx) {
        boolean shouldInvokeRemotely;
        if (!ctx.isOriginLocal()) {
            return false;
        }
        LocalTxInvocationContext localCtx = (LocalTxInvocationContext)ctx;
        if (((LocalTransaction)localCtx.getCacheTransaction()).getStateTransferFlag() == Flag.PUT_FOR_STATE_TRANSFER) {
            return false;
        }
        boolean bl = shouldInvokeRemotely = ctx.hasModifications() || !localCtx.getRemoteLocksAcquired().isEmpty() || ((LocalTransaction)localCtx.getCacheTransaction()).getTopologyId() != this.rpcManager.getTopologyId();
        if (this.trace) {
            this.getLog().tracef("Should invoke remotely? %b. hasModifications=%b, hasRemoteLocksAcquired=%b", shouldInvokeRemotely, ctx.hasModifications(), !localCtx.getRemoteLocksAcquired().isEmpty());
        }
        return shouldInvokeRemotely;
    }

    protected static void transactionRemotelyPrepared(TxInvocationContext ctx) {
        if (ctx.isOriginLocal()) {
            ((LocalTransaction)ctx.getCacheTransaction()).markPrepareSent();
        }
    }

    protected static void totalOrderTxCommit(TxInvocationContext ctx) {
        if (ctx.isOriginLocal()) {
            ((LocalTransaction)ctx.getCacheTransaction()).markCommitOrRollbackSent();
        }
    }

    protected static void totalOrderTxRollback(TxInvocationContext ctx) {
        if (ctx.isOriginLocal()) {
            ((LocalTransaction)ctx.getCacheTransaction()).markCommitOrRollbackSent();
        }
    }

    protected static boolean shouldTotalOrderRollbackBeInvokedRemotely(TxInvocationContext ctx) {
        return ctx.isOriginLocal() && ((LocalTransaction)ctx.getCacheTransaction()).isPrepareSent() && !((LocalTransaction)ctx.getCacheTransaction()).isCommitOrRollbackSent();
    }

    protected CompletionStage<Object> totalOrderPrepare(TxInvocationContext<?> ctx, PrepareCommand command, Collection<Address> recipients) {
        try {
            CompletionStage<Map<Address, Response>> remoteInvocation;
            if (recipients != null) {
                HashSet<Address> realRecipients = new HashSet<Address>(recipients);
                realRecipients.add(this.rpcManager.getAddress());
                remoteInvocation = this.rpcManager.invokeCommand(realRecipients, (ReplicableCommand)command, MapResponseCollector.ignoreLeavers(realRecipients.size()), this.rpcManager.getTotalSyncRpcOptions());
            } else {
                remoteInvocation = this.rpcManager.invokeCommandOnAll(command, MapResponseCollector.ignoreLeavers(), this.rpcManager.getTotalSyncRpcOptions());
            }
            return remoteInvocation.handle((responses, t) -> {
                BaseRpcInterceptor.transactionRemotelyPrepared(ctx);
                CompletableFutures.rethrowException(t);
                return null;
            });
        }
        catch (Throwable t2) {
            BaseRpcInterceptor.transactionRemotelyPrepared(ctx);
            throw t2;
        }
    }
}

