/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.notifications.cachelistener.cluster.RemoteClusterListener;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusterListenerRemoveCallable<K, V>
implements DistributedCallable<K, V, Void> {
    private static final Log log = LogFactory.getLog(ClusterListenerRemoveCallable.class);
    private static final boolean trace = log.isTraceEnabled();
    private transient Cache<K, V> cache;
    private final UUID identifier;

    public ClusterListenerRemoveCallable(UUID identifier) {
        this.identifier = identifier;
    }

    @Override
    public void setEnvironment(Cache<K, V> cache, Set<K> inputKeys) {
        this.cache = cache;
    }

    @Override
    public Void call() throws Exception {
        Set listeners = this.cache.getListeners();
        for (Object listener : listeners) {
            RemoteClusterListener clusterListener;
            if (!(listener instanceof RemoteClusterListener) || !this.identifier.equals((clusterListener = (RemoteClusterListener)listener).getId())) continue;
            if (trace) {
                log.tracef("Removing local cluster listener due to parent cluster listener was removed : %s", this.identifier);
            }
            clusterListener.removeListener();
        }
        return null;
    }

    public static class Externalizer
    extends AbstractExternalizer<ClusterListenerRemoveCallable> {
        public Set<Class<? extends ClusterListenerRemoveCallable>> getTypeClasses() {
            return Collections.singleton(ClusterListenerRemoveCallable.class);
        }

        public void writeObject(ObjectOutput output, ClusterListenerRemoveCallable object) throws IOException {
            output.writeObject(object.identifier);
        }

        public ClusterListenerRemoveCallable readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new ClusterListenerRemoveCallable((UUID)input.readObject());
        }

        public Integer getId() {
            return 67;
        }
    }
}

