/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.as.ejb3.subsystem.EjbNameRegexService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

class EJBNameRegexWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final EJBNameRegexWriteHandler INSTANCE = new EJBNameRegexWriteHandler((AttributeDefinition)EJB3SubsystemRootResourceDefinition.ALLOW_EJB_NAME_REGEX);
    private final AttributeDefinition attributeDefinition;

    private EJBNameRegexWriteHandler(AttributeDefinition attributeDefinition) {
        super(new AttributeDefinition[]{attributeDefinition});
        this.attributeDefinition = attributeDefinition;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.updateRegexAllowed(context, model);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.updateRegexAllowed(context, restored);
    }

    void updateRegexAllowed(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode allowRegex = this.attributeDefinition.resolveModelAttribute(context, model);
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController ejbNameServiceController = registry.getService(EjbNameRegexService.SERVICE_NAME);
        EjbNameRegexService service = (EjbNameRegexService)ejbNameServiceController.getValue();
        if (!allowRegex.isDefined()) {
            service.setEjbNameRegexAllowed(false);
        } else {
            service.setEjbNameRegexAllowed(allowRegex.asBoolean());
        }
    }
}

